/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.parsers;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.Properties;
import javax.xml.parsers.SecuritySupport;
import org.apache.servicemix.specs.locator.OsgiLocator;

final class FactoryFinder {
    private static boolean debug = false;
    static Properties cacheProps = new Properties();
    static boolean firstTime = true;
    private static final int DEFAULT_LINE_LENGTH = 80;

    private FactoryFinder() {
    }

    private static void dPrint(String msg) {
        if (debug) {
            System.err.println("JAXP: " + msg);
        }
    }

    static Object newInstance(String className, ClassLoader cl, boolean doFallback) throws ConfigurationError {
        try {
            Class<?> providerClass;
            if (cl == null) {
                providerClass = Class.forName(className);
            } else {
                try {
                    providerClass = cl.loadClass(className);
                }
                catch (ClassNotFoundException x) {
                    if (doFallback) {
                        cl = FactoryFinder.class.getClassLoader();
                        providerClass = cl != null ? cl.loadClass(className) : Class.forName(className);
                    }
                    throw x;
                }
            }
            Object instance = providerClass.newInstance();
            if (debug) {
                FactoryFinder.dPrint("created new instance of " + providerClass + " using ClassLoader: " + cl);
            }
            return instance;
        }
        catch (ClassNotFoundException x) {
            throw new ConfigurationError("Provider " + className + " not found", x);
        }
        catch (Exception x) {
            throw new ConfigurationError("Provider " + className + " could not be instantiated: " + x, x);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Object find(String factoryId, String fallbackClassName) throws ConfigurationError {
        Object provider;
        ClassLoader classLoader;
        block24: {
            classLoader = SecuritySupport.getContextClassLoader();
            if (classLoader == null && (classLoader = FactoryFinder.class.getClassLoader()) == null) {
                classLoader = ClassLoader.getSystemClassLoader();
            }
            if (debug) {
                FactoryFinder.dPrint("find factoryId =" + factoryId);
            }
            try {
                Class<?> factoryClass = FactoryFinder.class.getClassLoader() != null ? FactoryFinder.class.getClassLoader().loadClass(factoryId) : Class.forName(factoryId);
                Class<?> spiClass = OsgiLocator.locate(factoryClass, factoryId);
                if (spiClass != null) {
                    if (debug) {
                        FactoryFinder.dPrint("found osgi factory = " + spiClass.getName());
                    }
                    return spiClass.newInstance();
                }
            }
            catch (Throwable e) {
                // empty catch block
            }
            try {
                String systemProp = SecuritySupport.getSystemProperty(factoryId);
                if (systemProp != null) {
                    if (debug) {
                        FactoryFinder.dPrint("found system property, value=" + systemProp);
                    }
                    return FactoryFinder.newInstance(systemProp, classLoader, true);
                }
            }
            catch (SecurityException se) {
                // empty catch block
            }
            try {
                String javah = SecuritySupport.getSystemProperty("java.home");
                String configFile = javah + File.separator + "lib" + File.separator + "jaxp.properties";
                String factoryClassName = null;
                if (firstTime) {
                    Properties properties = cacheProps;
                    synchronized (properties) {
                        if (firstTime) {
                            File f = new File(configFile);
                            firstTime = false;
                            if (SecuritySupport.doesFileExist(f)) {
                                if (debug) {
                                    FactoryFinder.dPrint("Read properties file " + f);
                                }
                                cacheProps.load(SecuritySupport.getFileInputStream(f));
                            }
                        }
                    }
                }
                if ((factoryClassName = cacheProps.getProperty(factoryId)) != null) {
                    if (debug) {
                        FactoryFinder.dPrint("found in $java.home/jaxp.properties, value=" + factoryClassName);
                    }
                    return FactoryFinder.newInstance(factoryClassName, classLoader, true);
                }
            }
            catch (Exception ex) {
                if (!debug) break block24;
                ex.printStackTrace();
            }
        }
        if ((provider = FactoryFinder.findJarServiceProvider(factoryId)) != null) {
            return provider;
        }
        if (fallbackClassName == null) {
            throw new ConfigurationError("Provider for " + factoryId + " cannot be found", null);
        }
        if (debug) {
            FactoryFinder.dPrint("loaded from fallback value: " + fallbackClassName);
        }
        return FactoryFinder.newInstance(fallbackClassName, classLoader, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object findJarServiceProvider(String factoryId) throws ConfigurationError {
        BufferedReader rd;
        String serviceId = "META-INF/services/" + factoryId;
        InputStream is = null;
        ClassLoader cl = SecuritySupport.getContextClassLoader();
        if (cl != null) {
            is = SecuritySupport.getResourceAsStream(cl, serviceId);
            if (is == null) {
                cl = FactoryFinder.class.getClassLoader();
                if (cl == null) {
                    cl = ClassLoader.getSystemClassLoader();
                }
                is = SecuritySupport.getResourceAsStream(cl, serviceId);
            }
        } else {
            cl = FactoryFinder.class.getClassLoader();
            if (cl == null) {
                cl = ClassLoader.getSystemClassLoader();
            }
            is = SecuritySupport.getResourceAsStream(cl, serviceId);
        }
        if (is == null) {
            return null;
        }
        if (debug) {
            FactoryFinder.dPrint("found jar resource=" + serviceId + " using ClassLoader: " + cl);
        }
        try {
            rd = new BufferedReader(new InputStreamReader(is, "UTF-8"), 80);
        }
        catch (UnsupportedEncodingException e) {
            rd = new BufferedReader(new InputStreamReader(is), 80);
        }
        String factoryClassName = null;
        try {
            factoryClassName = rd.readLine();
        }
        catch (IOException x) {
            Object var7_9 = null;
            return var7_9;
        }
        finally {
            try {
                rd.close();
            }
            catch (IOException exc) {}
        }
        if (factoryClassName != null && !"".equals(factoryClassName)) {
            if (debug) {
                FactoryFinder.dPrint("found in resource, value=" + factoryClassName);
            }
            return FactoryFinder.newInstance(factoryClassName, cl, false);
        }
        return null;
    }

    static {
        try {
            String val = SecuritySupport.getSystemProperty("jaxp.debug");
            debug = val != null && !"false".equals(val);
        }
        catch (SecurityException se) {
            debug = false;
        }
    }

    static class ConfigurationError
    extends Error {
        private Exception exception;

        ConfigurationError(String msg, Exception x) {
            super(msg);
            this.exception = x;
        }

        Exception getException() {
            return this.exception;
        }
    }
}

