/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.dev;

import java.util.HashMap;
import java.util.Map;
import org.apache.felix.gogo.commands.Argument;
import org.apache.karaf.shell.console.OsgiCommandSupport;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;
import org.osgi.service.packageadmin.ExportedPackage;
import org.osgi.service.packageadmin.PackageAdmin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractBundleCommand
extends OsgiCommandSupport {
    @Argument(index=0, name="id", description="The bundle ID", required=true)
    Long id;
    private PackageAdmin admin;

    protected Object doExecute() throws Exception {
        ServiceReference ref = this.getBundleContext().getServiceReference(PackageAdmin.class.getName());
        if (ref == null) {
            System.out.println("PackageAdmin service is unavailable.");
            return null;
        }
        this.admin = (PackageAdmin)this.getService(PackageAdmin.class, ref);
        Bundle bundle = this.getBundleContext().getBundle(this.id.longValue());
        if (bundle == null) {
            System.err.println("Bundle ID " + this.id + " is invalid");
            return null;
        }
        this.doExecute(bundle);
        return null;
    }

    protected abstract void doExecute(Bundle var1) throws Exception;

    protected Map<String, Bundle> getWiredBundles(Bundle bundle) {
        HashMap<String, Bundle> exporters = new HashMap<String, Bundle>();
        for (ExportedPackage pkg : this.getPackageAdmin().getExportedPackages((Bundle)null)) {
            Bundle[] bundles = pkg.getImportingBundles();
            if (bundles == null) continue;
            for (Bundle importingBundle : bundles) {
                if (!bundle.equals(importingBundle) || pkg.getExportingBundle().getBundleId() == 0L || pkg.getExportingBundle().equals(bundle)) continue;
                exporters.put(pkg.getName(), pkg.getExportingBundle());
            }
        }
        return exporters;
    }

    protected PackageAdmin getPackageAdmin() {
        return this.admin;
    }
}

