/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.commands;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.LinkedList;
import java.util.List;
import jline.Terminal;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.apache.karaf.shell.console.AbstractAction;

@Command(scope="shell", name="more", description="File pager.")
public class MoreAction
extends AbstractAction {
    @Option(name="--lines", description="stop after N lines")
    int lines;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object doExecute() throws Exception {
        Terminal term = (Terminal)this.session.get(".jline.terminal");
        if (term == null || !this.isTty(System.out)) {
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
            while ((line = reader.readLine()) != null) {
                System.out.println(line);
            }
            return null;
        }
        boolean echo = term.isEchoEnabled();
        term.setEchoEnabled(false);
        try {
            if (this.lines == 0) {
                this.lines = term.getHeight();
            }
            LineSplitter reader = new LineSplitter(new BufferedReader(new InputStreamReader(System.in)), term.getWidth());
            int count = 0;
            while (true) {
                String line;
                if ((line = reader.readLine()) == null) {
                    Object var7_9 = null;
                    return var7_9;
                }
                System.out.println(line);
                if (++count < this.lines - 2) continue;
                int c = -1;
                while (c == -1) {
                    System.out.flush();
                    System.out.print("--More--");
                    System.out.flush();
                    c = this.session.getKeyboard().read();
                    switch (c) {
                        case -1: 
                        case 113: {
                            c = 113;
                            break;
                        }
                        case 10: 
                        case 13: 
                        case 14: {
                            --count;
                            System.out.print("\r          \r");
                            break;
                        }
                        case 32: {
                            count = 0;
                            System.out.print("\r          \r");
                            break;
                        }
                        default: {
                            c = -1;
                            System.out.print("\r          \r");
                        }
                    }
                    if (c != 113) continue;
                }
                if (c == 113) break;
            }
            Object var6_8 = null;
            return var6_8;
        }
        finally {
            term.setEchoEnabled(echo);
        }
    }

    protected boolean isTty(OutputStream out) {
        try {
            Method mth = out.getClass().getDeclaredMethod("getCurrent", new Class[0]);
            mth.setAccessible(true);
            Object current = mth.invoke((Object)out, new Object[0]);
            return current == this.session.getConsole();
        }
        catch (Throwable t) {
            return false;
        }
    }

    public static class LineSplitter {
        private final BufferedReader reader;
        private final int width;
        private final List<String> lines = new LinkedList<String>();

        public LineSplitter(BufferedReader reader, int width) {
            this.reader = reader;
            this.width = width;
        }

        public String readLine() throws IOException {
            if (this.lines.isEmpty()) {
                String str = this.reader.readLine();
                if (str == null) {
                    return null;
                }
                while (str.length() > this.width) {
                    this.lines.add(str.substring(0, this.width));
                    str = str.substring(this.width);
                }
                this.lines.add(str);
            }
            return this.lines.remove(0);
        }
    }
}

