/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.service.guard.impl;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import org.apache.karaf.service.guard.impl.GuardProxyCatalog;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.hooks.service.EventListenerHook;
import org.osgi.framework.hooks.service.ListenerHook;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GuardingEventHook
implements EventListenerHook {
    private final BundleContext bundleContext;
    private final GuardProxyCatalog guardProxyCatalog;
    private final Filter servicesFilter;
    private final Set<ServiceReference<?>> references = new ConcurrentSkipListSet();

    GuardingEventHook(BundleContext bundleContext, GuardProxyCatalog guardProxyCatalog, Filter securedServicesFilter) throws InvalidSyntaxException {
        this.bundleContext = bundleContext;
        this.guardProxyCatalog = guardProxyCatalog;
        this.servicesFilter = securedServicesFilter;
    }

    public void event(ServiceEvent event, Map<BundleContext, Collection<ListenerHook.ListenerInfo>> listeners) {
        if (this.servicesFilter == null) {
            return;
        }
        ServiceReference sr = event.getServiceReference();
        if (!this.servicesFilter.match(sr)) {
            return;
        }
        if (event.getType() == 1) {
            this.references.add(sr);
        } else if (event.getType() == 4 ? !this.references.remove(sr) : !this.references.contains(sr)) {
            return;
        }
        Iterator<BundleContext> i = listeners.keySet().iterator();
        while (i.hasNext()) {
            BundleContext bc = i.next();
            if (this.bundleContext.equals(bc) || bc.getBundle().getBundleId() == 0L || !this.guardProxyCatalog.handleProxificationForHook(sr)) continue;
            i.remove();
        }
    }
}

