/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.ssh;

import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.apache.karaf.shell.console.BlueprintContainerAware;
import org.apache.karaf.shell.console.OsgiCommandSupport;
import org.apache.sshd.SshServer;
import org.osgi.service.blueprint.container.BlueprintContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Command(scope="ssh", name="sshd", description="Creates a SSH server")
public class SshServerAction
extends OsgiCommandSupport
implements BlueprintContainerAware {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    @Option(name="-p", aliases={"--port"}, description="The port to setup the SSH server (Default: 8101)", required=false, multiValued=false)
    private int port = 8101;
    @Option(name="-b", aliases={"--background"}, description="The service will run in the background (Default: true)", required=false, multiValued=false)
    private boolean background = true;
    @Option(name="-i", aliases={"--idle-timeout"}, description="The session idle timeout (Default: 1800000ms)", required=false, multiValued=false)
    private long idleTimeout = 1800000L;
    @Option(name="-w", aliases={"--welcome-banner"}, description="The welcome banner to display when logging in", required=false, multiValued=false)
    private String welcomeBanner;
    private BlueprintContainer container;
    private String sshServerId;

    public void setBlueprintContainer(BlueprintContainer container) {
        assert (container != null);
        this.container = container;
    }

    public void setSshServerId(String sshServerId) {
        this.sshServerId = sshServerId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object doExecute() throws Exception {
        SshServer server = (SshServer)this.container.getComponentInstance(this.sshServerId);
        this.log.debug("Created server: {}", (Object)server);
        server.setPort(this.port);
        server.getProperties().put("idle-timeout", new Long(this.idleTimeout).toString());
        if (this.welcomeBanner != null) {
            server.getProperties().put("welcome-banner", this.welcomeBanner);
        }
        server.start();
        System.out.println("SSH server listening on port " + this.port + " (idle timeout " + this.idleTimeout + "ms)");
        if (!this.background) {
            SshServerAction sshServerAction = this;
            synchronized (sshServerAction) {
                this.log.debug("Waiting for server to shutdown");
                ((Object)((Object)this)).wait();
            }
            server.stop();
        }
        return null;
    }
}

