/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.admin.command;

import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.apache.karaf.admin.Instance;
import org.apache.karaf.admin.command.AdminCommandSupport;

@Command(scope="admin", name="start", description="Starts an existing container instance.")
public class StartCommand
extends AdminCommandSupport {
    @Option(name="-o", aliases={"--java-opts"}, description="Java options when launching the instance", required=false, multiValued=false)
    private String javaOpts;
    @Option(name="-w", aliases={"--wait"}, description="Wait for the instance to be fully started", required=false, multiValued=false)
    private boolean wait;
    @Argument(index=0, name="name", description="The name of the container instance", required=true, multiValued=false)
    private String instance = null;

    protected Object doExecute() throws Exception {
        Instance child = this.getExistingInstance(this.instance);
        if (this.wait) {
            String state = child.getState();
            if ("Stopped".equals(state)) {
                child.start(this.javaOpts);
            }
            if (!"Started".equals(state)) {
                do {
                    Thread.sleep(500L);
                } while ("Starting".equals(state = child.getState()));
            }
        } else {
            child.start(this.javaOpts);
        }
        return null;
    }
}

