/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.env;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.env.PropertySource;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class EnumerablePropertySource<T>
extends PropertySource<T> {
    protected static final String[] EMPTY_NAMES_ARRAY = new String[0];
    protected final Log logger = LogFactory.getLog(this.getClass());

    public EnumerablePropertySource(String name, T source) {
        super(name, source);
    }

    public abstract String[] getPropertyNames();

    @Override
    public boolean containsProperty(String name) {
        Assert.notNull(name, "property name must not be null");
        String[] stringArray = this.getPropertyNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String candidate = stringArray[n2];
            if (candidate.equals(name)) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)String.format("PropertySource [%s] contains '%s'", this.getName(), name));
                }
                return true;
            }
            ++n2;
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)String.format("PropertySource [%s] does not contain '%s'", this.getName(), name));
        }
        return false;
    }
}

