/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.messaging.tcp.reactor;

import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.springframework.messaging.Message;
import org.springframework.messaging.tcp.TcpConnection;
import org.springframework.messaging.tcp.reactor.PassThroughPromiseToListenableFutureAdapter;
import org.springframework.util.concurrent.ListenableFuture;
import reactor.fn.Functions;
import reactor.io.net.ChannelStream;
import reactor.rx.Promise;
import reactor.rx.Promises;
import reactor.rx.Streams;

public class Reactor2TcpConnection<P>
implements TcpConnection<P> {
    private final ChannelStream<Message<P>, Message<P>> channelStream;
    private final Promise<Void> closePromise;

    public Reactor2TcpConnection(ChannelStream<Message<P>, Message<P>> channelStream, Promise<Void> closePromise) {
        this.channelStream = channelStream;
        this.closePromise = closePromise;
    }

    @Override
    public ListenableFuture<Void> send(Message<P> message) {
        Promise afterWrite = Promises.prepare();
        this.channelStream.writeWith((Publisher)Streams.just(message)).subscribe((Subscriber)afterWrite);
        return new PassThroughPromiseToListenableFutureAdapter<Void>((Promise<Void>)afterWrite);
    }

    @Override
    public void onReadInactivity(Runnable runnable, long inactivityDuration) {
        this.channelStream.on().readIdle(inactivityDuration, Functions.consumer((Runnable)runnable));
    }

    @Override
    public void onWriteInactivity(Runnable runnable, long inactivityDuration) {
        this.channelStream.on().writeIdle(inactivityDuration, Functions.consumer((Runnable)runnable));
    }

    @Override
    public void close() {
        this.closePromise.onComplete();
    }
}

