/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.impl.console;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.management.ManagementFactory;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.felix.gogo.jline.ParsedLineImpl;
import org.apache.felix.gogo.jline.Shell;
import org.apache.felix.gogo.runtime.CommandSessionImpl;
import org.apache.felix.service.command.CommandProcessor;
import org.apache.felix.service.command.CommandSession;
import org.apache.felix.service.command.Job;
import org.apache.felix.service.threadio.ThreadIO;
import org.apache.karaf.shell.api.console.Command;
import org.apache.karaf.shell.api.console.History;
import org.apache.karaf.shell.api.console.Registry;
import org.apache.karaf.shell.api.console.Session;
import org.apache.karaf.shell.api.console.SessionFactory;
import org.apache.karaf.shell.api.console.Terminal;
import org.apache.karaf.shell.impl.action.command.ActionCommand;
import org.apache.karaf.shell.impl.action.command.ActionMaskingCallback;
import org.apache.karaf.shell.impl.console.Branding;
import org.apache.karaf.shell.impl.console.CommandNamesCompleter;
import org.apache.karaf.shell.impl.console.CommandsCompleter;
import org.apache.karaf.shell.impl.console.HistoryWrapper;
import org.apache.karaf.shell.impl.console.JLineTerminal;
import org.apache.karaf.shell.impl.console.RegistryImpl;
import org.apache.karaf.shell.impl.console.parsing.CommandLineParser;
import org.apache.karaf.shell.impl.console.parsing.KarafParser;
import org.apache.karaf.shell.support.ShellUtil;
import org.apache.karaf.shell.support.completers.FileCompleter;
import org.apache.karaf.shell.support.completers.FileOrUriCompleter;
import org.apache.karaf.shell.support.completers.UriCompleter;
import org.apache.karaf.util.filesstream.FilesStream;
import org.jline.builtins.Completers;
import org.jline.reader.Candidate;
import org.jline.reader.Completer;
import org.jline.reader.EndOfFileException;
import org.jline.reader.Highlighter;
import org.jline.reader.LineReader;
import org.jline.reader.LineReaderBuilder;
import org.jline.reader.MaskingCallback;
import org.jline.reader.ParsedLine;
import org.jline.reader.Parser;
import org.jline.reader.SyntaxError;
import org.jline.reader.UserInterruptException;
import org.jline.terminal.Size;
import org.jline.terminal.Terminal;
import org.jline.terminal.impl.DumbTerminal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsoleSessionImpl
implements Session {
    private static final String SUPPRESS_WELCOME = "karaf.shell.suppress.welcome";
    public static final String SHELL_INIT_SCRIPT = "karaf.shell.init.script";
    public static final String SHELL_HISTORY_MAXSIZE = "karaf.shell.history.maxSize";
    public static final String SHELL_HISTORY_FILE_MAXSIZE = "karaf.shell.history.file.maxSize";
    public static final String PROMPT = "PROMPT";
    public static final String DEFAULT_PROMPT = "\u001b[1m${USER}\u001b[0m@${APPLICATION}(${SUBSHELL})> ";
    public static final String RPROMPT = "RPROMPT";
    public static final String DEFAULT_RPROMPT = null;
    private static final Logger LOGGER = LoggerFactory.getLogger(ConsoleSessionImpl.class);
    volatile boolean running;
    private AtomicBoolean closed = new AtomicBoolean(false);
    final SessionFactory factory;
    final ThreadIO threadIO;
    final InputStream in;
    final PrintStream out;
    final PrintStream err;
    private Runnable closeCallback;
    final CommandSession session;
    final Registry registry;
    final Terminal terminal;
    final org.jline.terminal.Terminal jlineTerminal;
    final History history;
    final LineReader reader;
    final AggregateMaskingCallback maskingCallback;
    private Thread thread;
    private Properties brandingProps;

    public ConsoleSessionImpl(SessionFactory factory, CommandProcessor processor, ThreadIO threadIO, InputStream in, PrintStream out, PrintStream err, Terminal term, String encoding, Runnable closeCallback) {
        String maxFileSizeStr;
        this.factory = factory;
        this.threadIO = threadIO;
        this.in = in;
        this.out = out;
        this.err = err;
        this.closeCallback = closeCallback;
        if (term instanceof org.jline.terminal.Terminal) {
            this.terminal = term;
            this.jlineTerminal = (org.jline.terminal.Terminal)term;
        } else {
            if (term != null) {
                this.terminal = term;
                throw new UnsupportedOperationException();
            }
            try {
                this.jlineTerminal = new DumbTerminal(in, (OutputStream)out);
                this.terminal = new JLineTerminal(this.jlineTerminal);
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to create terminal", e);
            }
        }
        if (this.jlineTerminal.getSize().getColumns() == 0) {
            this.jlineTerminal.setSize(new Size(80, 24));
        }
        this.brandingProps = Branding.loadBrandingProperties(this.terminal.getClass().getName().endsWith("SshTerminal"));
        this.session = in == null || out == null || err == null ? processor.createSession(((org.jline.terminal.Terminal)this.terminal).input(), ((org.jline.terminal.Terminal)this.terminal).output(), ((org.jline.terminal.Terminal)this.terminal).output()) : processor.createSession(in, out, err);
        Completer builtinCompleter = this.createBuiltinCompleter();
        CommandsCompleter commandsCompleter = new CommandsCompleter(factory, this);
        Completer completer = (rdr, line, candidates) -> {
            builtinCompleter.complete(rdr, line, candidates);
            commandsCompleter.complete(rdr, line, candidates);
            this.merge(candidates);
        };
        this.maskingCallback = new AggregateMaskingCallback();
        this.reader = LineReaderBuilder.builder().terminal(this.jlineTerminal).appName("karaf").variables(((CommandSessionImpl)this.session).getVariables()).highlighter((Highlighter)new org.apache.felix.gogo.jline.Highlighter(this.session)).parser((Parser)new KarafParser(this)).completer(completer).build();
        Path file = this.getHistoryFile();
        this.reader.setVariable("history-file", (Object)file);
        String maxSizeStr = System.getProperty(SHELL_HISTORY_MAXSIZE);
        if (maxSizeStr != null) {
            this.reader.setVariable("history-size", (Object)Integer.parseInt(maxSizeStr));
        }
        if ((maxFileSizeStr = System.getProperty(SHELL_HISTORY_FILE_MAXSIZE)) != null) {
            this.reader.setVariable("history-file-size", (Object)Integer.parseInt(maxFileSizeStr));
        }
        this.history = new HistoryWrapper(this.reader.getHistory());
        this.registry = new RegistryImpl(factory.getRegistry(), this);
        this.registry.register(factory);
        this.registry.register(this);
        this.registry.register(this.registry);
        this.registry.register(this.terminal);
        this.registry.register(this.history);
        this.registry.register(commandsCompleter);
        this.registry.register(new CommandNamesCompleter());
        this.registry.register(new FileCompleter());
        this.registry.register(new UriCompleter());
        this.registry.register(new FileOrUriCompleter());
        Properties sysProps = System.getProperties();
        for (Object key : sysProps.keySet()) {
            this.session.put(key.toString(), sysProps.get(key));
        }
        this.session.put(".session", this);
        this.session.put(".processor", processor);
        this.session.put(".commandSession", this.session);
        this.session.put(".jline.reader", this.reader);
        this.session.put(".jline.terminal", this.reader.getTerminal());
        this.session.put(".jline.history", this.reader.getHistory());
        this.session.put("SCOPE", "shell:bundle:*");
        this.session.put("SUBSHELL", "");
        this.session.put("karaf.completionMode", this.loadCompletionMode());
        this.session.put("USER", ShellUtil.getCurrentUserName());
        this.session.put("TERM", this.terminal.getType());
        this.session.put("APPLICATION", System.getProperty("karaf.name", "root"));
        this.session.put("#LINES", (session, arguments) -> Integer.toString(this.terminal.getHeight()));
        this.session.put("#COLUMNS", (session, arguments) -> Integer.toString(this.terminal.getWidth()));
        this.session.put("pid", this.getPid());
        this.session.put(".completions", new HashMap());
        this.session.put(".reader", this.reader);
        this.session.put(".terminal", this.reader.getTerminal());
        this.session.put("gogo.option.noglob", Boolean.TRUE);
        this.session.currentDir(Paths.get(System.getProperty("user.dir"), new String[0]).toAbsolutePath().normalize());
    }

    private void merge(List<Candidate> candidates) {
        HashMap<String, Candidate> map = new HashMap<String, Candidate>();
        for (Candidate c : candidates) {
            map.merge(c.value(), c, (c1, c2) -> c1.descr() != null ? c1 : c2);
        }
        candidates.clear();
        candidates.addAll(map.values());
    }

    private Completer createBuiltinCompleter() {
        Completers.CompletionEnvironment env = new Completers.CompletionEnvironment(){

            public Map<String, List<Completers.CompletionData>> getCompletions() {
                return Shell.getCompletions(ConsoleSessionImpl.this.session);
            }

            public Set<String> getCommands() {
                return ConsoleSessionImpl.this.factory.getRegistry().getCommands().stream().map(c -> c.getScope() + ":" + c.getName()).collect(Collectors.toSet());
            }

            public String resolveCommand(String command) {
                String resolved = command;
                if (command.indexOf(58) < 0) {
                    Set<String> commands = this.getCommands();
                    Object path = ConsoleSessionImpl.this.session.get("SCOPE");
                    String scopePath = null == path ? "*" : path.toString();
                    block0: for (String scope : scopePath.split(":")) {
                        for (String entry : commands) {
                            if ((!"*".equals(scope) || !entry.endsWith(":" + command)) && !entry.equals(scope + ":" + command)) continue;
                            resolved = entry;
                            continue block0;
                        }
                    }
                }
                return resolved;
            }

            public String commandName(String command) {
                int idx = command.indexOf(58);
                return idx >= 0 ? command.substring(idx + 1) : command;
            }

            public Object evaluate(LineReader reader, ParsedLine line, String func) throws Exception {
                ConsoleSessionImpl.this.session.put(".commandLine", line);
                return ConsoleSessionImpl.this.session.execute(func);
            }
        };
        return new Completers.Completer(env);
    }

    protected Path getHistoryFile() {
        String defaultHistoryPath = new File(System.getProperty("user.home"), ".karaf/karaf41.history").toString();
        return Paths.get(System.getProperty("karaf.history", defaultHistoryPath), new String[0]);
    }

    @Override
    public Terminal getTerminal() {
        return this.terminal;
    }

    @Override
    public History getHistory() {
        return this.history;
    }

    @Override
    public Registry getRegistry() {
        return this.registry;
    }

    @Override
    public SessionFactory getFactory() {
        return this.factory;
    }

    @Override
    public Path currentDir() {
        return this.session.currentDir();
    }

    @Override
    public void currentDir(Path path) {
        this.session.currentDir(path);
    }

    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            if (this.running) {
                try {
                    this.reader.getHistory().save();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            this.running = false;
            if (this.thread != Thread.currentThread() && this.thread != null) {
                this.thread.interrupt();
            }
            if (this.closeCallback != null) {
                this.closeCallback.run();
            }
            if (this.terminal instanceof AutoCloseable) {
                try {
                    ((AutoCloseable)((Object)this.terminal)).close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this.session != null) {
                this.session.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            CharSequence command;
            this.threadIO.setStreams(this.session.getKeyboard(), this.out, this.err);
            this.thread = Thread.currentThread();
            this.running = true;
            this.welcomeBanner();
            AtomicBoolean reading = new AtomicBoolean();
            this.session.setJobListener((job, previous, current) -> {
                if (previous == Job.Status.Background || current == Job.Status.Background || previous == Job.Status.Suspended || current == Job.Status.Suspended) {
                    int width = this.terminal.getWidth();
                    String status = current.name().toLowerCase();
                    this.jlineTerminal.writer().write(this.getStatusLine(job, width, status));
                    this.jlineTerminal.flush();
                    if (reading.get()) {
                        this.reader.callWidget("redraw-line");
                        this.reader.callWidget("redisplay");
                    }
                }
            });
            this.jlineTerminal.handle(Terminal.Signal.TSTP, s -> {
                Job current = this.session.foregroundJob();
                if (current != null) {
                    current.suspend();
                }
            });
            this.jlineTerminal.handle(Terminal.Signal.INT, s -> {
                Job current = this.session.foregroundJob();
                if (current != null) {
                    current.interrupt();
                }
            });
            String scriptFileName = System.getProperty(SHELL_INIT_SCRIPT);
            this.executeScript(scriptFileName);
            while (this.running && (command = this.readCommand(reading)) != null) {
                if (command.length() <= 0) continue;
                this.doExecute(command);
            }
            this.close();
        }
        finally {
            try {
                this.threadIO.close();
            }
            catch (Throwable throwable) {}
        }
    }

    private void welcomeBanner() {
        if (!this.isLocal() || System.getProperty(SUPPRESS_WELCOME) == null) {
            this.welcome(this.brandingProps);
            this.setSessionProperties(this.brandingProps);
            if (this.isLocal()) {
                System.setProperty(SUPPRESS_WELCOME, "true");
            }
        }
    }

    private boolean isLocal() {
        Boolean isLocal = (Boolean)this.session.get("karaf.shell.local");
        return isLocal != null && isLocal != false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CharSequence readCommand(AtomicBoolean reading) throws UserInterruptException {
        CharSequence command = null;
        reading.set(true);
        try {
            this.reader.readLine(this.getPrompt(), this.getRPrompt(), (MaskingCallback)this.maskingCallback, null);
            ParsedLine pl = this.reader.getParsedLine();
            command = pl instanceof ParsedLineImpl ? ((ParsedLineImpl)pl).program() : (pl != null ? pl.line() : this.reader.getBuffer().toString());
        }
        catch (EndOfFileException e) {
            command = null;
        }
        catch (UserInterruptException e) {
            command = "";
        }
        catch (Throwable t) {
            ShellUtil.logException(this, t);
        }
        finally {
            reading.set(false);
        }
        return command;
    }

    private void doExecute(CharSequence command) {
        try {
            Object result = this.session.execute(command);
            if (result != null) {
                this.session.getConsole().println(this.session.format(result, 0));
            }
        }
        catch (InterruptedException e) {
            LOGGER.debug("Console session is closed");
        }
        catch (Throwable t) {
            ShellUtil.logException(this, t);
        }
    }

    private String getStatusLine(Job job, int width, String status) {
        int i;
        StringBuilder sb = new StringBuilder();
        for (i = 0; i < width - 1; ++i) {
            sb.append(' ');
        }
        sb.append('\r');
        sb.append("[").append(job.id()).append("]  ");
        sb.append(status);
        for (i = status.length(); i < "background".length(); ++i) {
            sb.append(' ');
        }
        sb.append("  ").append(job.command()).append("\n");
        return sb.toString();
    }

    @Override
    public Object execute(CharSequence commandline) throws Exception {
        String command = CommandLineParser.parse(this, commandline.toString());
        return this.session.execute(command);
    }

    @Override
    public Object get(String name) {
        return this.session.get(name);
    }

    @Override
    public void put(String name, Object value) {
        this.session.put(name, value);
    }

    @Override
    public InputStream getKeyboard() {
        return this.session.getKeyboard();
    }

    @Override
    public PrintStream getConsole() {
        return this.session.getConsole();
    }

    @Override
    public String resolveCommand(String name) {
        if (!name.contains(":")) {
            String[] scopes = ((String)this.get("SCOPE")).split(":");
            List<Command> commands = this.registry.getCommands();
            for (String scope : scopes) {
                boolean globalScope = "*".equals(scope);
                for (Command command : commands) {
                    if (!globalScope && !command.getScope().equals(scope) || !command.getName().equals(name)) continue;
                    return command.getScope() + ":" + name;
                }
            }
        }
        return name;
    }

    @Override
    public String readLine(String prompt, Character mask) throws IOException {
        LineReader reader = LineReaderBuilder.builder().terminal(this.jlineTerminal).appName("karaf").parser((line, cursor, context) -> new SimpleParsedLine(line, cursor)).build();
        reader.setOpt(LineReader.Option.DISABLE_EVENT_EXPANSION);
        reader.setVariable("disable-history", (Object)Boolean.TRUE);
        reader.setVariable("disable-completion", (Object)Boolean.TRUE);
        return reader.readLine(prompt, mask);
    }

    private String loadCompletionMode() {
        String mode;
        try {
            File shellCfg = new File(System.getProperty("karaf.etc"), "/org.apache.karaf.shell.cfg");
            Properties properties = new Properties();
            properties.load(new FileInputStream(shellCfg));
            mode = (String)properties.get("completionMode");
            if (mode == null) {
                LOGGER.debug("completionMode property is not defined in etc/org.apache.karaf.shell.cfg file. Using default completion mode.");
                mode = "global";
            }
        }
        catch (Exception e) {
            LOGGER.warn("Can't read {}/org.apache.karaf.shell.cfg file. The completion is set to default.", (Object)System.getProperty("karaf.etc"));
            mode = "global";
        }
        return mode;
    }

    private void executeScript(String names) {
        FilesStream.stream(names).forEach(this::doExecuteScript);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doExecuteScript(Path scriptFileName) {
        Object oldScript = this.session.put("script", Paths.get(System.getProperty("karaf.home"), new String[0]).relativize(scriptFileName));
        try {
            String script = String.join((CharSequence)"\n", Files.readAllLines(scriptFileName));
            this.session.execute(script);
        }
        catch (Exception e) {
            LOGGER.debug("Error in initialization script {}", (Object)scriptFileName, (Object)e);
            System.err.println("Error in initialization script: " + scriptFileName + ": " + e.getMessage());
        }
        finally {
            this.session.put("script", oldScript);
        }
    }

    protected void welcome(Properties brandingProps) {
        String welcome = brandingProps.getProperty("welcome");
        if (welcome != null && welcome.length() > 0) {
            this.session.getConsole().println(welcome);
        }
    }

    protected void setSessionProperties(Properties brandingProps) {
        for (Map.Entry<Object, Object> entry : brandingProps.entrySet()) {
            String key = (String)entry.getKey();
            if (!key.startsWith("session.")) continue;
            this.session.put(key.substring("session.".length()), entry.getValue());
        }
    }

    protected String getPrompt() {
        return this.doGetPrompt(PROMPT, DEFAULT_PROMPT);
    }

    protected String getRPrompt() {
        return this.doGetPrompt(RPROMPT, DEFAULT_RPROMPT);
    }

    protected String doGetPrompt(String var, String def) {
        try {
            String prompt;
            try {
                Object p = this.session.get(var);
                if (p != null) {
                    prompt = p.toString();
                } else {
                    p = this.session.get(var = var.toLowerCase());
                    if (p != null) {
                        prompt = p.toString();
                    } else if (this.brandingProps.getProperty(var) != null) {
                        prompt = this.brandingProps.getProperty(var);
                        this.session.put(var, prompt);
                    } else {
                        prompt = def;
                    }
                }
            }
            catch (Throwable t) {
                prompt = def;
            }
            if (prompt != null) {
                Matcher matcher = Pattern.compile("\\$\\{([^}]+)\\}").matcher(prompt);
                while (matcher.find()) {
                    Object rep = this.session.get(matcher.group(1));
                    if (rep == null) continue;
                    prompt = prompt.replace(matcher.group(0), rep.toString());
                    matcher.reset(prompt);
                }
            }
            return prompt;
        }
        catch (Throwable t) {
            return "$ ";
        }
    }

    private String getPid() {
        String name = ManagementFactory.getRuntimeMXBean().getName();
        String[] parts = name.split("@");
        return parts[0];
    }

    private class AggregateMaskingCallback
    implements MaskingCallback {
        private final List<Command> commands = new ArrayList<Command>();
        private final Map<String, ActionMaskingCallback> regexs = new HashMap<String, ActionMaskingCallback>();

        private AggregateMaskingCallback() {
        }

        public String display(String line) {
            return this.compute(line);
        }

        public String history(String line) {
            return this.compute(line);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String compute(String line) {
            boolean update;
            List<Command> commands;
            AggregateMaskingCallback aggregateMaskingCallback = this;
            synchronized (aggregateMaskingCallback) {
                commands = ConsoleSessionImpl.this.factory.getRegistry().getCommands();
                update = !commands.equals(this.commands);
            }
            if (update) {
                HashMap<String, ActionMaskingCallback> regexs = new HashMap<String, ActionMaskingCallback>();
                for (Command cmd : commands) {
                    ActionMaskingCallback amc;
                    if (!(cmd instanceof ActionCommand) || (amc = ActionMaskingCallback.build((ActionCommand)cmd)) == null) continue;
                    regexs.put(cmd.getScope() + ":" + cmd.getName(), amc);
                }
                AggregateMaskingCallback aggregateMaskingCallback2 = this;
                synchronized (aggregateMaskingCallback2) {
                    this.commands.clear();
                    this.regexs.clear();
                    this.commands.addAll(commands);
                    this.regexs.putAll(regexs);
                }
            }
            try {
                ParsedLine pl = ConsoleSessionImpl.this.reader.getParser().parse(line, line.length());
                String cmd = ConsoleSessionImpl.this.resolveCommand((String)pl.words().get(0));
                ActionMaskingCallback repl = this.regexs.get(cmd);
                if (repl != null) {
                    line = repl.filter(line, pl);
                }
            }
            catch (SyntaxError pl) {
            }
            catch (Exception e) {
                LOGGER.debug("Exception caught while masking command line", (Throwable)e);
            }
            return line;
        }
    }

    private static class SimpleParsedLine
    implements ParsedLine {
        private final String line;
        private final int cursor;

        public SimpleParsedLine(String line, int cursor) {
            this.line = line;
            this.cursor = cursor;
        }

        public String word() {
            return this.line;
        }

        public int wordCursor() {
            return this.cursor;
        }

        public int wordIndex() {
            return 0;
        }

        public List<String> words() {
            return Collections.singletonList(this.line);
        }

        public String line() {
            return this.line;
        }

        public int cursor() {
            return this.cursor;
        }
    }
}

