/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client;

import org.eclipse.jetty.client.DuplexConnectionPool;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpDestination;
import org.eclipse.jetty.client.HttpExchange;
import org.eclipse.jetty.client.HttpRequest;
import org.eclipse.jetty.client.Origin;
import org.eclipse.jetty.client.SendFailure;
import org.eclipse.jetty.client.api.Connection;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.thread.Sweeper;

@ManagedObject
public abstract class PoolingHttpDestination<C extends Connection>
extends HttpDestination
implements Callback {
    private DuplexConnectionPool connectionPool;

    public PoolingHttpDestination(HttpClient client, Origin origin) {
        super(client, origin);
    }

    protected void doStart() throws Exception {
        HttpClient client = this.getHttpClient();
        this.connectionPool = this.newConnectionPool(client);
        this.addBean(this.connectionPool);
        super.doStart();
        Sweeper sweeper = (Sweeper)client.getBean(Sweeper.class);
        if (sweeper != null) {
            sweeper.offer((Sweeper.Sweepable)this.connectionPool);
        }
    }

    protected void doStop() throws Exception {
        HttpClient client = this.getHttpClient();
        Sweeper sweeper = (Sweeper)client.getBean(Sweeper.class);
        if (sweeper != null) {
            sweeper.remove((Sweeper.Sweepable)this.connectionPool);
        }
        super.doStop();
        this.removeBean(this.connectionPool);
    }

    protected DuplexConnectionPool newConnectionPool(HttpClient client) {
        return new DuplexConnectionPool(this, client.getMaxConnectionsPerDestination(), this);
    }

    @ManagedAttribute(value="The connection pool", readonly=true)
    public DuplexConnectionPool getConnectionPool() {
        return this.connectionPool;
    }

    public void succeeded() {
        this.send();
    }

    public void failed(Throwable x) {
        this.abort(x);
    }

    @Override
    public void send() {
        if (this.getHttpExchanges().isEmpty()) {
            return;
        }
        this.process();
    }

    public C acquire() {
        return (C)this.connectionPool.acquire();
    }

    private void process() {
        boolean proceed;
        C connection;
        while ((connection = this.acquire()) != null && (proceed = this.process(connection))) {
        }
    }

    public boolean process(C connection) {
        HttpClient client = this.getHttpClient();
        HttpExchange exchange = this.getHttpExchanges().poll();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Processing exchange {} on {} of {}", new Object[]{exchange, connection, this});
        }
        if (exchange == null) {
            if (!this.connectionPool.release((Connection)connection)) {
                connection.close();
            }
            if (!client.isRunning()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("{} is stopping", new Object[]{client});
                }
                connection.close();
            }
            return false;
        }
        HttpRequest request = exchange.getRequest();
        Throwable cause = request.getAbortCause();
        if (cause != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Aborted before processing {}: {}", new Object[]{exchange, cause});
            }
            if (!this.connectionPool.release((Connection)connection)) {
                connection.close();
            }
            exchange.abort(cause);
        } else {
            SendFailure result = this.send(connection, exchange);
            if (result != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Send failed {} for {}", new Object[]{result, exchange});
                }
                if (result.retry && this.enqueue(this.getHttpExchanges(), exchange)) {
                    return true;
                }
                request.abort(result.failure);
            }
        }
        return this.getHttpExchanges().peek() != null;
    }

    protected abstract SendFailure send(C var1, HttpExchange var2);

    @Override
    public void release(Connection c) {
        HttpClient client;
        Connection connection = c;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Released {}", new Object[]{connection});
        }
        if ((client = this.getHttpClient()).isRunning()) {
            if (this.connectionPool.isActive(connection)) {
                if (this.connectionPool.release(connection)) {
                    this.send();
                } else {
                    connection.close();
                }
            } else if (LOG.isDebugEnabled()) {
                LOG.debug("Released explicit {}", new Object[]{connection});
            }
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} is stopped", new Object[]{client});
            }
            connection.close();
        }
    }

    @Override
    public void close(Connection connection) {
        super.close(connection);
        boolean removed = this.connectionPool.remove(connection);
        if (this.getHttpExchanges().isEmpty()) {
            if (this.getHttpClient().isRemoveIdleDestinations() && this.connectionPool.isEmpty()) {
                this.getHttpClient().removeDestination(this);
            }
        } else if (removed) {
            this.process();
        }
    }

    @Override
    public void close() {
        super.close();
        this.connectionPool.close();
    }

    @Override
    public String toString() {
        return String.format("%s,pool=%s", super.toString(), this.connectionPool);
    }
}

