/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.expression.spel.ast;

import org.springframework.core.convert.TypeDescriptor;
import org.springframework.expression.EvaluationException;
import org.springframework.expression.Operation;
import org.springframework.expression.TypeConverter;
import org.springframework.expression.TypedValue;
import org.springframework.expression.spel.ExpressionState;
import org.springframework.expression.spel.ast.Operator;
import org.springframework.expression.spel.ast.SpelNodeImpl;
import org.springframework.util.Assert;

public class OpPlus
extends Operator {
    public OpPlus(int pos, SpelNodeImpl ... operands) {
        super("+", pos, operands);
        Assert.notEmpty((Object[])operands);
    }

    public TypedValue getValueInternal(ExpressionState state) throws EvaluationException {
        SpelNodeImpl leftOp = this.getLeftOperand();
        SpelNodeImpl rightOp = this.getRightOperand();
        if (rightOp == null) {
            Object operandOne = leftOp.getValueInternal(state).getValue();
            if (operandOne instanceof Number) {
                if (operandOne instanceof Double || operandOne instanceof Long) {
                    return new TypedValue(operandOne);
                }
                if (operandOne instanceof Float) {
                    return new TypedValue(Float.valueOf(((Number)operandOne).floatValue()));
                }
                return new TypedValue(((Number)operandOne).intValue());
            }
            return state.operate(Operation.ADD, operandOne, null);
        }
        TypedValue operandOneValue = leftOp.getValueInternal(state);
        Object operandOne = operandOneValue.getValue();
        TypedValue operandTwoValue = rightOp.getValueInternal(state);
        Object operandTwo = operandTwoValue.getValue();
        if (operandOne instanceof Number && operandTwo instanceof Number) {
            Number op1 = (Number)operandOne;
            Number op2 = (Number)operandTwo;
            if (op1 instanceof Double || op2 instanceof Double) {
                return new TypedValue(op1.doubleValue() + op2.doubleValue());
            }
            if (op1 instanceof Float || op2 instanceof Float) {
                return new TypedValue(Float.valueOf(op1.floatValue() + op2.floatValue()));
            }
            if (op1 instanceof Long || op2 instanceof Long) {
                return new TypedValue(op1.longValue() + op2.longValue());
            }
            return new TypedValue(op1.intValue() + op2.intValue());
        }
        if (operandOne instanceof String && operandTwo instanceof String) {
            return new TypedValue((String)operandOne + (String)operandTwo);
        }
        if (operandOne instanceof String) {
            StringBuilder result = new StringBuilder((String)operandOne);
            result.append(operandTwo == null ? "null" : OpPlus.convertTypedValueToString(operandTwoValue, state));
            return new TypedValue(result.toString());
        }
        if (operandTwo instanceof String) {
            StringBuilder result = new StringBuilder(operandOne == null ? "null" : OpPlus.convertTypedValueToString(operandOneValue, state));
            result.append((String)operandTwo);
            return new TypedValue(result.toString());
        }
        return state.operate(Operation.ADD, operandOne, operandTwo);
    }

    public String toStringAST() {
        if (this.children.length < 2) {
            return "+" + this.getLeftOperand().toStringAST();
        }
        return super.toStringAST();
    }

    public SpelNodeImpl getRightOperand() {
        if (this.children.length < 2) {
            return null;
        }
        return this.children[1];
    }

    private static String convertTypedValueToString(TypedValue value, ExpressionState state) {
        TypeConverter typeConverter = state.getEvaluationContext().getTypeConverter();
        TypeDescriptor typeDescriptor = TypeDescriptor.valueOf(String.class);
        if (typeConverter.canConvert(value.getTypeDescriptor(), typeDescriptor)) {
            Object obj = typeConverter.convertValue(value.getValue(), value.getTypeDescriptor(), typeDescriptor);
            return String.valueOf(obj);
        }
        return String.valueOf(value.getValue());
    }
}

