/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.gogo.jline;

import java.util.ArrayList;
import java.util.List;
import org.apache.felix.gogo.runtime.Parser;
import org.apache.felix.gogo.runtime.Token;
import org.jline.reader.ParsedLine;

public class ParsedLineImpl
implements ParsedLine {
    private final Parser.Program program;
    private final String source;
    private final int cursor;
    private final List<String> tokens;
    private final int wordIndex;
    private final int wordCursor;

    public ParsedLineImpl(Parser.Program program, Token line, int cursor, List<Token> tokens) {
        this.program = program;
        this.source = line.toString();
        this.cursor = cursor - line.start();
        this.tokens = new ArrayList<String>();
        for (Token token : tokens) {
            this.tokens.add(token.toString());
        }
        int wi = tokens.size();
        int wc = 0;
        if (cursor >= 0) {
            for (int i = 0; i < tokens.size(); ++i) {
                Token t = tokens.get(i);
                if (t.start() > cursor) {
                    wi = i;
                    wc = 0;
                    this.tokens.add(i, "");
                    break;
                }
                if (t.start() + t.length() < cursor) continue;
                wi = i;
                wc = cursor - t.start();
                break;
            }
        }
        if (wi == tokens.size()) {
            this.tokens.add("");
        }
        this.wordIndex = wi;
        this.wordCursor = wc;
    }

    public String word() {
        return this.tokens.get(this.wordIndex());
    }

    public int wordCursor() {
        return this.wordCursor;
    }

    public int wordIndex() {
        return this.wordIndex;
    }

    public List<String> words() {
        return this.tokens;
    }

    public String line() {
        return this.source;
    }

    public int cursor() {
        return this.cursor;
    }

    public Parser.Program program() {
        return this.program;
    }
}

