/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.kex;

import java.math.BigInteger;
import org.apache.sshd.common.digest.Digest;
import org.apache.sshd.common.util.NumberUtils;

public abstract class AbstractDH {
    protected BigInteger k;
    private byte[] k_array;

    protected AbstractDH() {
    }

    public abstract void setF(byte[] var1);

    public abstract byte[] getE() throws Exception;

    protected abstract byte[] calculateK() throws Exception;

    public byte[] getK() throws Exception {
        if (this.k == null) {
            this.k_array = this.calculateK();
            this.k = new BigInteger(this.k_array);
        }
        return this.k_array;
    }

    public abstract Digest getHash() throws Exception;

    public static byte[] stripLeadingZeroes(byte[] x) {
        int length = NumberUtils.length(x);
        for (int i = 0; i < x.length; ++i) {
            if (x[i] == 0) continue;
            if (i == 0) {
                return x;
            }
            byte[] ret = new byte[length - i];
            System.arraycopy(x, i, ret, 0, ret.length);
            return ret;
        }
        throw new IllegalArgumentException("No non-zero values in generated secret");
    }
}

