/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.log.command;

import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Command(scope="log", name="load-test", description="Load test log.")
@Service
public class LoadTest
implements Action {
    private static final Logger LOGGER = LoggerFactory.getLogger(LoadTest.class);
    @Option(name="--threads")
    private int threads = 1;
    @Option(name="--messaged")
    private int messages = 1000;

    public Object execute() throws Exception {
        Thread[] th = new Thread[this.threads];
        for (int i = 0; i < this.threads; ++i) {
            final int idxThread = i;
            th[i] = new Thread(new Runnable(){

                @Override
                public void run() {
                    for (int i = 0; i < LoadTest.this.messages; ++i) {
                        LOGGER.info("Message {} / {}", (Object)idxThread, (Object)i);
                    }
                }
            });
        }
        long t0 = System.currentTimeMillis();
        for (Thread thread : th) {
            thread.start();
        }
        for (Thread thread : th) {
            thread.join();
        }
        long t1 = System.currentTimeMillis();
        System.out.println("Time: " + (t1 - t0) + " ms");
        System.out.println("Throughput: " + (double)(this.messages * this.threads) / ((double)(t1 - t0) + 0.0) + " msg/ms");
        return null;
    }
}

