/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.framework;

import java.io.File;
import java.io.IOException;
import java.util.StringTokenizer;
import org.apache.felix.framework.Felix;
import org.apache.felix.framework.SecurityProviderImpl;
import org.apache.felix.framework.ext.SecurityProvider;
import org.apache.felix.framework.security.condpermadmin.ConditionalPermissionAdminImpl;
import org.apache.felix.framework.security.permissionadmin.PermissionAdminImpl;
import org.apache.felix.framework.security.util.Conditions;
import org.apache.felix.framework.security.util.LocalPermissions;
import org.apache.felix.framework.security.util.Permissions;
import org.apache.felix.framework.security.util.PropertiesCache;
import org.apache.felix.framework.util.SecureAction;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;

public final class SecurityActivator
implements BundleActivator {
    static /* synthetic */ Class class$org$osgi$service$permissionadmin$PermissionAdmin;
    static /* synthetic */ Class class$org$osgi$service$condpermadmin$ConditionalPermissionAdmin;

    public synchronized void start(BundleContext context) throws Exception {
        PermissionAdminImpl pai = null;
        SecureAction action = new SecureAction();
        Permissions permissions = new Permissions(context, action);
        File tmp = context.getDataFile("security" + File.separator + "tmp");
        if (tmp == null || !tmp.isDirectory() && !tmp.mkdirs()) {
            throw new IOException("Can't create tmp dir.");
        }
        File[] old = tmp.listFiles();
        if (old != null) {
            for (int i = 0; i < old.length; ++i) {
                old[i].delete();
            }
        }
        if ("TRUE".equalsIgnoreCase(this.getProperty(context, "felix.security.permissionadmin", "true"))) {
            File cache = context.getDataFile("security" + File.separator + "pa.txt");
            if (cache == null || !cache.isFile() && !cache.createNewFile()) {
                throw new IOException("Can't create cache file");
            }
            pai = new PermissionAdminImpl(permissions, new PropertiesCache(cache, tmp, action));
        }
        ConditionalPermissionAdminImpl cpai = null;
        if ("TRUE".equalsIgnoreCase(this.getProperty(context, "felix.security.conpermadmin", "true"))) {
            File cpaCache = context.getDataFile("security" + File.separator + "cpa.txt");
            if (cpaCache == null || !cpaCache.isFile() && !cpaCache.createNewFile()) {
                throw new IOException("Can't create cache file");
            }
            LocalPermissions localPermissions = new LocalPermissions(permissions);
            cpai = new ConditionalPermissionAdminImpl(permissions, new Conditions(action), localPermissions, new PropertiesCache(cpaCache, tmp, action), pai);
        }
        if (pai != null || cpai != null) {
            String crlList = this.getProperty(context, "felix.crl", "");
            String storeList = this.getProperty(context, "felix.keystore", "");
            String passwdList = this.getProperty(context, "felix.keystore.pass", "");
            String typeList = this.getProperty(context, "felix.keystore.type", "");
            String osgi_keystores = this.getProperty(context, "org.osgi.framework.trust.repositories", null);
            if (osgi_keystores != null) {
                StringTokenizer tok = new StringTokenizer(osgi_keystores, File.pathSeparator);
                if (storeList.length() == 0) {
                    storeList = storeList + "file:" + tok.nextToken();
                    passwdList = passwdList + " ";
                    typeList = typeList + "JKS";
                }
                while (tok.hasMoreTokens()) {
                    storeList = storeList + "|file:" + tok.nextToken();
                    passwdList = passwdList + "| ";
                    typeList = typeList + "|JKS";
                }
            }
            StringTokenizer storeTok = new StringTokenizer(storeList, "|");
            StringTokenizer passwdTok = new StringTokenizer(passwdList, "|");
            StringTokenizer typeTok = new StringTokenizer(typeList, "|");
            if (storeTok.countTokens() != typeTok.countTokens() || passwdTok.countTokens() != storeTok.countTokens()) {
                throw new BundleException("Each CACerts keystore must have one type and one passwd entry and vice versa.");
            }
            SecurityProviderImpl provider = new SecurityProviderImpl(crlList, typeList, passwdList, storeList, pai, cpai, action, ((Felix)context.getBundle(0L)).getLogger());
            ((Felix)context.getBundle(0L)).setSecurityProvider((SecurityProvider)provider);
        }
        if (pai != null) {
            context.registerService((class$org$osgi$service$permissionadmin$PermissionAdmin == null ? (class$org$osgi$service$permissionadmin$PermissionAdmin = SecurityActivator.class$("org.osgi.service.permissionadmin.PermissionAdmin")) : class$org$osgi$service$permissionadmin$PermissionAdmin).getName(), pai, null);
        }
        if (cpai != null) {
            context.registerService((class$org$osgi$service$condpermadmin$ConditionalPermissionAdmin == null ? (class$org$osgi$service$condpermadmin$ConditionalPermissionAdmin = SecurityActivator.class$("org.osgi.service.condpermadmin.ConditionalPermissionAdmin")) : class$org$osgi$service$condpermadmin$ConditionalPermissionAdmin).getName(), cpai, null);
        }
    }

    public synchronized void stop(BundleContext context) throws Exception {
        ((Felix)context.getBundle(0L)).setSecurityProvider(null);
    }

    private String getProperty(BundleContext context, String key, String defaultValue) {
        String result = context.getProperty(key);
        return result != null ? result : defaultValue;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

