/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.proxy.impl.gen;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import org.apache.aries.proxy.impl.ProxyUtils;
import org.apache.aries.proxy.impl.gen.ProxySubclassHierarchyAdapter;
import org.apache.aries.proxy.impl.gen.ProxySubclassMethodHashSet;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.GeneratorAdapter;
import org.objectweb.asm.commons.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxySubclassAdapter
extends ClassVisitor
implements Opcodes {
    private static final Type STRING_TYPE = Type.getType(String.class);
    private static final Type CLASS_TYPE = Type.getType(Class.class);
    private static final Type CLASSLOADER_TYPE = Type.getType(ClassLoader.class);
    private static final Type OBJECT_TYPE = Type.getType(Object.class);
    private static final Type METHOD_TYPE = Type.getType(java.lang.reflect.Method.class);
    private static final Type IH_TYPE = Type.getType(InvocationHandler.class);
    private static final Type[] NO_ARGS = new Type[0];
    private static final String IH_FIELD = "ih";
    private static Logger LOGGER = LoggerFactory.getLogger(ProxySubclassAdapter.class);
    private String newClassName = null;
    private String superclassBinaryName = null;
    private Class<?> superclassClass = null;
    private ClassLoader loader = null;
    private Type newClassType = null;
    private GeneratorAdapter staticAdapter = null;
    private String currentlyAnalysedClassName = null;
    private Class<?> currentlyAnalysedClass = null;
    private String currentClassFieldName = null;

    public ProxySubclassAdapter(ClassVisitor writer, String newClassName, ClassLoader loader) {
        super(262144, writer);
        LOGGER.debug("Method entry: {}, args {}", (Object)"ProxySubclassAdapter", (Object)new Object[]{this, writer, newClassName});
        this.newClassName = newClassName;
        this.newClassType = Type.getType((String)("L" + newClassName + ";"));
        this.loader = loader;
        LOGGER.debug("Method exit: {}, returning {}", (Object)"ProxySubclassAdapter", (Object)this);
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        LOGGER.debug("Method entry: {}, args {}", (Object)"visit", (Object)new Object[]{version, access, name, signature, superName, interfaces});
        this.superclassBinaryName = name.replaceAll("/", "\\.");
        try {
            this.superclassClass = Class.forName(this.superclassBinaryName, false, this.loader);
        }
        catch (ClassNotFoundException cnfe) {
            throw new TypeNotPresentException(this.superclassBinaryName, cnfe);
        }
        if ((access & 0x400) != 0) {
            access &= 0xFFFFFBFF;
        }
        this.cv.visit(ProxyUtils.getWeavingJavaVersion(), access, this.newClassName, signature, name, null);
        this.cv.visitField(2, IH_FIELD, Type.getDescriptor(InvocationHandler.class), null, null);
        this.staticAdapter = new GeneratorAdapter(8, new Method("<clinit>", Type.VOID_TYPE, NO_ARGS), null, null, this.cv);
        Method m = new Method("<init>", Type.VOID_TYPE, NO_ARGS);
        GeneratorAdapter methodAdapter = new GeneratorAdapter(1, m, null, null, this.cv);
        methodAdapter.loadThis();
        Constructor<?>[] constructors = this.superclassClass.getDeclaredConstructors();
        if (constructors.length > 0) {
            Method constructor = Method.getMethod((String)constructors[0].toGenericString());
            Type[] argTypes = constructor.getArgumentTypes();
            if (argTypes.length == 0) {
                methodAdapter.invokeConstructor(Type.getType(this.superclassClass), new Method("<init>", Type.VOID_TYPE, NO_ARGS));
            } else {
                block15: for (Type type : argTypes) {
                    switch (type.getSort()) {
                        case 9: {
                            String elementDesc = type.getElementType().getDescriptor();
                            String typeDesc = type.getDescriptor();
                            int index = 0;
                            while (!elementDesc.equals(typeDesc)) {
                                typeDesc = typeDesc.substring(1);
                                methodAdapter.visitInsn(3);
                                ++index;
                            }
                            if (index == 1) {
                                methodAdapter.newArray(type.getElementType());
                                continue block15;
                            }
                            methodAdapter.visitMultiANewArrayInsn(type.getDescriptor(), index);
                            continue block15;
                        }
                        case 1: {
                            methodAdapter.push(true);
                            continue block15;
                        }
                        case 3: {
                            methodAdapter.push(Type.VOID_TYPE);
                            continue block15;
                        }
                        case 2: {
                            methodAdapter.push(Type.VOID_TYPE);
                            continue block15;
                        }
                        case 8: {
                            methodAdapter.push(0.0);
                            continue block15;
                        }
                        case 6: {
                            methodAdapter.push(0.0f);
                            continue block15;
                        }
                        case 5: {
                            methodAdapter.push(0);
                            continue block15;
                        }
                        case 7: {
                            methodAdapter.push(0L);
                            continue block15;
                        }
                        case 4: {
                            methodAdapter.push(0);
                            continue block15;
                        }
                        default: {
                            methodAdapter.visitInsn(1);
                        }
                    }
                }
                methodAdapter.invokeConstructor(Type.getType(this.superclassClass), new Method("<init>", Type.VOID_TYPE, argTypes));
            }
        }
        methodAdapter.returnValue();
        methodAdapter.endMethod();
        Method setter = new Method("setInvocationHandler", Type.VOID_TYPE, new Type[]{IH_TYPE});
        m = new Method("getInvocationHandler", IH_TYPE, NO_ARGS);
        methodAdapter = new GeneratorAdapter(17, m, null, null, this.cv);
        methodAdapter.loadThis();
        methodAdapter.getField(this.newClassType, IH_FIELD, IH_TYPE);
        methodAdapter.returnValue();
        methodAdapter.endMethod();
        methodAdapter = new GeneratorAdapter(17, setter, null, null, this.cv);
        methodAdapter.loadThis();
        methodAdapter.loadArgs();
        methodAdapter.putField(this.newClassType, IH_FIELD, IH_TYPE);
        methodAdapter.returnValue();
        methodAdapter.endMethod();
        java.lang.reflect.Method[] observedMethods = this.superclassClass.getDeclaredMethods();
        ProxySubclassMethodHashSet<String> setOfObservedMethods = new ProxySubclassMethodHashSet<String>(observedMethods.length);
        setOfObservedMethods.addMethodArray(observedMethods);
        Class<?> nextSuperClass = this.superclassClass.getSuperclass();
        while (nextSuperClass != null) {
            this.setCurrentAnalysisClassFields(nextSuperClass);
            this.addClassStaticField(this.currentlyAnalysedClassName);
            LOGGER.debug("Class currently being analysed: {} {}", (Object)this.currentlyAnalysedClassName, this.currentlyAnalysedClass);
            java.lang.reflect.Method[] foundMethods = this.currentlyAnalysedClass.getDeclaredMethods();
            ProxySubclassMethodHashSet setOfFoundMethods = new ProxySubclassMethodHashSet(foundMethods.length);
            setOfFoundMethods.addMethodArray(foundMethods);
            setOfFoundMethods.removeAll(setOfObservedMethods);
            try {
                ClassLoader loader = this.currentlyAnalysedClass.getClassLoader();
                if (loader == null) {
                    loader = this.loader;
                }
                ClassReader cr = new ClassReader(loader.getResourceAsStream(this.currentlyAnalysedClass.getName().replaceAll("\\.", "/") + ".class"));
                ProxySubclassHierarchyAdapter hierarchyAdapter = new ProxySubclassHierarchyAdapter(this, setOfFoundMethods);
                cr.accept((ClassVisitor)hierarchyAdapter, 2);
            }
            catch (IOException e) {
                throw new TypeNotPresentException(this.currentlyAnalysedClassName, e);
            }
            setOfObservedMethods.addAll(setOfFoundMethods);
            nextSuperClass = this.currentlyAnalysedClass.getSuperclass();
        }
        this.setCurrentAnalysisClassFields(this.superclassClass);
        this.addClassStaticField(this.currentlyAnalysedClassName);
        LOGGER.debug("Method exit: {}, returning {}", (Object)"visit");
    }

    public void visitSource(String source, String debug) {
        LOGGER.debug("Method entry: {}, args {}", (Object)"visitSource", (Object)new Object[]{source, debug});
        this.cv.visitSource(null, null);
        LOGGER.debug("Method exit: {}, returning {}", (Object)"visitSource");
    }

    public void visitEnd() {
        LOGGER.debug("Method entry: {}, args {}", (Object)"visitEnd");
        this.staticAdapter.returnValue();
        this.staticAdapter.endMethod();
        this.cv.visitEnd();
        LOGGER.debug("Method exit: {}, returning {}", (Object)"visitEnd");
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        LOGGER.debug("Method entry: {}, args {}", (Object)"visitMethod", (Object)new Object[]{access, name, desc, signature, exceptions});
        if ((access & 0x400) != 0) {
            access &= 0xFFFFFBFF;
        }
        LOGGER.debug("Method name: {} with descriptor: {}", (Object)name, (Object)desc);
        Object methodVisitorToReturn = null;
        if (name.equals("<init>")) {
            methodVisitorToReturn = null;
        } else if (name.equals("<clinit>")) {
            methodVisitorToReturn = null;
        } else if ((access & 0x10) != 0) {
            methodVisitorToReturn = null;
        } else if ((access & 0x1000) != 0) {
            methodVisitorToReturn = null;
        } else if ((access & 2) != 0) {
            methodVisitorToReturn = null;
        } else if ((access & 8) != 0) {
            methodVisitorToReturn = null;
        } else if ((access & 1) == 0 && (access & 4) == 0 && (access & 2) == 0) {
            if (this.currentlyAnalysedClass.getPackage().equals(this.superclassClass.getPackage())) {
                this.processMethod(access, name, desc, signature, exceptions);
                methodVisitorToReturn = null;
            } else {
                methodVisitorToReturn = null;
            }
        } else {
            this.processMethod(access, name, desc, signature, exceptions);
            methodVisitorToReturn = null;
        }
        LOGGER.debug("Method exit: {}, returning {}", (Object)"visitMethod", methodVisitorToReturn);
        return methodVisitorToReturn;
    }

    private void processMethod(int access, String name, String desc, String signature, String[] exceptions) {
        LOGGER.debug("Method entry: {}, args {}", (Object)"processMethod", (Object)new Object[]{access, name, desc, signature, exceptions});
        LOGGER.debug("Processing method: {} with descriptor {}", (Object)name, (Object)desc);
        Method currentTransformMethod = new Method(name, desc);
        Type[] targetMethodParameters = currentTransformMethod.getArgumentTypes();
        Type returnType = currentTransformMethod.getReturnType();
        StringBuilder methodStaticFieldNameBuilder = new StringBuilder(name);
        for (Type t : targetMethodParameters) {
            methodStaticFieldNameBuilder.append("_");
            methodStaticFieldNameBuilder.append(t.getClassName().replaceAll("\\[\\]", "Array").replaceAll("\\.", ""));
        }
        String methodStaticFieldName = methodStaticFieldNameBuilder.toString();
        this.cv.visitField(10, methodStaticFieldName, METHOD_TYPE.getDescriptor(), null, null);
        int newAccess = access & 0xFFFFFEFF & 0xFFFFFFDF;
        MethodVisitor mv = this.cv.visitMethod(newAccess, name, desc, signature, exceptions);
        GeneratorAdapter methodAdapter = new GeneratorAdapter(mv, newAccess, name, desc);
        this.staticAdapter.getStatic(this.newClassType, this.currentClassFieldName, CLASS_TYPE);
        this.staticAdapter.push(name);
        this.staticAdapter.push(targetMethodParameters.length);
        this.staticAdapter.newArray(CLASS_TYPE);
        int index = 0;
        for (Type t : targetMethodParameters) {
            this.staticAdapter.dup();
            this.staticAdapter.push(index);
            switch (t.getSort()) {
                case 1: {
                    this.staticAdapter.getStatic(Type.getType(Boolean.class), "TYPE", CLASS_TYPE);
                    break;
                }
                case 3: {
                    this.staticAdapter.getStatic(Type.getType(Byte.class), "TYPE", CLASS_TYPE);
                    break;
                }
                case 2: {
                    this.staticAdapter.getStatic(Type.getType(Character.class), "TYPE", CLASS_TYPE);
                    break;
                }
                case 8: {
                    this.staticAdapter.getStatic(Type.getType(Double.class), "TYPE", CLASS_TYPE);
                    break;
                }
                case 6: {
                    this.staticAdapter.getStatic(Type.getType(Float.class), "TYPE", CLASS_TYPE);
                    break;
                }
                case 5: {
                    this.staticAdapter.getStatic(Type.getType(Integer.class), "TYPE", CLASS_TYPE);
                    break;
                }
                case 7: {
                    this.staticAdapter.getStatic(Type.getType(Long.class), "TYPE", CLASS_TYPE);
                    break;
                }
                case 4: {
                    this.staticAdapter.getStatic(Type.getType(Short.class), "TYPE", CLASS_TYPE);
                    break;
                }
                default: {
                    this.staticAdapter.push(t);
                }
            }
            this.staticAdapter.arrayStore(CLASS_TYPE);
            ++index;
        }
        this.staticAdapter.invokeVirtual(CLASS_TYPE, new Method("getDeclaredMethod", METHOD_TYPE, new Type[]{STRING_TYPE, Type.getType(Class[].class)}));
        this.staticAdapter.putStatic(this.newClassType, methodStaticFieldName, METHOD_TYPE);
        methodAdapter.loadThis();
        methodAdapter.getField(this.newClassType, IH_FIELD, IH_TYPE);
        methodAdapter.loadThis();
        methodAdapter.getStatic(this.newClassType, methodStaticFieldName, METHOD_TYPE);
        methodAdapter.loadArgArray();
        Method invocationHandlerInvokeMethod = new Method("invoke", OBJECT_TYPE, new Type[]{OBJECT_TYPE, METHOD_TYPE, Type.getType(Object[].class)});
        methodAdapter.invokeInterface(IH_TYPE, invocationHandlerInvokeMethod);
        switch (returnType.getSort()) {
            case 1: {
                methodAdapter.cast(OBJECT_TYPE, Type.getType(Boolean.class));
                methodAdapter.unbox(Type.BOOLEAN_TYPE);
                break;
            }
            case 3: {
                methodAdapter.cast(OBJECT_TYPE, Type.getType(Byte.class));
                methodAdapter.unbox(Type.BYTE_TYPE);
                break;
            }
            case 2: {
                methodAdapter.cast(OBJECT_TYPE, Type.getType(Character.class));
                methodAdapter.unbox(Type.CHAR_TYPE);
                break;
            }
            case 8: {
                methodAdapter.cast(OBJECT_TYPE, Type.getType(Double.class));
                methodAdapter.unbox(Type.DOUBLE_TYPE);
                break;
            }
            case 6: {
                methodAdapter.cast(OBJECT_TYPE, Type.getType(Float.class));
                methodAdapter.unbox(Type.FLOAT_TYPE);
                break;
            }
            case 5: {
                methodAdapter.cast(OBJECT_TYPE, Type.getType(Integer.class));
                methodAdapter.unbox(Type.INT_TYPE);
                break;
            }
            case 7: {
                methodAdapter.cast(OBJECT_TYPE, Type.getType(Long.class));
                methodAdapter.unbox(Type.LONG_TYPE);
                break;
            }
            case 4: {
                methodAdapter.cast(OBJECT_TYPE, Type.getType(Short.class));
                methodAdapter.unbox(Type.SHORT_TYPE);
                break;
            }
            case 0: {
                methodAdapter.cast(OBJECT_TYPE, Type.getType(Void.class));
                methodAdapter.unbox(Type.VOID_TYPE);
                break;
            }
            default: {
                methodAdapter.checkCast(returnType);
                methodAdapter.cast(OBJECT_TYPE, returnType);
            }
        }
        methodAdapter.returnValue();
        methodAdapter.endMethod();
        LOGGER.debug("Method exit: {}, returning {}", (Object)"processMethod");
    }

    private void addClassStaticField(String classBinaryName) {
        LOGGER.debug("Method entry: {}, args {}", (Object)"addClassStaticField", (Object)new Object[]{classBinaryName});
        this.currentClassFieldName = classBinaryName.replaceAll("\\.", "_");
        this.cv.visitField(10, this.currentClassFieldName, CLASS_TYPE.getDescriptor(), null, null);
        this.staticAdapter.push(classBinaryName);
        this.staticAdapter.push(true);
        this.staticAdapter.push(this.newClassType);
        this.staticAdapter.invokeVirtual(CLASS_TYPE, new Method("getClassLoader", CLASSLOADER_TYPE, NO_ARGS));
        this.staticAdapter.invokeStatic(CLASS_TYPE, new Method("forName", CLASS_TYPE, new Type[]{STRING_TYPE, Type.BOOLEAN_TYPE, CLASSLOADER_TYPE}));
        this.staticAdapter.putStatic(this.newClassType, this.currentClassFieldName, CLASS_TYPE);
        LOGGER.debug("Method entry: {}, args {}", (Object)"addClassStaticField");
    }

    private void setCurrentAnalysisClassFields(Class<?> aClass) {
        LOGGER.debug("Method entry: {}, args {}", (Object)"setCurrentAnalysisClassFields", (Object)new Object[]{aClass});
        this.currentlyAnalysedClassName = aClass.getName();
        this.currentlyAnalysedClass = aClass;
        LOGGER.debug("Method exit: {}, returning {}", (Object)"setCurrentAnalysisClassFields");
    }

    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        return null;
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        return null;
    }

    public void visitAttribute(Attribute attr) {
    }

    public void visitInnerClass(String name, String outerName, String innerName, int access) {
    }

    public void visitOuterClass(String owner, String name, String desc) {
    }
}

