/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.differ;

import aQute.bnd.annotation.ConsumerType;
import aQute.bnd.annotation.ProviderType;
import aQute.bnd.differ.Element;
import aQute.bnd.header.Attrs;
import aQute.bnd.header.OSGiHeader;
import aQute.bnd.osgi.Analyzer;
import aQute.bnd.osgi.Annotation;
import aQute.bnd.osgi.ClassDataCollector;
import aQute.bnd.osgi.Clazz;
import aQute.bnd.osgi.Descriptors;
import aQute.bnd.osgi.Instructions;
import aQute.bnd.osgi.Packages;
import aQute.bnd.service.diff.Delta;
import aQute.bnd.service.diff.Type;
import aQute.bnd.version.Version;
import aQute.lib.collections.MultiMap;
import aQute.libg.generics.Create;
import java.lang.reflect.Array;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.jar.Manifest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class JavaElement {
    static final EnumSet<Type> INHERITED = EnumSet.of(Type.FIELD, Type.METHOD, Type.EXTENDS, Type.IMPLEMENTS);
    private static final Element PROTECTED = new Element(Type.ACCESS, "protected", null, Delta.MAJOR, Delta.MINOR, null);
    private static final Element STATIC = new Element(Type.ACCESS, "static", null, Delta.MAJOR, Delta.MAJOR, null);
    private static final Element ABSTRACT = new Element(Type.ACCESS, "abstract", null, Delta.MAJOR, Delta.MINOR, null);
    private static final Element FINAL = new Element(Type.ACCESS, "final", null, Delta.MAJOR, Delta.MINOR, null);
    final Analyzer analyzer;
    final Map<Descriptors.PackageRef, Instructions> providerMatcher = Create.map();
    final Set<Descriptors.TypeRef> notAccessible = Create.set();
    final Map<Object, Element> cache = Create.map();
    MultiMap<Descriptors.PackageRef, Element> packages;
    final MultiMap<Descriptors.TypeRef, Element> covariant = new MultiMap();
    final Set<Clazz.JAVA> javas = Create.set();
    final Packages exports;
    static Element BOOLEAN_R = new Element(Type.RETURN, "boolean");
    static Element BYTE_R = new Element(Type.RETURN, "byte");
    static Element SHORT_R = new Element(Type.RETURN, "short");
    static Element CHAR_R = new Element(Type.RETURN, "char");
    static Element INT_R = new Element(Type.RETURN, "int");
    static Element LONG_R = new Element(Type.RETURN, "long");
    static Element FLOAT_R = new Element(Type.RETURN, "float");
    static Element DOUBLE_R = new Element(Type.RETURN, "double");

    JavaElement(Analyzer analyzer) throws Exception {
        this.analyzer = analyzer;
        Manifest manifest = analyzer.getJar().getManifest();
        if (manifest != null && manifest.getMainAttributes().getValue("Bundle-ManifestVersion") != null) {
            this.exports = new Packages();
            for (Map.Entry<Object, Attrs> entry : OSGiHeader.parseHeader(manifest.getMainAttributes().getValue("Export-Package")).entrySet()) {
                this.exports.put(analyzer.getPackageRef((String)entry.getKey()), entry.getValue());
            }
        } else {
            this.exports = analyzer.getContained();
        }
        for (Map.Entry<Descriptors.PackageRef, Attrs> entry : this.exports.entrySet()) {
            String value = entry.getValue().get("x-provider-type:");
            if (value == null) continue;
            this.providerMatcher.put(entry.getKey(), new Instructions(value));
        }
        this.packages = new MultiMap();
        for (Clazz clazz : analyzer.getClassspace().values()) {
            Descriptors.PackageRef packageName;
            if (!clazz.isPublic() && !clazz.isProtected() || !this.exports.containsKey(packageName = clazz.getClassName().getPackageRef())) continue;
            Element cdef = this.classElement(clazz);
            this.packages.add(packageName, cdef);
        }
    }

    static Element getAPI(Analyzer analyzer) throws Exception {
        analyzer.analyze();
        JavaElement te = new JavaElement(analyzer);
        return te.getLocalAPI();
    }

    private Element getLocalAPI() throws Exception {
        ArrayList<Element> result = new ArrayList<Element>();
        for (Map.Entry entry : this.packages.entrySet()) {
            List set = (List)entry.getValue();
            Iterator i = set.iterator();
            while (i.hasNext()) {
                if (!this.notAccessible.contains(this.analyzer.getTypeRefFromFQN(((Element)i.next()).getName()))) continue;
                i.remove();
            }
            String version = this.exports.get((Descriptors.PackageRef)entry.getKey()).get("version");
            if (version != null) {
                Version v = new Version(version);
                set.add(new Element(Type.VERSION, v.getWithoutQualifier().toString(), null, Delta.IGNORED, Delta.IGNORED, null));
            }
            Element pd = new Element(Type.PACKAGE, ((Descriptors.PackageRef)entry.getKey()).getFQN(), set, Delta.MINOR, Delta.MAJOR, null);
            result.add(pd);
        }
        for (Clazz.JAVA java : this.javas) {
            result.add(new Element(Type.CLASS_VERSION, ((Object)((Object)java)).toString(), null, Delta.CHANGED, Delta.CHANGED, null));
        }
        return new Element(Type.API, "<api>", result, Delta.CHANGED, Delta.CHANGED, null);
    }

    Element classElement(final Clazz clazz) throws Exception {
        Element member;
        List<Element> children;
        Delta remove;
        Delta add;
        Element e = this.cache.get(clazz);
        if (e != null) {
            return e;
        }
        StringBuilder comment = new StringBuilder();
        final HashSet<Element> members = new HashSet<Element>();
        final Set<Clazz.MethodDef> methods = Create.set();
        final Set<Clazz.FieldDef> fields = Create.set();
        final MultiMap annotations = new MultiMap();
        Descriptors.TypeRef name = clazz.getClassName();
        String fqn = name.getFQN();
        String shortName = name.getShortName();
        Instructions matchers = this.providerMatcher.get(name.getPackageRef());
        boolean p = matchers != null && matchers.matches(shortName);
        final AtomicBoolean provider = new AtomicBoolean(p);
        Element before = this.cache.get(clazz);
        if (before != null) {
            return before;
        }
        clazz.parseClassFileWithCollector(new ClassDataCollector(){
            boolean memberEnd;
            Clazz.FieldDef last;
            Set<Element> OBJECT = Create.set();

            @Override
            public void version(int minor, int major) {
                JavaElement.this.javas.add(Clazz.JAVA.getJava(major, minor));
            }

            @Override
            public void method(Clazz.MethodDef defined) {
                if (defined.isProtected() || defined.isPublic()) {
                    this.last = defined;
                    methods.add(defined);
                } else {
                    this.last = null;
                }
            }

            @Override
            public void deprecated() {
                if (this.memberEnd) {
                    clazz.setDeprecated(true);
                } else if (this.last != null) {
                    this.last.setDeprecated(true);
                }
            }

            @Override
            public void field(Clazz.FieldDef defined) {
                if (defined.isProtected() || defined.isPublic()) {
                    this.last = defined;
                    fields.add(defined);
                } else {
                    this.last = null;
                }
            }

            @Override
            public void constant(Object o) {
                if (this.last != null) {
                    this.last.setConstant(o);
                }
            }

            @Override
            public void extendsClass(Descriptors.TypeRef name) throws Exception {
                Clazz c;
                String comment = null;
                if (!clazz.isInterface()) {
                    comment = this.inherit(members, name);
                }
                if (((c = JavaElement.this.analyzer.findClass(name)) == null || c.isPublic()) && !name.isObject()) {
                    members.add(new Element(Type.EXTENDS, name.getFQN(), null, Delta.MICRO, Delta.MAJOR, comment));
                }
            }

            @Override
            public void implementsInterfaces(Descriptors.TypeRef[] names) throws Exception {
                for (Descriptors.TypeRef name : names) {
                    String comment = null;
                    if (clazz.isInterface() || clazz.isAbstract()) {
                        comment = this.inherit(members, name);
                    }
                    members.add(new Element(Type.IMPLEMENTS, name.getFQN(), null, Delta.MINOR, Delta.MAJOR, comment));
                }
            }

            public String inherit(Set<Element> members2, Descriptors.TypeRef name) throws Exception {
                if (name.isObject()) {
                    if (this.OBJECT.isEmpty()) {
                        Clazz c = JavaElement.this.analyzer.findClass(name);
                        Element s = JavaElement.this.classElement(c);
                        for (Element child : s.children) {
                            if (!INHERITED.contains((Object)child.type)) continue;
                            String n = child.getName();
                            if (child.type == Type.METHOD && (n.startsWith("<init>") || "getClass()".equals(child.getName()) || n.startsWith("wait(") || n.startsWith("notify(") || n.startsWith("notifyAll("))) continue;
                            this.OBJECT.add(child);
                        }
                    }
                    members2.addAll(this.OBJECT);
                } else {
                    Clazz c = JavaElement.this.analyzer.findClass(name);
                    if (c == null) {
                        return "Cannot load " + name;
                    }
                    Element s = JavaElement.this.classElement(c);
                    for (Element child : s.children) {
                        if (!INHERITED.contains((Object)child.type) || child.name.startsWith("<")) continue;
                        members2.add(child);
                    }
                }
                return null;
            }

            @Override
            public void annotation(Annotation annotation) {
                Set properties = Create.set();
                if (Deprecated.class.getName().equals(annotation.getName().getFQN())) {
                    if (this.memberEnd) {
                        clazz.setDeprecated(true);
                    } else if (this.last != null) {
                        this.last.setDeprecated(true);
                    }
                    return;
                }
                for (String key : annotation.keySet()) {
                    StringBuilder sb = new StringBuilder();
                    sb.append(key);
                    sb.append('=');
                    this.toString(sb, annotation.get(key));
                    properties.add(new Element(Type.PROPERTY, sb.toString(), null, Delta.CHANGED, Delta.CHANGED, null));
                }
                if (this.memberEnd) {
                    members.add(new Element(Type.ANNOTATED, annotation.getName().getFQN(), properties, Delta.CHANGED, Delta.CHANGED, null));
                    if (ProviderType.class.getName().equals(annotation.getName().getFQN())) {
                        provider.set(true);
                    } else if (ConsumerType.class.getName().equals(annotation.getName().getFQN())) {
                        provider.set(false);
                    }
                } else if (this.last != null) {
                    annotations.add(this.last, new Element(Type.ANNOTATED, annotation.getName().getFQN(), properties, Delta.CHANGED, Delta.CHANGED, null));
                }
            }

            private void toString(StringBuilder sb, Object object) {
                if (object.getClass().isArray()) {
                    sb.append('[');
                    int l = Array.getLength(object);
                    for (int i = 0; i < l; ++i) {
                        this.toString(sb, Array.get(object, i));
                    }
                    sb.append(']');
                } else {
                    sb.append(object);
                }
            }

            @Override
            public void innerClass(Descriptors.TypeRef innerClass, Descriptors.TypeRef outerClass, String innerName, int innerClassAccessFlags) throws Exception {
                Clazz clazz2 = JavaElement.this.analyzer.findClass(innerClass);
                if (clazz2 != null) {
                    clazz2.setInnerAccess(innerClassAccessFlags);
                }
                if (Modifier.isProtected(innerClassAccessFlags) || Modifier.isPublic(innerClassAccessFlags)) {
                    return;
                }
                JavaElement.this.notAccessible.add(innerClass);
            }

            @Override
            public void memberEnd() {
                this.memberEnd = true;
            }
        });
        Type type = clazz.isInterface() ? (clazz.isAnnotation() ? Type.ANNOTATION : Type.INTERFACE) : (clazz.isEnum() ? Type.ENUM : Type.CLASS);
        if (type == Type.INTERFACE) {
            if (provider.get()) {
                add = Delta.MINOR;
                remove = Delta.MAJOR;
            } else {
                add = Delta.MAJOR;
                remove = Delta.MAJOR;
            }
        } else {
            add = Delta.MINOR;
            remove = Delta.MAJOR;
        }
        Set<Clazz.MethodDef> synthetic = Create.set();
        Iterator<Clazz.MethodDef> i = methods.iterator();
        while (i.hasNext()) {
            Clazz.MethodDef m = i.next();
            if (!m.isSynthetic()) continue;
            synthetic.add(m);
            i.remove();
        }
        for (Clazz.MethodDef m : methods) {
            children = (ArrayList<Element>)annotations.get(m);
            if (children == null) {
                children = new ArrayList<Element>();
            }
            JavaElement.access(children, m.getAccess(), m.isDeprecated());
            if (clazz.isFinal()) {
                children.remove(FINAL);
            }
            this.getCovariantReturns(children, m.getType());
            Iterator<Clazz.MethodDef> i2 = synthetic.iterator();
            while (i2.hasNext()) {
                Clazz.MethodDef s = i2.next();
                if (!s.getName().equals(m.getName()) || !Arrays.equals(s.getPrototype(), m.getPrototype())) continue;
                i2.remove();
                this.getCovariantReturns(children, s.getType());
            }
            member = new Element(Type.METHOD, m.getName() + this.toString(m.getPrototype()), children, add, remove, null);
            if (members.add(member)) continue;
            members.remove(member);
            members.add(member);
        }
        for (Clazz.MethodDef m : synthetic) {
            children = (List)annotations.get(m);
            if (children == null) {
                children = new ArrayList();
            }
            JavaElement.access(children, m.getAccess(), m.isDeprecated());
            if (clazz.isFinal()) {
                children.remove(FINAL);
            }
            this.getCovariantReturns(children, m.getType());
            member = new Element(Type.METHOD, m.getName() + this.toString(m.getPrototype()), children, add, remove, "synthetic");
            if (members.add(member)) continue;
            members.remove(member);
            members.add(member);
        }
        for (Clazz.FieldDef f : fields) {
            children = (List)annotations.get(f);
            if (children == null) {
                children = new ArrayList();
            }
            if (f.getConstant() != null) {
                children.add(new Element(Type.CONSTANT, f.getConstant().toString(), null, Delta.CHANGED, Delta.CHANGED, null));
            }
            JavaElement.access(children, f.getAccess(), f.isDeprecated());
            member = new Element(Type.FIELD, f.getType().getFQN() + " " + f.getName(), children, Delta.MINOR, Delta.MAJOR, null);
            if (members.add(member)) continue;
            members.remove(member);
            members.add(member);
        }
        JavaElement.access(members, clazz.getAccess(), clazz.isDeprecated());
        Element s = new Element(type, fqn, members, Delta.MINOR, Delta.MAJOR, comment.length() == 0 ? null : comment.toString());
        this.cache.put(clazz, s);
        return s;
    }

    private String toString(Descriptors.TypeRef[] prototype) {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        String del = "";
        for (Descriptors.TypeRef ref : prototype) {
            sb.append(del);
            sb.append(ref.getFQN());
            del = ",";
        }
        sb.append(")");
        return sb.toString();
    }

    private void getCovariantReturns(Collection<Element> elements, Descriptors.TypeRef type) throws Exception {
        if (type == null || type.isObject()) {
            return;
        }
        if (type.isPrimitive()) {
            Element e;
            if (type.getFQN().equals("void")) {
                return;
            }
            String name = type.getBinary();
            switch (name.charAt(0)) {
                case 'Z': {
                    e = BOOLEAN_R;
                    break;
                }
                case 'S': {
                    e = SHORT_R;
                    break;
                }
                case 'I': {
                    e = INT_R;
                    break;
                }
                case 'B': {
                    e = BYTE_R;
                    break;
                }
                case 'C': {
                    e = CHAR_R;
                    break;
                }
                case 'J': {
                    e = LONG_R;
                    break;
                }
                case 'F': {
                    e = FLOAT_R;
                    break;
                }
                case 'D': {
                    e = DOUBLE_R;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown primitive " + type);
                }
            }
            elements.add(e);
            return;
        }
        List<Element> set = (List<Element>)this.covariant.get(type);
        if (set != null) {
            elements.addAll((Collection<Element>)set);
            return;
        }
        Element current = new Element(Type.RETURN, type.getFQN());
        Clazz clazz = this.analyzer.findClass(type);
        if (clazz == null) {
            elements.add(current);
            return;
        }
        set = Create.list();
        set.add(current);
        this.getCovariantReturns(set, clazz.getSuper());
        Descriptors.TypeRef[] interfaces = clazz.getInterfaces();
        if (interfaces != null) {
            for (Descriptors.TypeRef intf : interfaces) {
                this.getCovariantReturns(set, intf);
            }
        }
        this.covariant.put(type, (Element)((Object)set));
        elements.addAll(set);
    }

    private static void access(Collection<Element> children, int access, boolean deprecated) {
        if (!Modifier.isPublic(access)) {
            children.add(PROTECTED);
        }
        if (Modifier.isAbstract(access)) {
            children.add(ABSTRACT);
        }
        if (Modifier.isFinal(access)) {
            children.add(FINAL);
        }
        if (Modifier.isStatic(access)) {
            children.add(STATIC);
        }
    }
}

