/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.deployer.blueprint;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.karaf.util.DeployerUtils;
import org.apache.karaf.util.MvnUtils;
import org.apache.karaf.util.XmlUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlueprintTransformer {
    public static void transform(URL url, OutputStream os) throws Exception {
        Object e;
        Document doc = BlueprintTransformer.parse(url);
        String name = MvnUtils.getMvnPath(url);
        int idx = name.lastIndexOf(47);
        if (idx >= 0) {
            name = name.substring(idx + 1);
        }
        String[] str = DeployerUtils.extractNameVersionType(name);
        Manifest m = new Manifest();
        m.getMainAttributes().putValue("Manifest-Version", "2");
        m.getMainAttributes().putValue("Bundle-ManifestVersion", "2");
        m.getMainAttributes().putValue("Bundle-SymbolicName", str[0]);
        m.getMainAttributes().putValue("Bundle-Version", str[1]);
        String importPkgs = BlueprintTransformer.getImportPackages(BlueprintTransformer.analyze(new DOMSource(doc)));
        if (importPkgs != null && importPkgs.length() > 0) {
            m.getMainAttributes().putValue("Import-Package", importPkgs);
        }
        m.getMainAttributes().putValue("DynamicImport-Package", "*");
        NodeList l = doc.getElementsByTagName("manifest");
        if (l != null) {
            for (int i = 0; i < l.getLength(); ++i) {
                e = (Element)l.item(i);
                String text = e.getTextContent();
                Properties props = new Properties();
                props.load(new ByteArrayInputStream(text.trim().getBytes()));
                Enumeration<?> en = props.propertyNames();
                while (en.hasMoreElements()) {
                    String k = (String)en.nextElement();
                    String v = props.getProperty(k);
                    m.getMainAttributes().putValue(k, v);
                }
                e.getParentNode().removeChild((Node)e);
            }
        }
        JarOutputStream out = new JarOutputStream(os);
        e = new ZipEntry("META-INF/MANIFEST.MF");
        out.putNextEntry((ZipEntry)e);
        m.write(out);
        out.closeEntry();
        e = new ZipEntry("OSGI-INF/");
        out.putNextEntry((ZipEntry)e);
        e = new ZipEntry("OSGI-INF/blueprint/");
        out.putNextEntry((ZipEntry)e);
        out.closeEntry();
        if (!name.endsWith(".xml")) {
            name = name + ".xml";
        }
        e = new ZipEntry("OSGI-INF/blueprint/" + name);
        out.putNextEntry((ZipEntry)e);
        XmlUtils.transform(new DOMSource(doc), new StreamResult(out));
        out.closeEntry();
        out.close();
    }

    public static Set<String> analyze(Source source) throws Exception {
        TreeSet<String> refers = new TreeSet<String>();
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        StreamResult r = new StreamResult(bout);
        XmlUtils.transform(new StreamSource(BlueprintTransformer.class.getResourceAsStream("extract.xsl")), source, r);
        ByteArrayInputStream bin = new ByteArrayInputStream(bout.toByteArray());
        bout.close();
        BufferedReader br = new BufferedReader(new InputStreamReader(bin));
        String line = br.readLine();
        while (line != null) {
            if ((line = line.trim()).length() > 0) {
                String[] parts = line.split("\\s*,\\s*");
                for (int i = 0; i < parts.length; ++i) {
                    String pkg;
                    int n = parts[i].lastIndexOf(46);
                    if (n <= 0 || (pkg = parts[i].substring(0, n)).startsWith("java.")) continue;
                    refers.add(pkg);
                }
            }
            line = br.readLine();
        }
        br.close();
        return refers;
    }

    protected static String getImportPackages(Set<String> packages) {
        StringBuilder sb = new StringBuilder();
        for (String pkg : packages) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(pkg);
        }
        return sb.toString();
    }

    protected static Document parse(URL url) throws Exception {
        return XmlUtils.parse(url.toString());
    }
}

