/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.main;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Properties;
import org.apache.karaf.main.DefaultJDBCLock;
import org.apache.karaf.main.Statements;

public class OracleJDBCLock
extends DefaultJDBCLock {
    private static final String MOMENT_COLUMN_DATA_TYPE = "NUMBER(20)";

    public OracleJDBCLock(Properties props) {
        super(props);
    }

    Statements createStatements() {
        Statements statements = new Statements();
        statements.setTableName(this.table);
        statements.setNodeName(this.clusterName);
        statements.setMomentColumnDataType(MOMENT_COLUMN_DATA_TYPE);
        return statements;
    }

    public boolean lock() {
        return this.aquireLock();
    }

    boolean updateLock() {
        return this.aquireLock();
    }

    boolean aquireLock() {
        return super.aquireLock() && this.lockAcquiredOnNonEmptySelection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean lockAcquiredOnNonEmptySelection() {
        String verifySelectionNotEmpytStatement = this.statements.getLockVerifySelectionNotEmptyStatement();
        PreparedStatement preparedStatement = null;
        boolean lockAquired = false;
        try {
            preparedStatement = this.getConnection().prepareStatement(verifySelectionNotEmpytStatement);
            preparedStatement.setQueryTimeout(this.timeout);
            ResultSet rs = preparedStatement.executeQuery();
            if (rs.next()) {
                lockAquired = rs.getInt(1) > 0;
            } else {
                this.LOG.warning("Failed to acquire database lock. Missing database lock record.");
            }
        }
        catch (Exception e) {
            this.LOG.warning("Failed to acquire database lock: " + e);
        }
        finally {
            this.closeSafely(preparedStatement);
        }
        return lockAquired;
    }
}

