/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.validation;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Properties;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.SecuritySupport;
import org.apache.servicemix.specs.locator.OsgiLocator;

final class SchemaFactoryFinder {
    private static boolean debug = false;
    private static Properties cacheProps = new Properties();
    private static boolean firstTime = true;
    private static final int DEFAULT_LINE_LENGTH = 80;
    private final ClassLoader classLoader;
    private static final Class SERVICE_CLASS;
    private static final String SERVICE_ID;

    private static void debugPrintln(String msg) {
        if (debug) {
            System.err.println("JAXP: " + msg);
        }
    }

    public SchemaFactoryFinder(ClassLoader loader) {
        this.classLoader = loader;
        if (debug) {
            this.debugDisplayClassLoader();
        }
    }

    private void debugDisplayClassLoader() {
        try {
            if (this.classLoader == SecuritySupport.getContextClassLoader()) {
                SchemaFactoryFinder.debugPrintln("using thread context class loader (" + this.classLoader + ") for search");
                return;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (this.classLoader == ClassLoader.getSystemClassLoader()) {
            SchemaFactoryFinder.debugPrintln("using system class loader (" + this.classLoader + ") for search");
            return;
        }
        SchemaFactoryFinder.debugPrintln("using class loader (" + this.classLoader + ") for search");
    }

    public SchemaFactory newFactory(String schemaLanguage) {
        if (schemaLanguage == null) {
            throw new NullPointerException();
        }
        SchemaFactory f = this._newFactory(schemaLanguage);
        if (debug) {
            if (f != null) {
                SchemaFactoryFinder.debugPrintln("factory '" + f.getClass().getName() + "' was found for " + schemaLanguage);
            } else {
                SchemaFactoryFinder.debugPrintln("unable to find a factory for " + schemaLanguage);
            }
        }
        return f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SchemaFactory _newFactory(String schemaLanguage) {
        SchemaFactory sf;
        block30: {
            String propertyName;
            block29: {
                propertyName = SERVICE_CLASS.getName() + ":" + schemaLanguage;
                try {
                    Class spiClass = OsgiLocator.locate(SERVICE_CLASS);
                    if (spiClass != null) {
                        return (SchemaFactory)spiClass.newInstance();
                    }
                }
                catch (Throwable e) {
                    // empty catch block
                }
                try {
                    String r;
                    if (debug) {
                        SchemaFactoryFinder.debugPrintln("Looking up system property '" + propertyName + "'");
                    }
                    if ((r = SecuritySupport.getSystemProperty(propertyName)) != null) {
                        if (debug) {
                            SchemaFactoryFinder.debugPrintln("The value is '" + r + "'");
                        }
                        if ((sf = this.createInstance(r)) != null) {
                            return sf;
                        }
                    } else if (debug) {
                        SchemaFactoryFinder.debugPrintln("The property is undefined.");
                    }
                }
                catch (Throwable t) {
                    if (!debug) break block29;
                    SchemaFactoryFinder.debugPrintln("failed to look up system property '" + propertyName + "'");
                    t.printStackTrace();
                }
            }
            String javah = SecuritySupport.getSystemProperty("java.home");
            String configFile = javah + File.separator + "lib" + File.separator + "jaxp.properties";
            String factoryClassName = null;
            try {
                if (firstTime) {
                    Properties properties = cacheProps;
                    synchronized (properties) {
                        if (firstTime) {
                            File f = new File(configFile);
                            firstTime = false;
                            if (SecuritySupport.doesFileExist(f)) {
                                if (debug) {
                                    SchemaFactoryFinder.debugPrintln("Read properties file " + f);
                                }
                                cacheProps.load(SecuritySupport.getFileInputStream(f));
                            }
                        }
                    }
                }
                factoryClassName = cacheProps.getProperty(propertyName);
                if (debug) {
                    SchemaFactoryFinder.debugPrintln("found " + factoryClassName + " in $java.home/jaxp.properties");
                }
                if (factoryClassName != null && (sf = this.createInstance(factoryClassName)) != null) {
                    return sf;
                }
            }
            catch (Exception ex) {
                if (!debug) break block30;
                ex.printStackTrace();
            }
        }
        Iterator sitr = this.createServiceFileIterator();
        while (sitr.hasNext()) {
            URL resource = (URL)sitr.next();
            if (debug) {
                SchemaFactoryFinder.debugPrintln("looking into " + resource);
            }
            try {
                sf = this.loadFromServicesFile(schemaLanguage, resource.toExternalForm(), SecuritySupport.getURLInputStream(resource));
                if (sf == null) continue;
                return sf;
            }
            catch (IOException e) {
                if (!debug) continue;
                SchemaFactoryFinder.debugPrintln("failed to read " + resource);
                e.printStackTrace();
            }
        }
        if (schemaLanguage.equals("http://www.w3.org/2001/XMLSchema")) {
            if (debug) {
                SchemaFactoryFinder.debugPrintln("attempting to use the platform default XML Schema 1.0 validator");
            }
            return this.createInstance("com.sun.org.apache.xerces.internal.jaxp.validation.XMLSchemaFactory");
        }
        if (debug) {
            SchemaFactoryFinder.debugPrintln("all things were tried, but none was found. bailing out.");
        }
        return null;
    }

    SchemaFactory createInstance(String className) {
        block6: {
            try {
                Object o;
                if (debug) {
                    SchemaFactoryFinder.debugPrintln("instanciating " + className);
                }
                Class<?> clazz = this.classLoader != null ? this.classLoader.loadClass(className) : Class.forName(className);
                if (debug) {
                    SchemaFactoryFinder.debugPrintln("loaded it from " + SchemaFactoryFinder.which(clazz));
                }
                if ((o = clazz.newInstance()) instanceof SchemaFactory) {
                    return (SchemaFactory)o;
                }
                if (debug) {
                    SchemaFactoryFinder.debugPrintln(className + " is not assignable to " + SERVICE_CLASS.getName());
                }
            }
            catch (Throwable t) {
                SchemaFactoryFinder.debugPrintln("failed to instanciate " + className);
                if (!debug) break block6;
                t.printStackTrace();
            }
        }
        return null;
    }

    private Iterator createServiceFileIterator() {
        if (this.classLoader == null) {
            return new SingleIterator(){

                protected Object value() {
                    ClassLoader classLoader = SchemaFactoryFinder.class.getClassLoader();
                    return SecuritySupport.getResourceAsURL(classLoader, SERVICE_ID);
                }
            };
        }
        try {
            final Enumeration e = SecuritySupport.getResources(this.classLoader, SERVICE_ID);
            if (debug && !e.hasMoreElements()) {
                SchemaFactoryFinder.debugPrintln("no " + SERVICE_ID + " file was found");
            }
            return new Iterator(){

                public void remove() {
                    throw new UnsupportedOperationException();
                }

                public boolean hasNext() {
                    return e.hasMoreElements();
                }

                public Object next() {
                    return e.nextElement();
                }
            };
        }
        catch (IOException e) {
            if (debug) {
                SchemaFactoryFinder.debugPrintln("failed to enumerate resources " + SERVICE_ID);
                e.printStackTrace();
            }
            return new ArrayList().iterator();
        }
    }

    private SchemaFactory loadFromServicesFile(String schemaLanguage, String resourceName, InputStream in) {
        BufferedReader rd;
        if (debug) {
            SchemaFactoryFinder.debugPrintln("Reading " + resourceName);
        }
        try {
            rd = new BufferedReader(new InputStreamReader(in, "UTF-8"), 80);
        }
        catch (UnsupportedEncodingException e) {
            rd = new BufferedReader(new InputStreamReader(in), 80);
        }
        String factoryClassName = null;
        SchemaFactory resultFactory = null;
        while (true) {
            try {
                factoryClassName = rd.readLine();
            }
            catch (IOException x) {
                break;
            }
            if (factoryClassName == null) break;
            int hashIndex = factoryClassName.indexOf(35);
            if (hashIndex != -1) {
                factoryClassName = factoryClassName.substring(0, hashIndex);
            }
            if ((factoryClassName = factoryClassName.trim()).length() == 0) continue;
            try {
                SchemaFactory foundFactory = this.createInstance(factoryClassName);
                if (!foundFactory.isSchemaLanguageSupported(schemaLanguage)) continue;
                resultFactory = foundFactory;
            }
            catch (Exception e) {
                continue;
            }
            break;
        }
        try {
            rd.close();
        }
        catch (IOException exc) {
            // empty catch block
        }
        return resultFactory;
    }

    private static String which(Class clazz) {
        return SchemaFactoryFinder.which(clazz.getName(), clazz.getClassLoader());
    }

    private static String which(String classname, ClassLoader loader) {
        URL it;
        String classnameAsResource = classname.replace('.', '/') + ".class";
        if (loader == null) {
            loader = ClassLoader.getSystemClassLoader();
        }
        if ((it = SecuritySupport.getResourceAsURL(loader, classnameAsResource)) != null) {
            return it.toString();
        }
        return null;
    }

    static {
        try {
            String val = SecuritySupport.getSystemProperty("jaxp.debug");
            debug = val != null && !"false".equals(val);
        }
        catch (Exception _) {
            debug = false;
        }
        SERVICE_CLASS = SchemaFactory.class;
        SERVICE_ID = "META-INF/services/" + SERVICE_CLASS.getName();
    }

    private static abstract class SingleIterator
    implements Iterator {
        private boolean seen = false;

        private SingleIterator() {
        }

        public final void remove() {
            throw new UnsupportedOperationException();
        }

        public final boolean hasNext() {
            return !this.seen;
        }

        public final Object next() {
            if (this.seen) {
                throw new NoSuchElementException();
            }
            this.seen = true;
            return this.value();
        }

        protected abstract Object value();
    }
}

