/*
 * Decompiled with CFR 0.152.
 */
package aQute.lib.collections;

import aQute.lib.collections.IteratorList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.SortedSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SortedList<T>
implements SortedSet<T>,
List<T> {
    static SortedList<?> empty = new SortedList();
    final T[] list;
    final int start;
    final int end;
    final Comparator<T> cmp;
    Class<?> type;
    static Comparator<Object> comparator = new Comparator<Object>(){

        @Override
        public int compare(Object o1, Object o2) {
            if (o1 == o2) {
                return 0;
            }
            if (o1.equals(o2)) {
                return 0;
            }
            return ((Comparable)o1).compareTo(o2);
        }
    };

    public SortedList(Collection<? extends Comparable<?>> x) {
        this(x, 0, x.size(), comparator);
    }

    public SortedList(Collection<T> x, Comparator<T> cmp) {
        this(x, 0, x.size(), cmp);
    }

    public SortedList(T ... x) {
        this((Object[])x.clone(), 0, x.length, comparator);
    }

    public SortedList(Comparator<T> cmp, T ... x) {
        this((Object[])x.clone(), 0, x.length, cmp);
    }

    private SortedList(SortedList<T> other, int start, int end) {
        this.list = other.list;
        this.cmp = other.cmp;
        this.start = start;
        this.end = end;
    }

    public SortedList(T[] x, int start, int end, Comparator<T> comparator2) {
        if (start > end) {
            int tmp = start;
            start = end;
            end = tmp;
        }
        if (start < 0 || start >= x.length) {
            throw new IllegalArgumentException("Start is not in list");
        }
        if (end < 0 || end > x.length) {
            throw new IllegalArgumentException("End is not in list");
        }
        this.list = (Object[])x.clone();
        Arrays.sort(this.list, start, end, comparator2);
        this.start = start;
        this.end = end;
        this.cmp = comparator2;
    }

    public SortedList(Collection<? extends T> x, int start, int end, Comparator<T> cmp) {
        if (start > end) {
            int tmp = start;
            start = end;
            end = tmp;
        }
        if (start < 0 || start > x.size()) {
            throw new IllegalArgumentException("Start is not in list");
        }
        if (end < 0 || end > x.size()) {
            throw new IllegalArgumentException("End is not in list");
        }
        this.list = x.toArray();
        Arrays.sort(this.list, start, end, cmp);
        this.start = start;
        this.end = end;
        this.cmp = cmp;
    }

    private SortedList() {
        this.list = null;
        this.start = 0;
        this.end = 0;
        this.cmp = null;
    }

    @Override
    public int size() {
        return this.end - this.start;
    }

    @Override
    public boolean isEmpty() {
        return this.start == this.end;
    }

    @Override
    public boolean contains(Object o) {
        assert (this.type != null & this.type.isInstance(o));
        return this.indexOf(o) >= 0;
    }

    @Override
    public Iterator<T> iterator() {
        return new It(this.start);
    }

    @Override
    public Object[] toArray() {
        return (Object[])this.list.clone();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        if (a == null || a.length < this.list.length) {
            return (Object[])this.list.clone();
        }
        System.arraycopy(this.list, 0, a, 0, this.list.length);
        return a;
    }

    @Override
    public boolean add(T e) {
        throw new UnsupportedOperationException("Immutable");
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException("Immutable");
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        if (c.isEmpty()) {
            return true;
        }
        if (this.isEmpty()) {
            return false;
        }
        for (Object el : c) {
            if (this.contains(el)) continue;
            return false;
        }
        return false;
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        throw new UnsupportedOperationException("Immutable");
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException("Immutable");
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException("Immutable");
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("Immutable");
    }

    @Override
    public Comparator<? super T> comparator() {
        return this.cmp;
    }

    public boolean isSubSet() {
        return this.start > 0 && this.end < this.list.length;
    }

    @Override
    public SortedList<T> subSet(T fromElement, T toElement) {
        int start = this.indexOf(fromElement);
        int end = this.indexOf(toElement);
        if (this.isSubSet() && (start < 0 || end < 0)) {
            throw new IllegalArgumentException("This list is a subset");
        }
        if (start < 0) {
            start = 0;
        }
        if (end < 0) {
            end = this.list.length;
        }
        return this.subList(start, end);
    }

    @Override
    public int indexOf(Object o) {
        assert (this.type != null && this.type.isInstance(o));
        int n = Arrays.binarySearch(this.list, o, this.cmp);
        if (n >= this.start && n < this.end) {
            return n - this.start;
        }
        return -1;
    }

    @Override
    public SortedList<T> headSet(T toElement) {
        int i = this.indexOf(toElement);
        if (i < 0) {
            if (this.isSubSet()) {
                throw new IllegalArgumentException("This list is a subset");
            }
            i = this.end;
        }
        if (i == this.end) {
            return this;
        }
        return this.subList(0, i);
    }

    @Override
    public SortedSet<T> tailSet(T fromElement) {
        int i = this.indexOf(fromElement);
        if (i < 0) {
            if (this.isSubSet()) {
                throw new IllegalArgumentException("This list is a subset");
            }
            i = this.start;
        }
        return this.subList(i, this.end);
    }

    @Override
    public T first() {
        if (this.isEmpty()) {
            throw new NoSuchElementException("first");
        }
        return this.get(0);
    }

    @Override
    public T last() {
        if (this.isEmpty()) {
            throw new NoSuchElementException("last");
        }
        return this.get(this.end - 1);
    }

    @Override
    @Deprecated
    public boolean addAll(int index, Collection<? extends T> c) {
        throw new UnsupportedOperationException("Immutable");
    }

    @Override
    public T get(int index) {
        return this.list[index + this.start];
    }

    @Override
    @Deprecated
    public T set(int index, T element) {
        throw new UnsupportedOperationException("Immutable");
    }

    @Override
    @Deprecated
    public void add(int index, T element) {
        throw new UnsupportedOperationException("Immutable");
    }

    @Override
    @Deprecated
    public T remove(int index) {
        throw new UnsupportedOperationException("Immutable");
    }

    @Override
    public int lastIndexOf(Object o) {
        int n = this.indexOf(o);
        if (n < 0) {
            return -1;
        }
        while (this.cmp.compare(this.list[n], o) == 0) {
            ++n;
        }
        return n;
    }

    @Override
    public ListIterator<T> listIterator() {
        return new It(this.start);
    }

    @Override
    public ListIterator<T> listIterator(int index) {
        return new It(index + this.start);
    }

    @Override
    public SortedList<T> subList(int fromIndex, int toIndex) {
        if ((toIndex += this.start) < (fromIndex += this.start)) {
            int tmp = toIndex;
            toIndex = fromIndex;
            fromIndex = tmp;
        }
        toIndex = Math.max(0, toIndex);
        toIndex = Math.min(toIndex, this.end);
        fromIndex = Math.max(0, fromIndex);
        if ((fromIndex = Math.min(fromIndex, this.end)) == this.start && toIndex == this.end) {
            return this;
        }
        return new SortedList<T>(this, fromIndex, toIndex);
    }

    @Override
    @Deprecated
    public boolean equals(Object other) {
        return super.equals(other);
    }

    @Override
    @Deprecated
    public int hashCode() {
        return super.hashCode();
    }

    public boolean isEqual(SortedList<T> list) {
        if (this.size() != list.size()) {
            return false;
        }
        int as = this.start;
        int al = this.size();
        for (int bs = list.start; as < al && bs < al; ++as, ++bs) {
            if (comparator.compare(this.list[as], this.list[bs]) == 0) continue;
            return false;
        }
        return true;
    }

    public Class<?> getType() {
        return this.type;
    }

    public void setType(Class<?> type) {
        this.type = type;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        String del = "";
        for (T s : this.list) {
            sb.append(del);
            sb.append(s);
            del = ", ";
        }
        sb.append("]");
        return sb.toString();
    }

    public boolean hasDuplicates() {
        if (this.list.length < 2) {
            return false;
        }
        T prev = this.list[0];
        for (int i = 1; i < this.list.length; ++i) {
            if (!prev.equals(this.list[i])) continue;
            return true;
        }
        return false;
    }

    public static <T extends Comparable<?>> SortedList<T> fromIterator(Iterator<T> it) {
        IteratorList<T> l = new IteratorList<T>(it);
        return new SortedList<T>((Collection<Comparable<?>>)l);
    }

    public static <T> SortedList<T> fromIterator(Iterator<T> it, Comparator<T> cmp) {
        IteratorList<T> l = new IteratorList<T>(it);
        return new SortedList<T>(l, cmp);
    }

    public static <T> SortedSet<T> empty() {
        return empty;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class It
    implements ListIterator<T> {
        int n;

        It(int n) {
            this.n = n;
        }

        @Override
        public boolean hasNext() {
            return this.n < SortedList.this.end;
        }

        @Override
        public T next() throws NoSuchElementException {
            if (!this.hasNext()) {
                throw new NoSuchElementException("");
            }
            return SortedList.this.list[this.n++];
        }

        @Override
        public boolean hasPrevious() {
            return this.n > SortedList.this.start;
        }

        @Override
        public T previous() {
            return SortedList.this.get(this.n - 1);
        }

        @Override
        public int nextIndex() {
            return this.n + 1 - SortedList.this.start;
        }

        @Override
        public int previousIndex() {
            return this.n - 1 - SortedList.this.start;
        }

        @Override
        @Deprecated
        public void remove() {
            throw new UnsupportedOperationException("Immutable");
        }

        @Override
        @Deprecated
        public void set(T e) {
            throw new UnsupportedOperationException("Immutable");
        }

        @Override
        @Deprecated
        public void add(T e) {
            throw new UnsupportedOperationException("Immutable");
        }
    }
}

