<%--

//
// This file is part of the OpenNMS(R) Application.
//
// OpenNMS(R) is Copyright (C) 2002-2003 The OpenNMS Group, Inc.  All rights reserved.
// OpenNMS(R) is a derivative work, containing both original code, included code and modified
// code that was published under the GNU General Public License. Copyrights for modified 
// and included code are below.
//
// OpenNMS(R) is a registered trademark of The OpenNMS Group, Inc.
//
// Modifications:
//
// 2003 Feb 07: Fixed URLEncoder issues.
// 
// Original code base Copyright (C) 1999-2001 Oculan Corp.  All rights reserved.
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// For more information contact:
//      OpenNMS Licensing       <license@opennms.org>
//      http://www.opennms.org/
//      http://www.opennms.com/
//

--%>

<%@page language="java"
	contentType="text/html"
	session="true"
	import="org.opennms.web.springframework.security.Authentication"
%>

<jsp:include page="/includes/header.jsp" flush="false" >
  <jsp:param name="title" value="Vulnerabilities" />
  <jsp:param name="headTitle" value="Vulnerabilities" />
  <jsp:param name="location" value="vulnerability" />
  <jsp:param name="breadcrumb" value="Vulnerabilities" />
</jsp:include>

  <div class="TwoColLeft">
      <h3>Vulnerability Menu</h3>    
      <div class="boxWrapper">
                        <ul class="plain">
    				<li><a href="vulnerability/list?restype=open">View all open vulnerabilities</a></li>
				<li><a href="vulnerability/list?restype=res">View all resolved vulnerabilities</a></li>
    				<li><form method="get" action="vulnerability/detail.jsp">
      				Get&nbsp;details&nbsp;for&nbsp;Vulnerability&nbsp;ID:<br/>
      				<input type="text" name="id" />
				<input type="submit" value="Search" />
    				</form></li>
                        </ul>
                </div>
  </div>


<div class="TwoColRight">
  <h3>Vulnerability Scanning</h3>
 <div class="boxWrapper">

  <p>
    Vulnerability scanning finds <em>system vulnerabilities</em>
    that can be exploited by harmful network traffic. This harmful traffic
    can be generated by intruders to gain access to restricted information,
    alter the flow of data through your network, or even disable important
    services on your network.
  </p>

  <p>
    Vulnerability scanning provides the following information about your
    network devices:
  </p>
    <ul class="plain">
      <li>Detection and diagnosis of open vulnerabilities</li>
      <li>Deep detection of all open ports and services</li>
      <li>Logging of all available information that may benefit intruders</li>
      <li>Detection of passwords that are set to default or easy-to-guess
        values</li>
    </ul>

  <p>
    With this information, you can take steps to make your network more
    secure from network-based intrusion:
  </p>
    <ul class="plain">
      <li>Apply patches and software updates to fix known security holes</li>
      <li>Shut down unwanted or unnecessary services</li>
      <li>Remove access to sensitive information on your network</li>
      <li>Change security settings and passwords to make them more difficult
        to crack</li>
    </ul>

  <p>
    Open vulnerabilities are issues that have been detected by the scanning
    process and currently affect the target address. When a vulnerability
    has been fixed, the scanning process will confirm that the vulnerability
    no longer exists and resolve it automatically.
  </p>

  <p>
    The vulnerability scanning process can be performed at Scan Levels 1
    through 4.  The higher the scan level, the more invasive the scan will
    be to the target IP address. Use caution when performing scans with
    Scan Level 3 and 4; although the information they provide may be more
    accurate and comprehensive, they can also expose the target machines
    to dangerous exploits that may cause data loss or denial of services.
    Scan levels can only be changed by an administrator.
  </p>     
</div>
</div>
<hr />

<jsp:include page="/includes/footer.jsp" flush="false" />
