<%--

//
// This file is part of the OpenNMS(R) Application.
//
// OpenNMS(R) is Copyright (C) 2002-2009 The OpenNMS Group, Inc.  All rights reserved.
// OpenNMS(R) is a derivative work, containing both original code, included code and modified
// code that was published under the GNU General Public License. Copyrights for modified 
// and included code are below.
//
// OpenNMS(R) is a registered trademark of The OpenNMS Group, Inc.
//
// Modifications:
//
// 2009 Apr: refactoring to support ACL DAO work
// 2003 Feb 07: Fixed URLEncoder issues.
// 2002 Nov 26: Fixed breadcrumbs issue.
// 
// Original code base Copyright (C) 1999-2001 Oculan Corp.  All rights reserved.
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// For more information contact:
//      OpenNMS Licensing       <license@opennms.org>
//      http://www.opennms.org/
//      http://www.opennms.com/
//

--%>

<%@page language="java"
	contentType="text/html"
	session="true"
	import="org.opennms.web.WebSecurityUtils,
			org.opennms.web.vulnerability.*,
        	org.opennms.web.MissingParameterException,
        	org.opennms.netmgt.model.OnmsSeverity,
		java.text.DateFormat
	"
%>

<%!
    public static DateFormat DATE_FORMAT =
	DateFormat.getDateTimeInstance(DateFormat.SHORT, DateFormat.MEDIUM);
%>

<%
    String vulIdString = request.getParameter("id");

    if (vulIdString == null) {
        throw new MissingParameterException("id");
    }

    int vulId = -1;

    try {
        vulId = WebSecurityUtils.safeParseInt(vulIdString);
    } catch (NumberFormatException e) {
        throw new VulnerabilityIdNotFoundException("The vulnerability "
						   + "identifier must be an "
						   + "integer.", vulIdString);
    }

    Vulnerability vul = VulnerabilityFactory.getVulnerability(vulId);

    if (vul == null) {
        throw new VulnerabilityIdNotFoundException("A vulnerability with "
						   + "this id was not found.",
						   String.valueOf(vulId));
    }  
%>

<jsp:include page="/includes/header.jsp" flush="false" >
  <jsp:param name="title" value="Vulnerability Detail" />
  <jsp:param name="headTitle" value="Detail" />
  <jsp:param name="headTitle" value="Vulnerabilities" />
  <jsp:param name="breadcrumb" value="<a href='vulnerability/index.jsp'>Vulnerabilities</a>" />
  <jsp:param name="breadcrumb" value="Detail" />
</jsp:include>

<h3>Vulnerability: <%=vul.getId()%></h3>
    
      <!-- details -->
      <table >
	<tr class="<%= vul.getSeverity().getLabel() %>">
          <td class="divider" width="10%">Severity</td>
          <td class="divider" bgcolor="<%= vul.getSeverity().getColor() %>"><%= vul.getSeverity().getLabel() %></td>

          <td class="divider" width="10%">Node:</td>
          <td class="divider">
            <% if (vul.getNodeId() != null) { %>
              <a href="element/node.jsp?node=<%=vul.getNodeId()%>"><%=vul.getNodeLabel()%></a>
            <% } else {%>
              &nbsp;
            <% } %>
          </td>

          <td class="divider" width="10%">Protocol:</td>
          <td class="divider">
            <% if( vul.getProtocol() != null ) { %>
              <%=vul.getProtocol()%>
            <% } else {%>
              &nbsp;
            <% } %>
          </td>                   
        </tr>
        <tr class="<%= vul.getSeverity().getLabel() %>">
          <td >Discovered:</td>
          <td ><%=DATE_FORMAT.format(vul.getCreateTime())%></td>

          <td >Interface:</td>
          <td >
            <% if( vul.getIpAddress() != null ) { %>
              <% if( vul.getNodeId() != null ) { %>
                <a href="element/interface.jsp?node=<%=vul.getNodeId()%>&intf=<%=vul.getIpAddress()%>"><%=vul.getIpAddress()%></a>
              <% } else { %>
                <%=vul.getIpAddress()%>
              <% } %>
            <% } else {%>
              &nbsp;
            <% } %>
          </td>

          <td >Port:</td>
          <td >
            <% if( vul.getPort() != null ) { %>
              <%=vul.getPort()%>
            <% } else {%>
              &nbsp;
            <% } %>
          </td>
        </tr>

        <tr class="<%= vul.getSeverity().getLabel() %>">
          <td >Resolved:</td>
          <td >
            <% if(vul.getResolvedTime() != null ) { %>
              <%=DATE_FORMAT.format(vul.getResolvedTime())%>
            <% } else { %>
              OPEN
            <% } %>
          </td>

          <td >Last Scan:</td>
          <td ><%=DATE_FORMAT.format(vul.getLastScanTime())%></td>

          <td >Last Scan Attempt:</td>
          <td ><%=DATE_FORMAT.format(vul.getLastAttemptTime())%></td>

        </tr>
      </table>

      <!-- log message -->  
      <table >
        <tr class="<%= vul.getSeverity().getLabel() %>">
	  <td >Log Message</td>
        </tr>
        <tr class="<%= vul.getSeverity().getLabel() %>">
          <td><%=vul.getLogMessage()%></td>
        </tr>
      </table>
      
      <!-- description -->  
      <table >
        <tr class="<%= vul.getSeverity().getLabel() %>">
          <td>Description</td>
        </tr>
        <tr  class="<%= vul.getSeverity().getLabel() %>">
          <td><%=vul.getDescription()%></td>
        </tr>
      </table>             
    
<jsp:include page="/includes/footer.jsp" flush="false" />
