/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.springframework.security;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.naming.directory.SearchControls;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.ldap.core.ContextSource;
import org.springframework.ldap.core.DirContextOperations;
import org.springframework.security.GrantedAuthority;
import org.springframework.security.GrantedAuthorityImpl;
import org.springframework.security.ldap.LdapAuthoritiesPopulator;
import org.springframework.security.ldap.SpringSecurityLdapTemplate;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserGroupLdapAuthoritiesPopulator
implements LdapAuthoritiesPopulator {
    private static final Log logger = LogFactory.getLog(UserGroupLdapAuthoritiesPopulator.class);
    private GrantedAuthority defaultRole;
    private SpringSecurityLdapTemplate ldapTemplate;
    private SearchControls searchControls = new SearchControls();
    private String groupRoleAttribute = "cn";
    private String groupSearchBase;
    private String groupSearchFilter = "(member={0})";
    private Map<String, List<String>> groupToRoleMap = new HashMap<String, List<String>>();

    public UserGroupLdapAuthoritiesPopulator(ContextSource contextSource, String groupSearchBase) {
        Assert.notNull((Object)contextSource, (String)"contextSource must not be null");
        this.ldapTemplate = new SpringSecurityLdapTemplate(contextSource);
        this.ldapTemplate.setSearchControls(this.searchControls);
        this.setGroupSearchBase(groupSearchBase);
    }

    public final GrantedAuthority[] getGrantedAuthorities(DirContextOperations user, String username) {
        String userDn = user.getNameInNamespace();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Getting authorities for user " + userDn));
        }
        Set<GrantedAuthority> roles = this.getGroupMembershipRoles(userDn, username);
        if (this.defaultRole != null) {
            roles.add(this.defaultRole);
            logger.debug((Object)("Added default role: " + this.defaultRole));
        }
        return roles.toArray(new GrantedAuthority[roles.size()]);
    }

    public Set<GrantedAuthority> getGroupMembershipRoles(String userDn, String username) {
        HashSet<GrantedAuthority> authorities = new HashSet<GrantedAuthority>();
        if (this.getGroupSearchBase() == null) {
            return authorities;
        }
        logger.debug((Object)("Searching for groups for user '" + username + "', DN = " + "'" + userDn + "', with filter " + this.groupSearchFilter + " in search base '" + this.getGroupSearchBase() + "'"));
        Set groups = this.ldapTemplate.searchForSingleAttributeValues(this.getGroupSearchBase(), this.groupSearchFilter, (Object[])new String[]{userDn, username}, this.groupRoleAttribute);
        logger.debug((Object)("Groups from search: " + groups));
        Set<String> roles = this.getRolesFromGroups(groups);
        for (String role : roles) {
            authorities.add((GrantedAuthority)new GrantedAuthorityImpl(role));
        }
        return authorities;
    }

    protected Set<String> getRolesFromGroups(Set<String> groups) {
        HashSet<String> roles = new HashSet<String>();
        for (String group : groups) {
            List<String> rolesForGroup = this.groupToRoleMap.get(group);
            logger.debug((Object)("Checking " + group + " for an associated role"));
            if (rolesForGroup == null) continue;
            for (String role : rolesForGroup) {
                roles.add(role);
                logger.debug((Object)("Added role: " + role + " based on group " + group));
            }
        }
        return roles;
    }

    protected ContextSource getContextSource() {
        return this.ldapTemplate.getContextSource();
    }

    private void setGroupSearchBase(String groupSearchBase) {
        Assert.notNull((Object)groupSearchBase, (String)"The groupSearchBase (name to search under), must not be null.");
        this.groupSearchBase = groupSearchBase;
        if (groupSearchBase.length() == 0) {
            logger.info((Object)"groupSearchBase is empty. Searches will be performed from the context source base");
        }
    }

    protected String getGroupSearchBase() {
        return this.groupSearchBase;
    }

    public void setGroupToRoleMap(Map<String, List<String>> groupToRoleMap) {
        this.groupToRoleMap = groupToRoleMap;
    }

    public void setDefaultRole(String defaultRole) {
        Assert.notNull((Object)defaultRole, (String)"The defaultRole property cannot be set to null");
        this.defaultRole = new GrantedAuthorityImpl(defaultRole);
    }

    public void setGroupRoleAttribute(String groupRoleAttribute) {
        Assert.notNull((Object)groupRoleAttribute, (String)"groupRoleAttribute must not be null");
        this.groupRoleAttribute = groupRoleAttribute;
    }

    public void setGroupSearchFilter(String groupSearchFilter) {
        Assert.notNull((Object)groupSearchFilter, (String)"groupSearchFilter must not be null");
        this.groupSearchFilter = groupSearchFilter;
    }

    public void setSearchSubtree(boolean searchSubtree) {
        int searchScope = searchSubtree ? 2 : 1;
        this.searchControls.setSearchScope(searchScope);
    }
}

