/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.springframework.security;

import java.io.IOException;
import java.util.List;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opennms.netmgt.config.GroupDao;
import org.opennms.netmgt.config.groups.Group;
import org.opennms.netmgt.model.FilterManager;
import org.opennms.web.AclUtils;
import org.springframework.security.context.SecurityContextHolder;
import org.springframework.security.ui.FilterChainOrder;
import org.springframework.security.ui.SpringSecurityFilter;

public class AuthFilterEnabler
extends SpringSecurityFilter {
    private FilterManager m_filterManager;
    private GroupDao m_groupDao;

    public void setFilterManager(FilterManager filterManager) {
        this.m_filterManager = filterManager;
    }

    public void setGroupDao(GroupDao groupDao) {
        this.m_groupDao = groupDao;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doFilterHttp(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        boolean shouldFilter = AclUtils.shouldFilter();
        try {
            if (shouldFilter) {
                String user = SecurityContextHolder.getContext().getAuthentication().getName();
                List groups = this.m_groupDao.findGroupsForUser(user);
                String[] groupNames = new String[groups.size()];
                for (int i = 0; i < groups.size(); ++i) {
                    groupNames[i] = ((Group)groups.get(i)).getName();
                }
                this.m_filterManager.enableAuthorizationFilter(groupNames);
            }
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
        finally {
            if (shouldFilter) {
                this.m_filterManager.disableAuthorizationFilter();
            }
        }
    }

    public int getOrder() {
        return FilterChainOrder.getOrder((String)"LAST");
    }
}

