/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.test;

import java.lang.reflect.Method;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestResult;
import junit.framework.TestSuite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VersionSettingTestSuite
extends TestSuite {
    int m_version;

    public VersionSettingTestSuite(int version) {
        this.m_version = version;
    }

    public VersionSettingTestSuite(Class<? extends TestCase> theClass, String name, int version) {
        super(theClass, name);
        this.m_version = version;
        this.checkForVersionMethod(theClass);
    }

    public VersionSettingTestSuite(Class<? extends TestCase> theClass, int version) {
        super(theClass);
        this.m_version = version;
        this.checkForVersionMethod(theClass);
    }

    public VersionSettingTestSuite(String name, int version) {
        super(name);
        this.m_version = version;
    }

    private void checkForVersionMethod(final Class theClass) {
        try {
            this.getSetVersionMethod(theClass);
        }
        catch (NoSuchMethodException e) {
            this.addTest((Test)new TestCase("warning"){

                protected void runTest() {
                    1.fail((String)("Unable to locate setVersion method in class " + theClass.getName() + ": " + e));
                }
            });
        }
    }

    private Method getSetVersionMethod(Class theClass) throws NoSuchMethodException {
        return theClass.getMethod("setVersion", Integer.TYPE);
    }

    public void runTest(Test test, TestResult result) {
        this.setVersion(test);
        super.runTest(test, result);
    }

    private void setVersion(Test test) {
        try {
            Method m = this.getSetVersionMethod(test.getClass());
            m.invoke((Object)test, new Integer(this.m_version));
        }
        catch (Exception e) {
            AssertionFailedError newE = new AssertionFailedError("Could not call setVersion on " + test.getClass().getName() + ": " + e);
            newE.initCause((Throwable)e);
            throw newE;
        }
    }
}

