/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.serviceregistration.strategies;

import java.util.Hashtable;
import javax.jmdns.JmDNS;
import javax.jmdns.ServiceInfo;
import org.opennms.serviceregistration.ServiceRegistrationStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JMDNSStrategy
implements ServiceRegistrationStrategy {
    private boolean registered = false;
    private JmDNS jmdns;
    private ServiceInfo si;

    @Override
    public void initialize(String serviceType, String serviceName, int port) throws Exception {
        this.initialize(serviceType, serviceName, port, null);
    }

    @Override
    public void initialize(String serviceType, String serviceName, int port, Hashtable<String, String> properties) throws Exception {
        if (this.registered) {
            throw new Exception("You have already registered a service with this object!");
        }
        serviceType = "_" + serviceType.toLowerCase() + "._tcp.local.";
        this.jmdns = JmDNS.create();
        this.si = ServiceInfo.create((String)serviceType, (String)serviceName, (int)port, (int)0, (int)0, properties);
    }

    @Override
    public void register() throws Exception {
        if (!this.registered) {
            this.jmdns.registerService(this.si);
            this.registered = true;
        } else {
            System.err.println("WARNING: register() called but the service has already been registered!");
        }
    }

    @Override
    public void unregister() throws Exception {
        if (this.registered) {
            if (this.jmdns != null && this.si != null) {
                this.jmdns.unregisterService(this.si);
                this.jmdns.close();
                this.registered = false;
            } else {
                System.err.println("WARNING: unregister() has been called, but registration previously failed.");
            }
        } else {
            System.err.println("WARNING: unregister() called but no service has been registered.");
        }
    }
}

