/*
 * Decompiled with CFR 0.152.
 */
package net.jradius.packet.attribute;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.StringTokenizer;
import net.jradius.exception.RadiusException;
import net.jradius.exception.UnknownAttributeException;
import net.jradius.log.RadiusLog;
import net.jradius.packet.RadiusFormat;
import net.jradius.packet.attribute.Attr_UnknownAttribute;
import net.jradius.packet.attribute.Attr_UnknownVSAttribute;
import net.jradius.packet.attribute.AttributeDescription;
import net.jradius.packet.attribute.AttributeDictionary;
import net.jradius.packet.attribute.AttributeList;
import net.jradius.packet.attribute.RadiusAttribute;
import net.jradius.packet.attribute.VSADictionary;

public final class AttributeFactory {
    private static LinkedHashMap attributeMap = new LinkedHashMap();
    private static LinkedHashMap vendorMap = new LinkedHashMap();
    private static LinkedHashMap attributeNameMap = new LinkedHashMap();

    public static boolean loadAttributeDictionary(String className) {
        try {
            Class<?> clazz = Class.forName(className);
            Object o = clazz.newInstance();
            return AttributeFactory.loadAttributeDictionary((AttributeDictionary)o);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean loadAttributeDictionary(AttributeDictionary dict) {
        dict.loadAttributes(attributeMap);
        dict.loadAttributesNames(attributeNameMap);
        dict.loadVendorCodes(vendorMap);
        for (Long id : vendorMap.keySet()) {
            Class c = (Class)vendorMap.get(id);
            try {
                LinkedHashMap map = new LinkedHashMap();
                VSADictionary vsadict = (VSADictionary)c.newInstance();
                vsadict.loadAttributes(map);
                vsadict.loadAttributesNames(attributeNameMap);
                vendorMap.put(id, new VendorValue(c, map));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return true;
    }

    public static RadiusAttribute attributeFromString(String src) throws RadiusException, UnknownAttributeException {
        String[] parts = src.split("=", 2);
        if (parts.length == 2) {
            String attribute = parts[0].trim();
            String value = parts[1].trim();
            char q = value.charAt(0);
            if (q == value.charAt(value.length() - 1) && (q == '\'' || q == '\"')) {
                value = value.substring(1, value.length() - 1);
            }
            return AttributeFactory.newAttribute(attribute, value, "=");
        }
        throw new RadiusException("Syntax error for attributes: " + src);
    }

    public static void loadAttributesFromString(AttributeList list, String src, String delim, boolean beStrinct) throws RadiusException {
        StringTokenizer st = new StringTokenizer(src, delim);
        while (st.hasMoreTokens()) {
            try {
                list.add(AttributeFactory.attributeFromString(st.nextToken()));
            }
            catch (RadiusException e) {
                if (!beStrinct) continue;
                throw e;
            }
        }
    }

    public static RadiusAttribute newAttribute(long vendor, long type, byte[] value, int op) {
        Class c = null;
        RadiusAttribute attr = null;
        try {
            if (vendor > 1L || type == 26L) {
                VendorValue v;
                if (vendor < 1L) {
                    ByteArrayInputStream bais = new ByteArrayInputStream(value);
                    DataInputStream input = new DataInputStream(bais);
                    vendor = (int)RadiusFormat.readUnsignedInt(input);
                    type = RadiusFormat.readUnsignedByte(input);
                    int vsaLength = RadiusFormat.readUnsignedByte(input);
                    byte[] newValue = new byte[vsaLength - 2];
                    input.readFully(newValue);
                    input.close();
                    value = newValue;
                }
                if ((v = (VendorValue)vendorMap.get(new Long(vendor))) != null) {
                    c = (Class)v.map.get(new Long(type));
                }
                if (c != null) {
                    attr = (RadiusAttribute)c.newInstance();
                } else {
                    RadiusLog.warn("Unknown Vendor Specific Attribute: " + vendor + ":" + type);
                    attr = new Attr_UnknownVSAttribute(vendor, type);
                }
            } else {
                c = (Class)attributeMap.get(new Long(type));
                if (c != null) {
                    attr = (RadiusAttribute)c.newInstance();
                } else {
                    RadiusLog.warn("Unknown Attribute: " + type);
                    attr = new Attr_UnknownAttribute(type);
                }
            }
            if (value != null) {
                attr.setValue(value);
            }
            if (op > -1) {
                attr.setAttributeOp(op);
            }
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return attr;
    }

    public static RadiusAttribute newAttribute(long type, byte[] value) {
        return AttributeFactory.newAttribute(type >> 16, type & 0xFFL, value, -1);
    }

    public static AttributeList newAttributeList(long type, byte[] value) {
        AttributeList list = new AttributeList();
        AttributeFactory.addToAttributeList(list, type, value);
        return list;
    }

    public static int addToAttributeList(AttributeList list, long type, byte[] value) {
        int left = value == null ? 0 : value.length;
        int offset = 0;
        int cnt = 0;
        long vendor = type >> 16;
        int maxlen = vendor > 0L ? 247 : 253;
        type &= 0xFFL;
        while (left > 0) {
            int len = maxlen;
            if (left < maxlen) {
                len = left;
            }
            byte[] b = new byte[len];
            System.arraycopy(value, offset, b, 0, len);
            list.add(AttributeFactory.newAttribute(vendor, type, b, 8), false);
            offset += len;
            left -= len;
            ++cnt;
        }
        return cnt;
    }

    public static RadiusAttribute newAttribute(String aName) throws UnknownAttributeException {
        Class c = (Class)attributeNameMap.get(aName);
        RadiusAttribute attr = null;
        if (c == null) {
            throw new UnknownAttributeException("Unknown attribute " + aName);
        }
        try {
            attr = (RadiusAttribute)c.newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return attr;
    }

    public static RadiusAttribute newAttribute(AttributeDescription desc) throws UnknownAttributeException {
        return AttributeFactory.newAttribute(desc.getName(), desc.getValue(), desc.getOp());
    }

    public static RadiusAttribute newAttribute(String aName, String aValue, String aOp) throws UnknownAttributeException {
        RadiusAttribute attr = AttributeFactory.newAttribute(aName);
        attr.setAttributeOp(aOp);
        attr.setValue(aValue);
        return attr;
    }

    public static long getTypeByName(String aName) throws UnknownAttributeException {
        Class c = (Class)attributeNameMap.get(aName);
        RadiusAttribute attr = null;
        if (c == null) {
            throw new UnknownAttributeException("Unknown attribute " + aName);
        }
        try {
            attr = (RadiusAttribute)c.newInstance();
            return attr.getType();
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1L;
        }
    }

    public static LinkedHashMap getAttributeMap() {
        return attributeMap;
    }

    public static LinkedHashMap getAttributeNameMap() {
        return attributeNameMap;
    }

    public static LinkedHashMap getVendorMap() {
        return vendorMap;
    }

    public static final class VendorValue {
        private Class c;
        private Map map;

        public VendorValue(Class c, Map m) {
            this.c = c;
            this.map = m;
        }

        public Map getAttributeMap() {
            return this.map;
        }

        public Class getDictClass() {
            return this.c;
        }
    }
}

