/*
 * Decompiled with CFR 0.152.
 */
package net.jradius.packet;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.jradius.packet.Format;
import net.jradius.packet.RadiusPacket;
import net.jradius.packet.attribute.RadiusAttribute;
import net.jradius.packet.attribute.VSAttribute;
import net.jradius.packet.attribute.value.AttributeValue;

public class RadiusFormat
extends Format {
    private static final int HEADER_LENGTH = 2;
    public static final int VSA_HEADER_LENGTH = 8;
    private static final RadiusFormat staticFormat = new RadiusFormat();

    public static RadiusFormat getInstance() {
        return staticFormat;
    }

    public static void setAttributeBytes(RadiusPacket packet, byte[] bAttributes) {
        if (bAttributes.length > 0) {
            staticFormat.unpackAttributes(packet.getAttributes(), bAttributes, 0, bAttributes.length);
        }
    }

    public byte[] packPacket(RadiusPacket packet, String sharedSecret) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] attributeBytes = null;
        if (packet != null) {
            attributeBytes = this.packAttributeList(packet.getAttributes());
        }
        try {
            this.packHeader(out, packet, attributeBytes, sharedSecret);
            if (attributeBytes != null) {
                out.write(attributeBytes);
            }
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return out.toByteArray();
    }

    public void packHeader(OutputStream out, RadiusPacket p, byte[] attributeBytes, String sharedSecret) throws IOException {
        int length = attributeBytes.length + 20;
        RadiusFormat.writeUnsignedByte(out, p.getCode());
        RadiusFormat.writeUnsignedByte(out, p.getIdentifier());
        RadiusFormat.writeUnsignedShort(out, length);
        out.write(p.getAuthenticator(attributeBytes, sharedSecret));
    }

    public void packAttribute(OutputStream out, RadiusAttribute a) throws IOException {
        AttributeValue attributeValue = a.getValue();
        this.packHeader(out, a);
        attributeValue.getBytes(out);
    }

    public void packHeader(OutputStream out, RadiusAttribute a) throws IOException {
        if (a instanceof VSAttribute) {
            this.packHeader(out, (VSAttribute)a);
            return;
        }
        AttributeValue attributeValue = a.getValue();
        RadiusFormat.writeUnsignedByte(out, (int)a.getType());
        RadiusFormat.writeUnsignedByte(out, attributeValue.getLength() + 2);
    }

    public void packHeader(OutputStream out, VSAttribute a) throws IOException {
        AttributeValue attributeValue = a.getValue();
        RadiusFormat.writeUnsignedByte(out, (int)a.getType());
        RadiusFormat.writeUnsignedByte(out, attributeValue.getLength() + 8);
        RadiusFormat.writeUnsignedInt(out, a.getVendorId());
        RadiusFormat.writeUnsignedByte(out, (int)a.getVsaAttributeType());
        RadiusFormat.writeUnsignedByte(out, attributeValue.getLength() + 2);
    }

    public int unpackAttributeHeader(InputStream in, Format.AttributeParseContext ctx) throws IOException {
        ctx.attributeType = RadiusFormat.readUnsignedByte(in);
        ctx.attributeLength = RadiusFormat.readUnsignedByte(in);
        ctx.headerLength = 2;
        return 0;
    }
}

