/*
 * Decompiled with CFR 0.152.
 */
package net.jradius.packet;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.jradius.packet.Format;
import net.jradius.packet.attribute.RadiusAttribute;
import net.jradius.packet.attribute.VSAttribute;
import net.jradius.packet.attribute.value.AttributeValue;

public class DHCPFormat
extends Format {
    public void packAttribute(OutputStream out, RadiusAttribute a) throws IOException {
        if (a instanceof VSAttribute) {
            this.packAttribute(out, (VSAttribute)a);
        }
    }

    public void packAttribute(OutputStream out, VSAttribute a) throws IOException {
        AttributeValue attributeValue = a.getValue();
        DHCPFormat.writeUnsignedByte(out, (int)a.getVsaAttributeType());
        DHCPFormat.writeUnsignedByte(out, attributeValue.getLength());
        attributeValue.getBytes(out);
    }

    public int unpackAttributeHeader(InputStream in, Format.AttributeParseContext ctx) throws IOException {
        ctx.attributeType = DHCPFormat.readUnsignedByte(in);
        ctx.attributeLength = DHCPFormat.readUnsignedByte(in);
        ctx.headerLength = 2;
        return 0;
    }
}

