/*
 * Decompiled with CFR 0.152.
 */
package net.jradius.impl;

import net.jradius.JRadiusManager;
import net.jradius.server.EventDispatcher;
import net.jradius.server.JRadiusServer;
import net.jradius.server.config.Configuration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public class JRadiusManagerImpl
implements InitializingBean,
BeanFactoryAware,
DisposableBean,
JRadiusManager {
    protected final Log log = LogFactory.getLog(this.getClass());
    private EventDispatcher eventDispatcher;
    private BeanFactory beanFactory;
    private JRadiusServer jRadiusServer;
    private String configFile;

    public void start() {
        this.jRadiusServer.start();
    }

    public void stop() {
        this.jRadiusServer.stop();
    }

    public void afterPropertiesSet() throws Exception {
        Configuration.initialize(Thread.currentThread().getContextClassLoader().getResourceAsStream(this.getConfigFile()), this.beanFactory);
        if (this.jRadiusServer == null) {
            this.jRadiusServer = new JRadiusServer(this.eventDispatcher);
            this.jRadiusServer.afterPropertiesSet();
        }
        this.jRadiusServer.start();
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    public String getConfigFile() {
        return this.configFile;
    }

    public void setConfigFile(String configFile) {
        this.configFile = configFile;
    }

    public void destroy() throws Exception {
        this.stop();
    }

    public void setJRadiusServer(JRadiusServer radiusServer) {
        this.jRadiusServer = radiusServer;
    }

    public void setEventDispatcher(EventDispatcher eventDispatcher) {
        this.eventDispatcher = eventDispatcher;
    }
}

