/*
 * Decompiled with CFR 0.152.
 */
package net.jradius.freeradius;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import net.jradius.exception.RadiusException;
import net.jradius.freeradius.FreeRadiusFormat;
import net.jradius.freeradius.FreeRadiusRequest;
import net.jradius.packet.PacketFactory;
import net.jradius.packet.RadiusFormat;
import net.jradius.packet.RadiusPacket;
import net.jradius.packet.attribute.AttributeList;
import net.jradius.server.JRadiusEvent;
import net.jradius.server.TCPListener;

public class FreeRadiusListener
extends TCPListener {
    private static final FreeRadiusFormat format = new FreeRadiusFormat();

    public JRadiusEvent parseRequest(InputStream inputStream) throws IOException, RadiusException {
        FreeRadiusRequest request = new FreeRadiusRequest();
        DataInputStream in = new DataInputStream(inputStream);
        long nameLength = RadiusFormat.readUnsignedInt(in);
        if (nameLength < 0L || nameLength > 1024L) {
            throw new RadiusException("KeepAlive rlm_jradius connection has been closed");
        }
        byte[] nameBytes = new byte[(int)nameLength];
        in.readFully(nameBytes);
        int messageType = RadiusFormat.readUnsignedByte(in);
        int packetCount = RadiusFormat.readUnsignedByte(in);
        RadiusPacket[] rp = PacketFactory.parse(in, packetCount);
        long length = RadiusFormat.readUnsignedInt(in);
        byte[] bConfig = new byte[(int)length];
        in.readFully(bConfig);
        AttributeList configItems = new AttributeList();
        format.unpackAttributes(configItems, bConfig, 0, (int)length);
        request.setConfigItems(configItems);
        request.setSender(new String(nameBytes));
        request.setType(messageType);
        request.setPackets(rp);
        return request;
    }
}

