/*
 * Decompiled with CFR 0.152.
 */
package net.jradius.client.auth;

import net.jradius.client.RadiusClient;
import net.jradius.exception.RadiusException;
import net.jradius.packet.RadiusPacket;
import net.jradius.packet.attribute.RadiusAttribute;

public abstract class RadiusAuthenticator {
    protected RadiusClient client;
    protected RadiusAttribute username;
    protected RadiusAttribute password;

    public abstract String getAuthName();

    public void setupRequest(RadiusClient c, RadiusPacket p) throws RadiusException {
        this.client = c;
        this.username = p.findAttribute(1L);
        if (this.username == null) {
            throw new RadiusException("You must at least have a User-Name attribute in a Access-Request");
        }
        this.password = p.findAttribute(2L);
    }

    public abstract void processRequest(RadiusPacket var1) throws RadiusException;

    public void processChallenge(RadiusPacket request, RadiusPacket challenge) throws RadiusException {
        throw new RadiusException("A RequestChallenge was returned for a " + this.getAuthName() + " authentication!\n" + request.toString() + "\n" + challenge.toString());
    }

    public RadiusClient getClient() {
        return this.client;
    }

    public void setClient(RadiusClient client) {
        this.client = client;
    }

    protected byte[] getUsername() {
        return this.username.getValue().getBytes();
    }

    protected byte[] getPassword() {
        if (this.password != null) {
            return this.password.getValue().getBytes();
        }
        return null;
    }
}

