/*
 * Decompiled with CFR 0.152.
 */
package net.jradius.client.auth;

import net.jradius.client.auth.EAPAuthenticator;
import net.jradius.util.MSCHAP;

public class EAPMSCHAPv2Authenticator
extends EAPAuthenticator {
    public static final String NAME = "eap-mschapv2";
    private static final byte EAP_MSCHAPV2_ACK = 0;
    private static final byte EAP_MSCHAPV2_CHALLENGE = 1;
    private static final byte EAP_MSCHAPV2_RESPONSE = 2;
    private static final byte EAP_MSCHAPV2_SUCCESS = 3;
    private static final byte EAP_MSCHAPV2_FAILURE = 4;

    public EAPMSCHAPv2Authenticator() {
        this.setEAPType(26);
    }

    public EAPMSCHAPv2Authenticator(boolean peap) {
        this.setEAPType(26);
        this.peap = peap;
    }

    public String getAuthName() {
        return NAME;
    }

    public byte[] doEAPType(byte id, byte[] data) {
        byte opCode = data[0];
        switch (opCode) {
            case 1: {
                byte[] challenge = new byte[16];
                System.arraycopy(data, 5, challenge, 0, 16);
                int length = 59;
                byte[] response = new byte[54];
                response[0] = 2;
                response[1] = (byte)(data[1] + 1);
                response[2] = (byte)(length << 8 & 0xFF);
                response[3] = (byte)(length & 0xFF);
                response[4] = 49;
                System.arraycopy(MSCHAP.doMSCHAPv2(this.getUsername(), this.getPassword(), challenge), 2, response, 5, 48);
                return response;
            }
            case 3: {
                byte[] response = new byte[]{3, data[1], 0, 0};
                return response;
            }
        }
        return null;
    }
}

