/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.reporting.availability.svclayer;

import java.beans.PropertyVetoException;
import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.config.CatFactory;
import org.opennms.netmgt.config.CategoryFactory;
import org.opennms.netmgt.config.DataSourceFactory;
import org.opennms.netmgt.config.categories.Category;
import org.opennms.netmgt.filter.FilterDaoFactory;
import org.opennms.reporting.availability.svclayer.AvailabilityDataService;
import org.opennms.reporting.availability.svclayer.AvailabilityDataServiceException;
import org.opennms.reporting.datablock.Node;
import org.opennms.reporting.datablock.Outage;
import org.opennms.reporting.datablock.OutageSvcTimesList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LegacyAvailabilityDataService
implements AvailabilityDataService {
    CatFactory m_catFactory;
    private String m_commonRule;
    private Connection m_availConn;
    private ThreadCategory log;
    private List<Node> m_nodes;
    private static final String LOG4J_CATEGORY = "OpenNMS.Report";

    public LegacyAvailabilityDataService() {
        ThreadCategory.setPrefix((String)LOG4J_CATEGORY);
        this.log = ThreadCategory.getInstance(LegacyAvailabilityDataService.class);
        this.log.debug("initialised DefaultAvailablityReportService");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<Node> getNodes(Category category, long startTime, long endTime) throws AvailabilityDataServiceException {
        this.m_nodes = new ArrayList<Node>();
        PreparedStatement ipInfoGetStmt = null;
        PreparedStatement servicesGetStmt = null;
        PreparedStatement outagesGetStmt = null;
        String categoryName = category.getLabel();
        try {
            CategoryFactory.init();
            this.m_catFactory = CategoryFactory.getInstance();
        }
        catch (IOException e) {
            this.log.fatal("Initializing CategoryFactory", (Throwable)e);
            throw new AvailabilityDataServiceException("faild to init catFactory");
        }
        catch (MarshalException e) {
            this.log.fatal("Initializing CategoryFactory", (Throwable)e);
            throw new AvailabilityDataServiceException("faild to init catFactory");
        }
        catch (ValidationException e) {
            this.log.fatal("Initializing CategoryFactory", (Throwable)e);
            throw new AvailabilityDataServiceException("faild to init catFactory");
        }
        this.m_commonRule = this.m_catFactory.getEffectiveRule(categoryName);
        List nodeIPs = FilterDaoFactory.getInstance().getIPList(this.m_commonRule);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Number of IPs satisfying rule: " + nodeIPs.size());
        }
        ArrayList monitoredServices = new ArrayList(category.getServiceCollection());
        this.log.debug("categories in monitoredServices = " + ((Object)monitoredServices).toString());
        this.initialiseConnection();
        try {
            ipInfoGetStmt = this.m_availConn.prepareStatement("SELECT  node.nodeid, node.nodelabel FROM node, ipInterface WHERE ((ipInterface.ipaddr = ?) AND (ipInterface.nodeid = node.nodeid) AND (node.nodeType = 'A') AND (ipinterface.ismanaged = 'M') )");
            servicesGetStmt = this.m_availConn.prepareStatement("SELECT ifServices.serviceid, service.servicename FROM ifServices, ipInterface, node, service WHERE ((ifServices.nodeid = ? ) AND (ifServices.ipaddr = ?) AND ipinterface.ipaddr = ? AND ipinterface.isManaged ='M' AND (ifServices.serviceid = service.serviceid) AND (ifservices.status = 'A')) AND node.nodeid = ? AND node.nodetype = 'A'");
            outagesGetStmt = this.m_availConn.prepareStatement("SELECT ifLostService, ifRegainedService from outages where  (outages.nodeid = ?) AND (outages.ipaddr = ?) AND (outages.serviceid = ?)");
        }
        catch (SQLException e) {
            this.log.fatal("failed to setup prepared statement", (Throwable)e);
            throw new AvailabilityDataServiceException("failed to setup prepared statement");
        }
        Iterator ipIter = nodeIPs.iterator();
        String ip = null;
        ResultSet ipRS = null;
        try {
            try {
                ipInfoGetStmt = this.m_availConn.prepareStatement("SELECT  node.nodeid, node.nodelabel FROM node, ipInterface WHERE ((ipInterface.ipaddr = ?) AND (ipInterface.nodeid = node.nodeid) AND (node.nodeType = 'A') AND (ipinterface.ismanaged = 'M') )");
                while (ipIter.hasNext()) {
                    ip = (String)ipIter.next();
                    this.log.debug("ecexuting SELECT  node.nodeid, node.nodelabel FROM node, ipInterface WHERE ((ipInterface.ipaddr = ?) AND (ipInterface.nodeid = node.nodeid) AND (node.nodeType = 'A') AND (ipinterface.ismanaged = 'M') ) for " + ip);
                    ipInfoGetStmt.setString(1, ip);
                    ipRS = ipInfoGetStmt.executeQuery();
                    while (ipRS.next()) {
                        int nodeid = ipRS.getInt(1);
                        String nodeName = ipRS.getString(2);
                        ResultSet svcRS = null;
                        servicesGetStmt.setLong(1, nodeid);
                        servicesGetStmt.setString(2, ip);
                        servicesGetStmt.setString(3, ip);
                        servicesGetStmt.setLong(4, nodeid);
                        svcRS = servicesGetStmt.executeQuery();
                        while (svcRS.next()) {
                            int svcid = svcRS.getInt(1);
                            String svcname = svcRS.getString(2);
                            if (!monitoredServices.isEmpty() && !monitoredServices.contains(svcname)) continue;
                            OutageSvcTimesList outageSvcTimesList = new OutageSvcTimesList();
                            this.getOutagesNodeIpSvc(nodeid, nodeName, ip, svcid, svcname, outageSvcTimesList, outagesGetStmt, startTime, endTime);
                        }
                    }
                }
                Object var22_24 = null;
            }
            catch (SQLException e) {
                this.log.fatal("failed to execute prepared statement", (Throwable)e);
                throw new AvailabilityDataServiceException("failed to execute prepared statement");
            }
        }
        catch (Throwable throwable) {
            Object var22_25 = null;
            try {
                if (ipRS != null) {
                    ipRS.close();
                }
                if (servicesGetStmt != null) {
                    servicesGetStmt.close();
                }
                if (ipInfoGetStmt != null) {
                    ipInfoGetStmt.close();
                }
                if (outagesGetStmt != null) {
                    outagesGetStmt.close();
                }
                if (this.m_availConn == null) throw throwable;
                this.closeConnection();
                throw throwable;
            }
            catch (SQLException e) {
                this.log.fatal("failed to close ipInfo prepared statement", (Throwable)e);
                throw new AvailabilityDataServiceException("failed to close ipInfo prepared statement");
            }
        }
        try {}
        catch (SQLException e) {
            this.log.fatal("failed to close ipInfo prepared statement", (Throwable)e);
            throw new AvailabilityDataServiceException("failed to close ipInfo prepared statement");
        }
        if (ipRS != null) {
            ipRS.close();
        }
        if (servicesGetStmt != null) {
            servicesGetStmt.close();
        }
        if (ipInfoGetStmt != null) {
            ipInfoGetStmt.close();
        }
        if (outagesGetStmt != null) {
            outagesGetStmt.close();
        }
        if (this.m_availConn == null) return this.m_nodes;
        this.closeConnection();
        return this.m_nodes;
    }

    private void getOutagesNodeIpSvc(int nodeid, String nodeName, String ipaddr, int serviceid, String serviceName, OutageSvcTimesList outageSvcTimesList, PreparedStatement outagesGetStmt, long startTime, long endTime) throws SQLException {
        try {
            outagesGetStmt.setInt(1, nodeid);
            outagesGetStmt.setString(2, ipaddr);
            outagesGetStmt.setInt(3, serviceid);
            ResultSet rs = outagesGetStmt.executeQuery();
            if (this.m_nodes != null && this.m_nodes.size() > 0) {
                ListIterator<Node> lstIter = this.m_nodes.listIterator();
                boolean foundFlag = false;
                Node oldNode = null;
                while (lstIter.hasNext()) {
                    oldNode = lstIter.next();
                    if (oldNode == null || oldNode.getNodeID() != nodeid) continue;
                    foundFlag = true;
                    break;
                }
                if (!foundFlag) {
                    Node newNode = new Node(nodeName, nodeid);
                    newNode.addInterface(ipaddr, serviceName);
                    this.m_nodes.add(newNode);
                } else {
                    oldNode.addInterface(ipaddr, serviceName);
                }
            } else {
                Node newNode = new Node(nodeName, nodeid);
                newNode.addInterface(ipaddr, serviceName);
                if (this.m_nodes == null) {
                    this.log.debug("NODES IS NULL");
                }
                this.m_nodes.add(newNode);
            }
            while (rs.next()) {
                Timestamp lost = rs.getTimestamp(1);
                Timestamp regained = rs.getTimestamp(2);
                long losttime = lost.getTime();
                long regainedtime = 0L;
                if (regained != null) {
                    regainedtime = regained.getTime();
                }
                if (regainedtime > 0L ? regainedtime <= startTime || losttime >= endTime : losttime >= endTime) continue;
                Outage outage = new Outage(losttime, regainedtime);
                outageSvcTimesList.add(outage);
                this.addNode(nodeName, nodeid, ipaddr, serviceName, losttime, regainedtime);
            }
            if (rs != null) {
                rs.close();
            }
        }
        catch (SQLException e) {
            this.log.fatal("SQL Error occured while getting the outages ", (Throwable)e);
            throw e;
        }
    }

    public void addNode(String nodeName, int nodeid, String ipaddr, String serviceid, long losttime, long regainedtime) {
        if (this.m_nodes != null) {
            if (this.m_nodes.size() <= 0) {
                Node newNode = new Node(nodeName, nodeid);
                if (losttime > 0L) {
                    if (regainedtime > 0L) {
                        newNode.addInterface(ipaddr, serviceid, losttime, regainedtime);
                    } else {
                        newNode.addInterface(ipaddr, serviceid, losttime);
                    }
                } else {
                    newNode.addInterface(ipaddr, serviceid);
                }
                this.m_nodes.add(newNode);
                return;
            }
            Node newNode = null;
            boolean foundFlag = false;
            ListIterator<Node> lstIter = this.m_nodes.listIterator();
            while (lstIter.hasNext()) {
                newNode = lstIter.next();
                if (newNode.getNodeID() != nodeid) continue;
                foundFlag = true;
                break;
            }
            if (!foundFlag) {
                newNode = new Node(nodeName, nodeid);
                if (losttime > 0L) {
                    if (regainedtime > 0L) {
                        newNode.addInterface(ipaddr, serviceid, losttime, regainedtime);
                    } else {
                        newNode.addInterface(ipaddr, serviceid, losttime);
                    }
                } else {
                    newNode.addInterface(ipaddr, serviceid);
                }
                this.m_nodes.add(newNode);
                return;
            }
            if (losttime > 0L) {
                if (regainedtime > 0L) {
                    newNode.addInterface(ipaddr, serviceid, losttime, regainedtime);
                } else {
                    newNode.addInterface(ipaddr, serviceid, losttime);
                }
            } else {
                newNode.addInterface(ipaddr, serviceid);
            }
            return;
        }
        this.log.debug("adding new arraylis");
        this.m_nodes = new ArrayList<Node>();
    }

    private void initialiseConnection() throws AvailabilityDataServiceException {
        try {
            DataSourceFactory.init();
            this.m_availConn = DataSourceFactory.getInstance().getConnection();
        }
        catch (MarshalException e) {
            this.log.fatal("initialize: Failed to load data collection configuration", (Throwable)e);
            throw new AvailabilityDataServiceException("failed to load data collection configuration");
        }
        catch (ValidationException e) {
            this.log.fatal("initialize: Failed to load data collection configuration", (Throwable)e);
            throw new AvailabilityDataServiceException("failed to load data collection configuration");
        }
        catch (IOException e) {
            this.log.fatal("initialize: Failed to load data collection configuration", (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
        catch (ClassNotFoundException e) {
            this.log.fatal("initialize: Failed loading database driver.", (Throwable)e);
            throw new AvailabilityDataServiceException("failed to load data collection configuration");
        }
        catch (SQLException e) {
            this.log.fatal("initialize: Failed getting connection to the database.", (Throwable)e);
            throw new AvailabilityDataServiceException("failed to load data collection configuration");
        }
        catch (PropertyVetoException e) {
            this.log.fatal("initialize: Failed getting connection to the database.", (Throwable)e);
            throw new AvailabilityDataServiceException("initialize: Failed getting connection to the database");
        }
    }

    private void closeConnection() {
        ThreadCategory log = ThreadCategory.getInstance(this.getClass());
        if (this.m_availConn != null) {
            try {
                this.m_availConn.close();
                this.m_availConn = null;
            }
            catch (Throwable t) {
                log.warn("initialize: an exception occured while closing the JDBC connection", t);
            }
        }
    }
}

