/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.reporting.availability.svclayer;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import org.opennms.api.reporting.ReportFormat;
import org.opennms.api.reporting.ReportService;
import org.opennms.api.reporting.parameter.ReportParameters;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.dao.OnmsReportConfigDao;
import org.opennms.reporting.availability.AvailabilityCalculationException;
import org.opennms.reporting.availability.AvailabilityCalculator;
import org.opennms.reporting.availability.render.HTMLReportRenderer;
import org.opennms.reporting.availability.render.PDFReportRenderer;
import org.opennms.reporting.availability.render.ReportRenderException;
import org.opennms.reporting.availability.render.ReportRenderer;
import org.opennms.reporting.core.svclayer.ParameterConversionService;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AvailabilityReportService
implements ReportService {
    private AvailabilityCalculator m_classicCalculator;
    private AvailabilityCalculator m_calendarCalculator;
    private OnmsReportConfigDao m_configDao;
    private ThreadCategory log;
    private ParameterConversionService m_parameterConversionService;
    private static final String LOG4J_CATEGORY = "OpenNMS.Report";
    private static final String CAL_TYPE = "calendar";

    public AvailabilityReportService() {
        ThreadCategory.setPrefix((String)LOG4J_CATEGORY);
        this.log = ThreadCategory.getInstance(AvailabilityReportService.class);
    }

    public boolean validate(HashMap<String, Object> reportParms, String reportID) {
        if (!reportParms.containsKey("endDate")) {
            this.log.fatal("report parameters should contain parameter endDate");
            return false;
        }
        if (!(reportParms.get("endDate") instanceof Date)) {
            this.log.fatal("report parameters 'endDate' should be a Date");
            return false;
        }
        if (!reportParms.containsKey("reportCategory")) {
            this.log.fatal("report parameters should contain parameter reportCategory");
            return false;
        }
        if (!(reportParms.get("reportCategory") instanceof String)) {
            this.log.fatal("report parameter 'reportCategory' should be a String");
            return false;
        }
        return true;
    }

    public void render(String id, String location, ReportFormat format, OutputStream outputStream) {
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(location);
            this.render(id, inputStream, format, outputStream);
        }
        catch (FileNotFoundException e) {
            this.log.error("could not open input file", (Throwable)e);
        }
    }

    private void render(String id, InputStream inputStream, ReportFormat format, OutputStream outputStream) {
        try {
            UrlResource xsltResource;
            ReportRenderer renderer;
            switch (format) {
                case HTML: {
                    this.log.debug("rendering as HTML");
                    renderer = new HTMLReportRenderer();
                    xsltResource = new UrlResource(this.m_configDao.getHtmlStylesheetLocation(id));
                    break;
                }
                case PDF: {
                    this.log.debug("rendering as PDF");
                    renderer = new PDFReportRenderer();
                    xsltResource = new UrlResource(this.m_configDao.getPdfStylesheetLocation(id));
                    break;
                }
                case SVG: {
                    this.log.debug("rendering as PDF with embedded SVG");
                    renderer = new PDFReportRenderer();
                    xsltResource = new UrlResource(this.m_configDao.getSvgStylesheetLocation(id));
                    break;
                }
                default: {
                    this.log.debug("rendering as HTML as no valid format found");
                    renderer = new HTMLReportRenderer();
                    xsltResource = new UrlResource(this.m_configDao.getHtmlStylesheetLocation(id));
                }
            }
            String baseDir = System.getProperty("opennms.report.dir");
            renderer.setBaseDir(baseDir);
            renderer.render(inputStream, outputStream, (Resource)xsltResource);
            outputStream.flush();
        }
        catch (MalformedURLException e) {
            this.log.fatal("Malformed URL for xslt template");
        }
        catch (ReportRenderException e) {
            this.log.fatal("unable to render report");
        }
        catch (IOException e) {
            this.log.fatal("IO exception flushing output stream ", (Throwable)e);
        }
    }

    public List<ReportFormat> getFormats(String id) {
        ArrayList<ReportFormat> formats = new ArrayList<ReportFormat>();
        if (this.m_configDao.getHtmlStylesheetLocation(id) != null) {
            formats.add(ReportFormat.HTML);
        }
        if (this.m_configDao.getPdfStylesheetLocation(id) != null) {
            formats.add(ReportFormat.PDF);
        }
        if (this.m_configDao.getSvgStylesheetLocation(id) != null) {
            formats.add(ReportFormat.SVG);
        }
        return formats;
    }

    public String run(HashMap<String, Object> reportParms, String reportId) {
        AvailabilityCalculator calculator;
        String reportFileName = null;
        this.log.debug("running OpenNMS database report " + reportId);
        if (this.m_configDao.getType(reportId).equalsIgnoreCase(CAL_TYPE)) {
            calculator = this.m_calendarCalculator;
            this.log.debug("Calendar report format selected");
        } else {
            calculator = this.m_classicCalculator;
            this.log.debug("Classic report format selected");
        }
        calculator.setCategoryName((String)reportParms.get("reportCategory"));
        this.log.debug("set availability calculator report category to: " + calculator.getCategoryName());
        calculator.setCalendar(new GregorianCalendar());
        calculator.setPeriodEndDate((Date)reportParms.get("endDate"));
        this.log.debug("set availability calculator end date to: " + calculator.getPeriodEndDate().toString());
        calculator.setLogoURL(this.m_configDao.getLogo(reportId));
        calculator.setReportFormat("all");
        this.log.debug("Starting Availability Report Calculations");
        try {
            calculator.calculate();
            reportFileName = calculator.writeXML();
        }
        catch (AvailabilityCalculationException ce) {
            this.log.fatal("Unable to calculate report data ", (Throwable)ce);
        }
        return reportFileName;
    }

    public void runAndRender(HashMap<String, Object> reportParms, String reportId, ReportFormat format, OutputStream outputStream) {
        AvailabilityCalculator calculator;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        BufferedOutputStream bout = new BufferedOutputStream(out);
        this.log.debug("running OpenNMS database report " + reportId);
        if (this.m_configDao.getType(reportId).equalsIgnoreCase(CAL_TYPE)) {
            calculator = this.m_calendarCalculator;
            this.log.debug("Calendar report format selected");
        } else {
            calculator = this.m_classicCalculator;
            this.log.debug("Classic report format selected");
        }
        calculator.setCategoryName((String)reportParms.get("reportCategory"));
        this.log.debug("set availability calculator report category to: " + calculator.getCategoryName());
        calculator.setCalendar(new GregorianCalendar());
        calculator.setPeriodEndDate((Date)reportParms.get("endDate"));
        this.log.debug("set availability calculator end date to: " + calculator.getPeriodEndDate().toString());
        calculator.setLogoURL(this.m_configDao.getLogo(reportId));
        calculator.setReportFormat("all");
        this.log.debug("Starting Availability Report Calculations");
        try {
            calculator.calculate();
            calculator.writeXML(bout);
            this.render(reportId, new ByteArrayInputStream(out.toByteArray()), format, outputStream);
            outputStream.flush();
        }
        catch (AvailabilityCalculationException ce) {
            this.log.fatal("Unable to calculate report data ", (Throwable)ce);
        }
        catch (IOException e) {
            this.log.fatal("IO exception flushing output stream ", (Throwable)e);
        }
    }

    public ReportParameters getParameters(String ReportId) {
        return this.m_parameterConversionService.convert(this.m_configDao.getParameters(ReportId));
    }

    public void setCalendarCalculator(AvailabilityCalculator calculator) {
        this.m_calendarCalculator = calculator;
    }

    public void setClassicCalculator(AvailabilityCalculator calulator) {
        this.m_classicCalculator = calulator;
    }

    public void setConfigDao(OnmsReportConfigDao configDao) {
        this.m_configDao = configDao;
    }

    public void setParameterConversionService(ParameterConversionService parameterConversionService) {
        this.m_parameterConversionService = parameterConversionService;
    }
}

