/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.reporting.availability.render;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.reporting.availability.render.ReportRenderException;
import org.opennms.reporting.availability.render.ReportRenderer;
import org.springframework.core.io.Resource;

public class HTMLReportRenderer
implements ReportRenderer {
    private static final String LOG4J_CATEGORY = "OpenNMS.Report";
    private String m_outputFileName;
    private String m_inputFileName;
    private Resource m_xsltResource;
    private String m_baseDir;
    private ThreadCategory log;

    public HTMLReportRenderer() {
        ThreadCategory.setPrefix((String)LOG4J_CATEGORY);
        this.log = ThreadCategory.getInstance(HTMLReportRenderer.class);
    }

    public void render() throws ReportRenderException {
        this.render(this.m_inputFileName, this.m_outputFileName, this.m_xsltResource);
    }

    public byte[] render(String inputFileName, Resource xsltResource) throws ReportRenderException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Rendering " + inputFileName + " with XSL File " + xsltResource.getDescription() + " to byte array");
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        this.render(inputFileName, (OutputStream)outputStream, xsltResource);
        return outputStream.toByteArray();
    }

    /*
     * Loose catch block
     */
    public void render(String inputFileName, OutputStream outputStream, Resource xsltResource) throws ReportRenderException {
        block15: {
            IOException e22;
            FileInputStream xslt;
            FileInputStream in;
            block14: {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Rendering " + inputFileName + " with XSL File " + xsltResource.getDescription() + " to OutputStream");
                }
                in = null;
                xslt = null;
                in = new FileInputStream(xsltResource.getFile());
                InputStreamReader xsl = new InputStreamReader((InputStream)in, "UTF-8");
                xslt = new FileInputStream(inputFileName);
                InputStreamReader xml = new InputStreamReader((InputStream)xslt, "UTF-8");
                this.render(xml, outputStream, xsl);
                Object var9_9 = null;
                if (in == null) break block14;
                try {
                    in.close();
                }
                catch (IOException e22) {
                    this.log.warn("Error while closing XML stream: " + e22.getMessage());
                }
            }
            if (xslt != null) {
                try {
                    xslt.close();
                }
                catch (IOException e22) {
                    this.log.warn("Error while closing XSLT stream: " + e22.getMessage());
                }
            }
            break block15;
            {
                catch (IOException ioe) {
                    this.log.fatal("IOException ", (Throwable)ioe);
                    throw new ReportRenderException(ioe);
                }
            }
            catch (Throwable throwable) {
                IOException e22;
                Object var9_10 = null;
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e22) {
                        this.log.warn("Error while closing XML stream: " + e22.getMessage());
                    }
                }
                if (xslt != null) {
                    try {
                        xslt.close();
                    }
                    catch (IOException e22) {
                        this.log.warn("Error while closing XSLT stream: " + e22.getMessage());
                    }
                }
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void render(InputStream inputStream, OutputStream outputStream, Resource xsltResource) throws ReportRenderException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Rendering InputStream with XSL File " + xsltResource.getDescription() + " to OutputStream");
        }
        FileInputStream xslt = null;
        xslt = new FileInputStream(xsltResource.getFile());
        InputStreamReader xsl = new InputStreamReader((InputStream)xslt, "UTF-8");
        InputStreamReader xml = new InputStreamReader(inputStream, "UTF-8");
        this.render(xml, outputStream, xsl);
        Object var8_8 = null;
        if (xslt == null) return;
        try {
            xslt.close();
            return;
        }
        catch (IOException e) {
            this.log.warn("Error while closing XSLT stream: " + e.getMessage());
        }
        return;
        {
            catch (IOException ioe) {
                this.log.fatal("IOException ", (Throwable)ioe);
                throw new ReportRenderException(ioe);
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            if (xslt == null) throw throwable;
            try {
                xslt.close();
                throw throwable;
            }
            catch (IOException e) {
                this.log.warn("Error while closing XSLT stream: " + e.getMessage());
            }
            throw throwable;
        }
    }

    /*
     * Loose catch block
     */
    public void render(String inputFileName, String outputFileName, Resource xsltResource) throws ReportRenderException {
        block21: {
            IOException e2222;
            FileOutputStream out;
            FileInputStream xslt;
            FileInputStream in;
            block19: {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Rendering " + inputFileName + " with XSL File " + xsltResource.getDescription() + " to " + outputFileName + " with base directory of " + this.m_baseDir);
                }
                in = null;
                xslt = null;
                out = null;
                xslt = new FileInputStream(xsltResource.getFile());
                InputStreamReader xsl = new InputStreamReader((InputStream)xslt, "UTF-8");
                in = new FileInputStream(this.m_baseDir + "/" + inputFileName);
                InputStreamReader xml = new InputStreamReader((InputStream)in, "UTF-8");
                out = new FileOutputStream(new File(this.m_baseDir + "/" + outputFileName));
                this.render(xml, (OutputStream)out, xsl);
                Object var10_10 = null;
                if (in == null) break block19;
                try {
                    in.close();
                }
                catch (IOException e2222) {
                    this.log.warn("Error while closing XML stream: " + e2222.getMessage());
                }
            }
            if (xslt != null) {
                try {
                    xslt.close();
                }
                catch (IOException e2222) {
                    this.log.warn("Error while closing XSLT stream: " + e2222.getMessage());
                }
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e2222) {
                    this.log.warn("Error while closing PDF stream: " + e2222.getMessage());
                }
            }
            break block21;
            {
                catch (IOException ioe) {
                    this.log.fatal("IOException ", (Throwable)ioe);
                    throw new ReportRenderException(ioe);
                }
            }
            catch (Throwable throwable) {
                IOException e2222;
                Object var10_11 = null;
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e2222) {
                        this.log.warn("Error while closing XML stream: " + e2222.getMessage());
                    }
                }
                if (xslt != null) {
                    try {
                        xslt.close();
                    }
                    catch (IOException e2222) {
                        this.log.warn("Error while closing XSLT stream: " + e2222.getMessage());
                    }
                }
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException e2222) {
                        this.log.warn("Error while closing PDF stream: " + e2222.getMessage());
                    }
                }
                throw throwable;
            }
        }
    }

    public void render(Reader in, OutputStream out, Reader xslt) throws ReportRenderException {
        try {
            TransformerFactory tfact = TransformerFactory.newInstance();
            Transformer transformer = tfact.newTransformer(new StreamSource(xslt));
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.transform(new StreamSource(in), new StreamResult(out));
        }
        catch (TransformerConfigurationException tce) {
            this.log.fatal("TransformerConfigurationException", (Throwable)tce);
            throw new ReportRenderException(tce);
        }
        catch (TransformerException te) {
            this.log.fatal("TransformerException", (Throwable)te);
            throw new ReportRenderException(te);
        }
    }

    public void setXsltResource(Resource xsltResource) {
        this.m_xsltResource = xsltResource;
    }

    public void setOutputFileName(String outputFileName) {
        this.m_outputFileName = outputFileName;
    }

    public String getOutputFileName() {
        return this.m_outputFileName;
    }

    public void setInputFileName(String inputFileName) {
        this.m_inputFileName = inputFileName;
    }

    public void setBaseDir(String baseDir) {
        this.m_baseDir = baseDir;
    }

    public String getBaseDir() {
        return this.m_baseDir;
    }
}

