/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.reporting.availability;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.Priority;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.ConfigFileConstants;
import org.opennms.reporting.availability.AvailabilityData;
import org.opennms.reporting.availability.Categories;
import org.opennms.reporting.availability.Created;
import org.opennms.reporting.availability.Report;
import org.opennms.reporting.availability.ViewInfo;
import org.opennms.reporting.availability.render.HTMLReportRenderer;
import org.opennms.reporting.availability.render.PDFReportRenderer;
import org.springframework.util.StringUtils;

public class AvailabilityReport {
    private static final String LOG4J_CATEGORY = "OpenNMS.Report";
    private static final String MONTH_FORMAT_CLASSIC = "classic";
    private Report m_report = null;
    public static String[] months = new String[]{"January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"};

    public AvailabilityReport(String author, String startMonth, String startDate, String startYear) {
        ThreadCategory.setPrefix((String)LOG4J_CATEGORY);
        if (AvailabilityReport.log().isDebugEnabled()) {
            AvailabilityReport.log().debug("Inside AvailabilityReport");
        }
        GregorianCalendar today = new GregorianCalendar();
        int day = Integer.parseInt(startDate);
        int year = Integer.parseInt(startYear);
        String month = months[Integer.parseInt(startMonth)];
        int hour = today.get(10);
        int minute = today.get(12);
        int second = today.get(13);
        Created created = new Created();
        created.setDay(day);
        created.setHour(hour);
        created.setMin(minute);
        created.setMonth(month);
        created.setSec(second);
        created.setYear(year);
        created.setContent(new BigDecimal(today.getTime().getTime()));
        this.m_report = new Report();
        this.m_report.setCreated(created);
        this.m_report.setAuthor(author);
        if (AvailabilityReport.log().isDebugEnabled()) {
            AvailabilityReport.log().debug("Leaving AvailabilityReport");
        }
    }

    public void getReportData(String logourl, String categoryName, String reportFormat, String monthFormat, String startMonth, String startDate, String startYear) {
        if (AvailabilityReport.log().isDebugEnabled()) {
            AvailabilityReport.log().debug("inside getReportData");
            AvailabilityReport.log().debug("Category name  " + categoryName);
            AvailabilityReport.log().debug("Report format   " + reportFormat);
            AvailabilityReport.log().debug("logo  " + logourl);
            AvailabilityReport.log().debug("monthFormat " + monthFormat);
        }
        this.populateReport(logourl, categoryName, reportFormat, monthFormat, startMonth, startDate, startYear);
        try {
            this.marshalReport();
        }
        catch (Exception e) {
            AvailabilityReport.log().fatal("Exception: " + e, (Throwable)e);
        }
    }

    public void populateReport(String logourl, String categoryName, String reportFormat, String monthFormat, String startMonth, String startDate, String startYear) {
        this.m_report.setLogo(logourl);
        ViewInfo viewInfo = new ViewInfo();
        this.m_report.setViewInfo(viewInfo);
        Categories categories = new Categories();
        this.m_report.setCategories(categories);
        try {
            AvailabilityData reportSource = new AvailabilityData();
            reportSource.fillReport(categoryName, this.m_report, reportFormat, monthFormat, startMonth, startDate, startYear);
        }
        catch (Exception e) {
            AvailabilityReport.log().fatal("Exception: " + e, (Throwable)e);
        }
    }

    public void marshalReport() throws ValidationException, MarshalException, IOException, Exception {
        File file = new File(ConfigFileConstants.getHome() + "/share/reports/AvailReport.xml");
        try {
            OutputStreamWriter fileWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8");
            Marshaller marshaller = new Marshaller((Writer)fileWriter);
            marshaller.setSuppressNamespaces(true);
            marshaller.marshal((Object)this.m_report);
            if (AvailabilityReport.log().isDebugEnabled()) {
                AvailabilityReport.log().debug("The xml marshalled from the castor classes is saved in " + ConfigFileConstants.getHome() + "/share/reports/AvailReport.xml");
            }
            ((Writer)fileWriter).close();
        }
        catch (Exception e) {
            AvailabilityReport.log().fatal("Exception: " + e, (Throwable)e);
        }
    }

    public void generatePDF(String xsltFileName, OutputStream out, String format) throws Exception {
        ThreadCategory.setPrefix((String)LOG4J_CATEGORY);
        if (AvailabilityReport.log().isDebugEnabled()) {
            AvailabilityReport.log().debug("inside generatePDF");
        }
        File file = new File(ConfigFileConstants.getHome() + "/share/reports/AvailReport.xml");
        try {
            if (AvailabilityReport.log().isDebugEnabled()) {
                AvailabilityReport.log().debug("The xml marshalled from the castor classes is saved in " + ConfigFileConstants.getHome() + "/share/reports/AvailReport.xml");
            }
            InputStreamReader fileReader = new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8");
            if (!format.equals("HTML")) {
                new PDFReportRenderer().render(fileReader, out, new InputStreamReader((InputStream)new FileInputStream(xsltFileName), "UTF-8"));
            } else {
                new HTMLReportRenderer().render(fileReader, out, new InputStreamReader((InputStream)new FileInputStream(xsltFileName), "UTF-8"));
            }
        }
        catch (Exception e) {
            AvailabilityReport.log().fatal("Exception: " + e, (Throwable)e);
        }
        if (AvailabilityReport.log().isInfoEnabled()) {
            AvailabilityReport.log().info("leaving generatePDF");
        }
    }

    public static void main(String[] args) {
        String monthFormat;
        String format;
        ConsoleAppender consoleAppender = new ConsoleAppender((Layout)new PatternLayout("%m%n"), "System.err");
        consoleAppender.setThreshold((Priority)Level.WARN);
        Logger logger = Logger.getLogger((String)LOG4J_CATEGORY);
        logger.addAppender((Appender)consoleAppender);
        ThreadCategory.setPrefix((String)LOG4J_CATEGORY);
        AvailabilityReport.log().debug("main() called with args: " + StringUtils.arrayToDelimitedString((Object[])args, (String)", "));
        System.setProperty("java.awt.headless", "true");
        String logourl = System.getProperty("image");
        String categoryName = System.getProperty("catName");
        if (categoryName == null || categoryName.equals("")) {
            categoryName = "all";
        }
        if ((format = System.getProperty("format")) == null || format.equals("")) {
            format = "SVG";
        }
        if ((monthFormat = System.getProperty("MonthFormat")) == null || format.equals("")) {
            monthFormat = MONTH_FORMAT_CLASSIC;
        }
        String startMonth = System.getProperty("startMonth");
        String startDate = System.getProperty("startDate");
        String startYear = System.getProperty("startYear");
        if (startMonth == null || startDate == null || startYear == null) {
            throw new NumberFormatException("missing date properties");
        }
        try {
            AvailabilityReport.generateReport(logourl, categoryName, format, monthFormat, startMonth, startDate, startYear);
        }
        catch (Exception e) {
            AvailabilityReport.log().error("Caught exception while generating report: " + e, (Throwable)e);
            e.printStackTrace();
        }
    }

    public static void generateReport(String logourl, String categoryName, String format, String monthFormat, String startMonth, String startDate, String startYear) throws Exception {
        String xslFileName;
        String pdfFileName;
        SimpleDateFormat fmt = new SimpleDateFormat("yyyyMMdd");
        String catFileName = categoryName.replace(' ', '-');
        if (format.equals("SVG")) {
            pdfFileName = ConfigFileConstants.getHome() + "/share/reports/AVAIL-SVG-" + catFileName + fmt.format(new Date()) + ".pdf";
            xslFileName = ConfigFileConstants.getFilePathString() + ConfigFileConstants.getFileName((int)ConfigFileConstants.REPORT_SVG_XSL);
        } else if (format.equals("PDF")) {
            pdfFileName = ConfigFileConstants.getHome() + "/share/reports/AVAIL-PDF-" + catFileName + fmt.format(new Date()) + ".pdf";
            xslFileName = ConfigFileConstants.getFilePathString() + ConfigFileConstants.getFileName((int)ConfigFileConstants.REPORT_PDF_XSL);
        } else if (format.equals("HTML")) {
            pdfFileName = ConfigFileConstants.getHome() + "/share/reports/AVAIL-HTML-" + catFileName + fmt.format(new Date()) + ".html";
            xslFileName = ConfigFileConstants.getFilePathString() + ConfigFileConstants.getFileName((int)ConfigFileConstants.REPORT_HTML_XSL);
        } else {
            AvailabilityReport.log().fatal("Format '" + format + "' is unsupported.  Must be one of: SVG, PDF, or HTML.");
            return;
        }
        try {
            AvailabilityReport report = new AvailabilityReport("Unknown", startMonth, startDate, startYear);
            report.getReportData(logourl, categoryName, format, monthFormat, startMonth, startDate, startYear);
            if (AvailabilityReport.log().isInfoEnabled()) {
                AvailabilityReport.log().info("Generated Report Data... ");
            }
            File file = new File(pdfFileName);
            FileOutputStream pdfFileWriter = new FileOutputStream(file);
            report.generatePDF(xslFileName, pdfFileWriter, format);
            if (AvailabilityReport.log().isInfoEnabled()) {
                AvailabilityReport.log().debug("xsl -> " + xslFileName + " pdfFileName -> " + pdfFileName + " format -> " + format);
                AvailabilityReport.log().info("Generated Report ... and saved as " + pdfFileName);
            }
        }
        catch (Exception e) {
            AvailabilityReport.log().fatal("Exception " + e, (Throwable)e);
        }
    }

    private static ThreadCategory log() {
        return ThreadCategory.getInstance(AvailabilityReport.class);
    }
}

