/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.reporting.availability;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.ListIterator;
import java.util.TreeMap;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.config.CatFactory;
import org.opennms.netmgt.config.CategoryFactory;
import org.opennms.netmgt.config.categories.Categorygroup;
import org.opennms.netmgt.config.categories.Catinfo;
import org.opennms.reporting.availability.AvailCalculations;
import org.opennms.reporting.availability.CatSections;
import org.opennms.reporting.availability.Categories;
import org.opennms.reporting.availability.Category;
import org.opennms.reporting.availability.Created;
import org.opennms.reporting.availability.Report;
import org.opennms.reporting.availability.Section;
import org.opennms.reporting.availability.svclayer.AvailabilityDataService;
import org.opennms.reporting.datablock.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AvailabilityData {
    private static final String LOG4J_CATEGORY = "OpenNMS.Report";
    private List<Node> m_nodes;
    private long m_endTime;
    private long m_startTime;
    private long m_lastMonthEndTime;
    private int m_daysInLastMonth;
    CatFactory m_catFactory;
    private int m_sectionIndex = 0;
    private AvailabilityDataService m_availabilityDataService;

    public void fillReport(String categoryName, Report report, String format, String monthFormat, String startMonth, String startDate, String startYear) throws IOException, MarshalException, ValidationException, Exception {
        GregorianCalendar cal = new GregorianCalendar();
        cal.set(5, Integer.parseInt(startDate));
        cal.set(2, Integer.parseInt(startMonth));
        cal.set(1, Integer.parseInt(startYear));
        cal.set(11, 23);
        cal.set(12, 59);
        cal.set(13, 59);
        this.generateData(categoryName, report, format, monthFormat, new Date(cal.getTimeInMillis()));
    }

    public void fillReport(String categoryName, Report report, String format, String monthFormat, Date periodEndDate) throws IOException, MarshalException, ValidationException, Exception {
        this.generateData(categoryName, report, format, monthFormat, periodEndDate);
    }

    private void generateData(String categoryName, Report report, String format, String monthFormat, Date periodEndDate) throws IOException, MarshalException, ValidationException, Exception {
        ThreadCategory.setPrefix((String)LOG4J_CATEGORY);
        ThreadCategory log = ThreadCategory.getInstance(this.getClass());
        log.debug("Inside AvailabilityData");
        this.m_nodes = new ArrayList<Node>();
        this.initializeInterval(periodEndDate);
        Catinfo config = null;
        try {
            CategoryFactory.init();
            this.m_catFactory = CategoryFactory.getInstance();
            config = this.m_catFactory.getConfig();
        }
        catch (IOException e) {
            log.fatal("Initializing CategoryFactory", (Throwable)e);
            throw e;
        }
        catch (MarshalException e) {
            log.fatal("Initializing CategoryFactory", (Throwable)e);
            throw e;
        }
        catch (ValidationException e) {
            log.fatal("Initializing CategoryFactory", (Throwable)e);
            throw e;
        }
        if (log.isDebugEnabled()) {
            log.debug("CATEGORY " + categoryName);
        }
        if (categoryName.equals("") || categoryName.equals("all")) {
            int catCount = 0;
            if (log.isDebugEnabled()) {
                log.debug("catCount " + catCount);
            }
            for (Categorygroup cg : config.getCategorygroupCollection()) {
                org.opennms.netmgt.config.categories.Categories cats = cg.getCategories();
                for (org.opennms.netmgt.config.categories.Category cat : cats.getCategoryCollection()) {
                    if (log.isDebugEnabled()) {
                        log.debug("CATEGORY " + cat.getLabel());
                    }
                    this.populateDataStructures(cat, report, format, monthFormat, ++catCount);
                }
            }
            if (log.isDebugEnabled()) {
                log.debug("catCount " + catCount);
            }
        } else {
            org.opennms.netmgt.config.categories.Category cat = this.m_catFactory.getCategory(categoryName);
            if (log.isDebugEnabled()) {
                log.debug("CATEGORY - now populating data structures " + cat.getLabel());
            }
            this.populateDataStructures(cat, report, format, monthFormat, 1);
        }
        SimpleDateFormat simplePeriod = new SimpleDateFormat("MMMMMMMMMMM dd, yyyy");
        String reportPeriod = simplePeriod.format(new Date(this.m_startTime)) + " - " + simplePeriod.format(new Date(this.m_endTime));
        Created created = report.getCreated();
        if (created == null) {
            created = new Created();
        }
        created.setPeriod(reportPeriod);
        report.setCreated(created);
        if (log.isDebugEnabled()) {
            log.debug("After availCalculations");
        }
    }

    private void populateDataStructures(org.opennms.netmgt.config.categories.Category cat, Report report, String format, String monthFormat, int catIndex) throws Exception {
        ThreadCategory log = ThreadCategory.getInstance(this.getClass());
        if (log.isDebugEnabled()) {
            log.debug("Inside populate data Structures" + catIndex);
        }
        report.setCatCount(catIndex);
        log.debug("Inside populate data Structures");
        try {
            ArrayList<String> monitoredServices = new ArrayList<String>(cat.getServiceCollection());
            if (this.m_availabilityDataService == null) {
                log.debug("DATA SERVICE IS NULL");
            }
            this.m_nodes = this.m_availabilityDataService.getNodes(cat, this.m_startTime, this.m_endTime);
            if (log.isDebugEnabled()) {
                log.debug("Nodes " + this.m_nodes);
            }
            ListIterator<Node> cleanNodes = this.m_nodes.listIterator();
            while (cleanNodes.hasNext()) {
                Node node = cleanNodes.next();
                if (node == null || node.hasOutages()) continue;
                if (log.isDebugEnabled()) {
                    log.debug("Removing node: " + node);
                }
                cleanNodes.remove();
            }
            if (log.isDebugEnabled()) {
                log.debug("Cleaned Nodes " + this.m_nodes);
            }
            TreeMap<Double, List<String>> topOffenders = this.getPercentNode();
            if (log.isDebugEnabled()) {
                log.debug("TOP OFFENDERS " + topOffenders);
            }
            if (this.m_nodes.size() <= 0) {
                this.m_nodes = null;
            }
            if (this.m_nodes != null) {
                AvailCalculations availCalculations = new AvailCalculations(this.m_nodes, this.m_endTime, this.m_lastMonthEndTime, monitoredServices, report, topOffenders, cat.getWarning(), cat.getNormal(), cat.getComment(), cat.getLabel(), format, monthFormat, catIndex, this.m_sectionIndex);
                this.m_sectionIndex = availCalculations.getSectionIndex();
                report.setSectionCount(this.m_sectionIndex - 1);
            } else {
                Category category = new Category();
                category.setCatComments(cat.getComment());
                category.setCatName(cat.getLabel());
                category.setCatIndex(catIndex);
                category.setNodeCount(0);
                category.setIpaddrCount(0);
                category.setServiceCount(0);
                Section section = new Section();
                section.setSectionIndex(this.m_sectionIndex);
                CatSections catSections = new CatSections();
                catSections.addSection(section);
                category.addCatSections(catSections);
                Categories categories = report.getCategories();
                categories.addCategory(category);
                report.setCategories(categories);
                report.setSectionCount(this.m_sectionIndex);
                ++this.m_sectionIndex;
            }
        }
        catch (Exception e) {
            log.fatal("Exception has occured", (Throwable)e);
            throw e;
        }
    }

    private void initializeInterval(Date periodEndDate) {
        GregorianCalendar tempCal = new GregorianCalendar();
        tempCal.setTime(periodEndDate);
        tempCal.set(11, 23);
        tempCal.set(12, 59);
        tempCal.set(13, 59);
        tempCal.set(14, 999);
        this.m_endTime = tempCal.getTimeInMillis();
        ((Calendar)tempCal).add(1, -1);
        tempCal.set(5, 1);
        tempCal.set(11, 0);
        tempCal.set(12, 0);
        tempCal.set(13, 0);
        tempCal.set(14, 0);
        this.m_startTime = tempCal.getTimeInMillis();
        tempCal.setTimeInMillis(this.m_endTime);
        ((Calendar)tempCal).add(2, -1);
        this.m_daysInLastMonth = ((Calendar)tempCal).getActualMaximum(5);
        tempCal.set(5, this.m_daysInLastMonth);
        tempCal.set(11, 23);
        tempCal.set(12, 59);
        tempCal.set(13, 59);
        tempCal.set(14, 999);
        this.m_lastMonthEndTime = tempCal.getTimeInMillis();
    }

    public List<Node> getNodes() {
        return this.m_nodes;
    }

    public TreeMap<Double, List<String>> getPercentNode() {
        ThreadCategory log = ThreadCategory.getInstance(this.getClass());
        int days = this.m_daysInLastMonth;
        long endTime = this.m_lastMonthEndTime;
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTimeInMillis(endTime);
        ((Calendar)cal).add(5, -1 * days);
        long rollingWindow = endTime - cal.getTime().getTime();
        long startTime = cal.getTime().getTime();
        if (log.isDebugEnabled()) {
            log.debug("getPercentNode: Start time " + new Date(startTime));
            log.debug("getPercentNode: End time " + new Date(endTime));
        }
        TreeMap<Double, List<String>> percentNode = new TreeMap<Double, List<String>>();
        for (Node node : this.m_nodes) {
            if (node == null) continue;
            double percent = node.getPercentAvail(endTime, rollingWindow);
            String nodeName = node.getName();
            if (log.isDebugEnabled()) {
                log.debug("Node " + nodeName + " " + percent + "%");
            }
            if (!(percent < 100.0)) continue;
            List<String> nodeNames = percentNode.get(new Double(percent));
            if (nodeNames == null) {
                nodeNames = new ArrayList<String>();
            }
            nodeNames.add(nodeName);
            percentNode.put(new Double(percent), nodeNames);
        }
        if (log.isDebugEnabled()) {
            log.debug("Percent node " + percentNode);
        }
        return percentNode;
    }

    public void setAvailabilityDataService(AvailabilityDataService availabilityDataService) {
        ThreadCategory log = ThreadCategory.getInstance(this.getClass());
        log.debug("setting m_availabilityDataService");
        this.m_availabilityDataService = availabilityDataService;
    }
}

