/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.poller.remote.gwt.server.geocoding;

import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Date;
import java.util.List;
import net.simon04.jelementtree.ElementTree;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.opennms.core.utils.LogUtils;
import org.opennms.features.poller.remote.gwt.client.GWTLatLng;
import org.opennms.features.poller.remote.gwt.server.geocoding.Geocoder;
import org.opennms.features.poller.remote.gwt.server.geocoding.GeocoderException;

public class NominatimGeocoder
implements Geocoder {
    private static final String GEOCODE_URL = "http://nominatim.openstreetmap.org/search?format=xml";
    private static final HttpClient m_httpClient = new HttpClient();
    private String m_emailAddress;
    private String m_referer = null;
    private static final int m_rateLimit = 1000;
    private static volatile Date m_lastRequest = new Date();

    public NominatimGeocoder() throws GeocoderException {
        this(System.getProperty("gwt.geocoder.email"));
    }

    public NominatimGeocoder(String emailAddress) throws GeocoderException {
        this.m_emailAddress = emailAddress;
        this.m_referer = System.getProperty("gwt.geocoder.referer");
        if (this.m_emailAddress == null || this.m_emailAddress.equals("")) {
            throw new GeocoderException("you must configure gwt.geocoder.email to comply with the Nominatim terms of service (see http://wiki.openstreetmap.org/wiki/Nominatim)");
        }
    }

    public GWTLatLng geocode(String geolocation) throws GeocoderException {
        Date now = new Date();
        long difference = now.getTime() - m_lastRequest.getTime();
        m_lastRequest = now;
        if (difference < 1000L) {
            try {
                LogUtils.tracef((Object)this, (String)"waiting %d milliseconds for the next request", (Object[])new Object[]{difference});
                Thread.sleep(difference);
            }
            catch (InterruptedException e) {
                LogUtils.warnf((Object)this, (Throwable)e, (String)"thread was interrupted while sleeping", (Object[])new Object[0]);
                Thread.currentThread().interrupt();
            }
        }
        GetMethod method = new GetMethod(this.getUrl(geolocation));
        method.addRequestHeader("User-Agent", "OpenNMS-MapquestGeocoder/1.0");
        if (this.m_referer != null) {
            method.addRequestHeader("Referer", this.m_referer);
        }
        try {
            m_httpClient.executeMethod((HttpMethod)method);
            ElementTree tree = ElementTree.fromStream((InputStream)method.getResponseBodyAsStream());
            if (tree == null) {
                throw new GeocoderException("an error occurred connecting to the Nominatim geocoding service (no XML tree was found)");
            }
            List places = tree.findAll("//place");
            if (places.size() > 1) {
                LogUtils.warnf((Object)this, (String)"more than one location returned for query: %s", (Object[])new Object[]{geolocation});
            } else if (places.size() == 0) {
                throw new GeocoderException("Nominatim returned an OK status code, but no places");
            }
            ElementTree place = (ElementTree)places.get(0);
            Double latitude = Double.valueOf(place.getAttribute("lat"));
            Double longitude = Double.valueOf(place.getAttribute("lon"));
            return new GWTLatLng(latitude, longitude);
        }
        catch (GeocoderException e) {
            throw e;
        }
        catch (Exception e) {
            throw new GeocoderException("unable to get lat/lng from Nominatim", e);
        }
    }

    private String getUrl(String geolocation) throws GeocoderException {
        try {
            return "http://nominatim.openstreetmap.org/search?format=xml&q=" + URLEncoder.encode(geolocation, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new GeocoderException("unable to URL-encode query string", e);
        }
    }
}

