/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.poller.remote.gwt.server.geocoding;

import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.List;
import net.simon04.jelementtree.ElementTree;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.opennms.core.utils.LogUtils;
import org.opennms.features.poller.remote.gwt.client.GWTLatLng;
import org.opennms.features.poller.remote.gwt.server.geocoding.Geocoder;
import org.opennms.features.poller.remote.gwt.server.geocoding.GeocoderException;

public class MapquestGeocoder
implements Geocoder {
    private static final String GEOCODE_URL = "http://www.mapquestapi.com/geocoding/v1/address?callback=renderGeocode&outFormat=xml";
    private static final HttpClient m_httpClient = new HttpClient();
    private String m_apiKey = System.getProperty("gwt.apikey");
    private Quality m_minimumQuality;
    private String m_referer = System.getProperty("gwt.geocoder.referer");

    public MapquestGeocoder() {
        String minimumQuality = System.getProperty("gwt.geocoder.minimumQuality");
        if (minimumQuality != null) {
            this.m_minimumQuality = Quality.valueOf(minimumQuality);
        }
    }

    public MapquestGeocoder(String apiKey) {
        this();
        this.m_apiKey = apiKey;
    }

    public GWTLatLng geocode(String geolocation) throws GeocoderException {
        GetMethod method = new GetMethod(this.getUrl(geolocation));
        method.addRequestHeader("User-Agent", "OpenNMS-MapQuestGeocoder/1.0");
        method.addRequestHeader("Referer", this.m_referer);
        try {
            Quality geocodeQuality;
            m_httpClient.executeMethod((HttpMethod)method);
            ElementTree tree = ElementTree.fromStream((InputStream)method.getResponseBodyAsStream());
            if (tree == null) {
                throw new GeocoderException("an error occurred connecting to the MapQuest geocoding service (no XML tree was found)");
            }
            ElementTree statusCode = tree.find("//statusCode");
            if (statusCode == null || !statusCode.getText().equals("0")) {
                String code = statusCode == null ? "unknown" : statusCode.getText();
                ElementTree messageTree = tree.find("//message");
                String message = messageTree == null ? "unknown" : messageTree.getText();
                throw new GeocoderException("an error occurred when querying MapQuest (statusCode=" + code + ", message=" + message + ")");
            }
            List locations = tree.findAll("//location");
            if (locations.size() > 1) {
                LogUtils.warnf((Object)this, (String)"more than one location returned for query: %s", (Object[])new Object[]{geolocation});
            } else if (locations.size() == 0) {
                throw new GeocoderException("MapQuest returned an OK status code, but no locations");
            }
            ElementTree location = (ElementTree)locations.get(0);
            if (this.m_minimumQuality != null && (geocodeQuality = Quality.valueOf(location.find("//geocodeQuality").getText().toUpperCase())).compareTo(this.m_minimumQuality) < 0) {
                throw new GeocoderException("response did not meet minimum quality requirement (" + (Object)((Object)geocodeQuality) + " is less specific than " + (Object)((Object)this.m_minimumQuality) + ")");
            }
            ElementTree latLng = location.find("//latLng");
            Double latitude = Double.valueOf(latLng.find("//lat").getText());
            Double longitude = Double.valueOf(latLng.find("//lng").getText());
            return new GWTLatLng(latitude, longitude);
        }
        catch (GeocoderException e) {
            throw e;
        }
        catch (Exception e) {
            throw new GeocoderException("unable to get lat/lng from MapQuest", e);
        }
    }

    private String getUrl(String geolocation) throws GeocoderException {
        try {
            return "http://www.mapquestapi.com/geocoding/v1/address?callback=renderGeocode&outFormat=xml&key=" + this.m_apiKey + "&location=" + URLEncoder.encode(geolocation, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new GeocoderException("unable to URL-encode query string", e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Quality {
        COUNTRY,
        STATE,
        ZIP,
        COUNTY,
        ZIP_EXTENDED,
        CITY,
        STREET,
        INTERSECTION,
        ADDRESS,
        POINT;

    }
}

