/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.poller.remote.gwt.server.geocoding;

import geo.google.GeoAddressStandardizer;
import geo.google.datamodel.GeoAddress;
import geo.google.datamodel.GeoCoordinate;
import java.util.List;
import org.opennms.core.utils.LogUtils;
import org.opennms.features.poller.remote.gwt.client.GWTLatLng;
import org.opennms.features.poller.remote.gwt.server.geocoding.Geocoder;
import org.opennms.features.poller.remote.gwt.server.geocoding.GeocoderException;

public class GoogleMapsGeocoder
implements Geocoder {
    private static final long DEFAULT_RATE = 10L;
    private final GeoAddressStandardizer m_standardizer;

    public GoogleMapsGeocoder() {
        String apiKey = System.getProperty("gwt.apikey");
        String rate = System.getProperty("gwt.geocoder.rate");
        this.m_standardizer = rate != null ? new GeoAddressStandardizer(apiKey, Long.valueOf(rate).longValue()) : new GeoAddressStandardizer(apiKey, 10L);
    }

    public GWTLatLng geocode(String geolocation) throws GeocoderException {
        try {
            List addresses = this.m_standardizer.standardizeToGeoAddresses(geolocation);
            if (addresses.size() > 0) {
                if (addresses.size() > 1) {
                    LogUtils.warnf((Object)this, (String)"received more than one address for geolocation '%s', returning the first", (Object[])new Object[]{geolocation});
                }
                return this.getLatLng(((GeoAddress)addresses.get(0)).getCoordinate());
            }
            throw new GeocoderException("unable to find latitude/longitude for geolocation '" + geolocation + "'");
        }
        catch (Exception e) {
            LogUtils.infof((Object)this, (Throwable)e, (String)"unable to convert geolocation '%s'", (Object[])new Object[]{geolocation});
            throw new GeocoderException(e);
        }
    }

    private GWTLatLng getLatLng(GeoCoordinate geoCoordinate) {
        return new GWTLatLng(geoCoordinate.getLatitude(), geoCoordinate.getLongitude());
    }
}

