/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.poller.remote.gwt.server;

import de.novanic.eventservice.client.event.Event;
import de.novanic.eventservice.service.EventExecutorService;
import de.novanic.eventservice.service.EventExecutorServiceFactory;
import de.novanic.eventservice.service.RemoteEventServiceServlet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.servlet.ServletContext;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.opennms.core.utils.LogUtils;
import org.opennms.features.poller.remote.gwt.client.ApplicationDetails;
import org.opennms.features.poller.remote.gwt.client.ApplicationInfo;
import org.opennms.features.poller.remote.gwt.client.LocationStatusService;
import org.opennms.features.poller.remote.gwt.client.RemotePollerPresenter;
import org.opennms.features.poller.remote.gwt.client.location.LocationDetails;
import org.opennms.features.poller.remote.gwt.client.location.LocationInfo;
import org.opennms.features.poller.remote.gwt.client.remoteevents.LocationsUpdatedRemoteEvent;
import org.opennms.features.poller.remote.gwt.client.remoteevents.MapRemoteEvent;
import org.opennms.features.poller.remote.gwt.client.remoteevents.UpdateCompleteRemoteEvent;
import org.opennms.features.poller.remote.gwt.server.ApplicationHandler;
import org.opennms.features.poller.remote.gwt.server.DefaultApplicationHandler;
import org.opennms.features.poller.remote.gwt.server.DefaultLocationDefHandler;
import org.opennms.features.poller.remote.gwt.server.LocationBroadcastProcessor;
import org.opennms.features.poller.remote.gwt.server.LocationDataService;
import org.opennms.features.poller.remote.gwt.server.LocationEventHandler;
import org.opennms.features.poller.remote.gwt.server.UserSpecificApplicationHandler;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class LocationStatusServiceImpl
extends RemoteEventServiceServlet
implements LocationStatusService {
    private static final long serialVersionUID = 1L;
    private static final int UPDATE_PERIOD = 60000;
    private static final int PADDING_TIME = 2000;
    private static final int APPLICATION_UPDATE_OFFSET = 1;
    private static volatile Timer m_timer;
    private static volatile Date m_lastUpdated;
    private static volatile AtomicBoolean m_initializationComplete;
    private static volatile Set<String> m_activeApplications;
    private static volatile WebApplicationContext m_context;
    private static volatile LocationDataService m_locationDataService;
    private static volatile LocationBroadcastProcessor m_locationBroadcastProcessor;

    private void initialize() {
        Logger.getLogger((String)"com.google.gwt.user.client.rpc").setLevel(Level.TRACE);
        if (m_context == null) {
            LogUtils.infof((Object)this, (String)"initializing context", (Object[])new Object[0]);
            m_context = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServletContext());
        }
        if (m_locationDataService == null) {
            LogUtils.infof((Object)this, (String)"initializing location data service", (Object[])new Object[0]);
            m_locationDataService = (LocationDataService)m_context.getBean(LocationDataService.class);
        }
        if (m_initializationComplete == null) {
            m_initializationComplete = new AtomicBoolean(false);
        }
        if (m_locationBroadcastProcessor == null) {
            m_locationBroadcastProcessor = (LocationBroadcastProcessor)m_context.getBean(LocationBroadcastProcessor.class);
            m_locationBroadcastProcessor.setEventHandler(new LocationEventHandler(){

                public void sendEvent(MapRemoteEvent event) {
                    LocationStatusServiceImpl.this.addEvent(RemotePollerPresenter.LOCATION_EVENT_DOMAIN, event);
                }
            });
        }
    }

    public void start() {
        LogUtils.debugf((Object)this, (String)"starting location status service", (Object[])new Object[0]);
        this.initialize();
        final EventExecutorService service = EventExecutorServiceFactory.getInstance().getEventExecutorService(this.getRequest().getSession());
        if (m_timer == null) {
            m_timer = new Timer();
            m_timer.schedule(new TimerTask(){
                CountDownLatch m_latch = new CountDownLatch(1);

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    if (!m_initializationComplete.get()) {
                        return;
                    }
                    if (m_lastUpdated == null) {
                        return;
                    }
                    try {
                        LogUtils.debugf((Object)this, (String)"pushing monitor status updates", (Object[])new Object[0]);
                        Date endDate = new Date();
                        LocationStatusServiceImpl.this.addEvent(RemotePollerPresenter.LOCATION_EVENT_DOMAIN, new LocationsUpdatedRemoteEvent(m_locationDataService.getUpdatedLocationsBetween(m_lastUpdated, endDate)));
                        LogUtils.debugf((Object)this, (String)"finished pushing monitor status updates", (Object[])new Object[0]);
                        CountDownLatch countDownLatch = this.m_latch;
                        synchronized (countDownLatch) {
                            this.m_latch.countDown();
                            if (this.m_latch.getCount() == 0L) {
                                LogUtils.debugf((Object)this, (String)"pushing application updates", (Object[])new Object[0]);
                                ArrayList<ApplicationHandler> appHandlers = new ArrayList<ApplicationHandler>();
                                DefaultApplicationHandler applicationHandler = new DefaultApplicationHandler(m_locationDataService, service, true, m_activeApplications);
                                appHandlers.add(applicationHandler);
                                m_locationDataService.handleAllApplications(appHandlers);
                                Set set = m_activeApplications;
                                synchronized (set) {
                                    m_activeApplications.clear();
                                    m_activeApplications.addAll(applicationHandler.getApplicationNames());
                                }
                                this.m_latch = new CountDownLatch(1);
                                LogUtils.debugf((Object)this, (String)"finished pushing application updates", (Object[])new Object[0]);
                            }
                        }
                        m_lastUpdated = endDate;
                    }
                    catch (Exception e) {
                        LogUtils.warnf((Object)this, (Throwable)e, (String)"An error occurred while pushing monitor and application status updates.", (Object[])new Object[0]);
                    }
                }
            }, 60000L, 60000L);
        }
        TimerTask initializedTask = new TimerTask(){

            public void run() {
                try {
                    LocationStatusServiceImpl.this.pushInitialData(service);
                    service.addEventUserSpecific((Event)new UpdateCompleteRemoteEvent());
                    m_lastUpdated = new Date();
                    m_initializationComplete.set(true);
                }
                catch (Exception e) {
                    LogUtils.warnf((Object)this, (Throwable)e, (String)"An exception occurred pushing initial data.", (Object[])new Object[0]);
                }
            }
        };
        m_timer.schedule(initializedTask, 2000L);
    }

    public LocationInfo getLocationInfo(String locationName) {
        return m_locationDataService.getLocationInfo(locationName);
    }

    public LocationDetails getLocationDetails(String locationName) {
        return m_locationDataService.getLocationDetails(locationName);
    }

    public ApplicationInfo getApplicationInfo(String applicationName) {
        return m_locationDataService.getApplicationInfo(applicationName);
    }

    public ApplicationDetails getApplicationDetails(String applicationName) {
        return m_locationDataService.getApplicationDetails(applicationName);
    }

    private void pushInitialData(EventExecutorService service) {
        LogUtils.debugf((Object)this, (String)"pushing initialized locations", (Object[])new Object[0]);
        DefaultLocationDefHandler locationHandler = new DefaultLocationDefHandler(m_locationDataService, service, true);
        m_locationDataService.handleAllMonitoringLocationDefinitions(Collections.singleton(locationHandler));
        LogUtils.debugf((Object)this, (String)"finished pushing initialized locations", (Object[])new Object[0]);
        LogUtils.debugf((Object)this, (String)"pushing initialized applications", (Object[])new Object[0]);
        ArrayList<ApplicationHandler> appHandlers = new ArrayList<ApplicationHandler>();
        appHandlers.add(new UserSpecificApplicationHandler(m_locationDataService, service, true));
        m_locationDataService.handleAllApplications(appHandlers);
        LogUtils.debugf((Object)this, (String)"finished pushing initialized applications", (Object[])new Object[0]);
    }

    static {
        m_activeApplications = new HashSet<String>();
    }
}

