/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.poller.remote.gwt.server;

import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import org.hibernate.criterion.Restrictions;
import org.opennms.core.utils.LogUtils;
import org.opennms.features.poller.remote.gwt.client.ApplicationInfo;
import org.opennms.features.poller.remote.gwt.client.location.LocationInfo;
import org.opennms.features.poller.remote.gwt.client.remoteevents.ApplicationUpdatedRemoteEvent;
import org.opennms.features.poller.remote.gwt.client.remoteevents.LocationUpdatedRemoteEvent;
import org.opennms.features.poller.remote.gwt.server.LocationDataService;
import org.opennms.features.poller.remote.gwt.server.LocationEventHandler;
import org.opennms.netmgt.dao.EventDao;
import org.opennms.netmgt.model.OnmsCriteria;
import org.opennms.netmgt.model.OnmsEvent;
import org.opennms.netmgt.model.events.Parameter;
import org.opennms.netmgt.model.events.annotations.EventHandler;
import org.opennms.netmgt.model.events.annotations.EventListener;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xml.event.Parm;
import org.opennms.netmgt.xml.event.Parms;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;

@EventListener(name="LocationStatusService")
public class LocationBroadcastProcessor
implements InitializingBean {
    @Autowired
    private LocationDataService m_locationDataService;
    @Autowired
    private EventDao m_eventDao;
    private static final long UPDATE_PERIOD = 60000L;
    private static volatile Timer m_timer;
    private String[] m_events = new String[]{"uei.opennms.org/remote/locationMonitorStarted", "uei.opennms.org/remote/locationMonitorStopped", "uei.opennms.org/remote/locationMonitorDisconnected", "uei.opennms.org/remote/locationMonitorReconnected", "uei.opennms.org/remote/locationMonitorRegistered", "uei.opennms.org/remote/locationMonitorPaused", "uei.opennms.org/remote/nodes/nodeLostService", "uei.opennms.org/remote/nodes/nodeRegainedService"};
    public LocationEventHandler m_eventHandler;

    public LocationBroadcastProcessor() {
        m_timer = new Timer();
    }

    public void afterPropertiesSet() throws Exception {
        m_timer.schedule(new TimerTask(){
            private Date m_lastRun = new Date();

            public void run() {
                Date now = new Date();
                OnmsCriteria criteria = new OnmsCriteria(OnmsEvent.class).add(Restrictions.between((String)"eventTime", (Object)this.m_lastRun, (Object)now)).add(Restrictions.in((String)"eventUei", (Object[])LocationBroadcastProcessor.this.m_events));
                for (OnmsEvent e : LocationBroadcastProcessor.this.m_eventDao.findMatching(criteria)) {
                    LocationBroadcastProcessor.this.handleLocationEvent(e);
                }
                this.m_lastRun = now;
            }
        }, 60000L, 60000L);
    }

    @EventHandler(uei="uei.opennms.org/remote/locationMonitorStarted")
    public void locationMonitorStarted(Event event) {
        this.handleLocationEvent(event);
    }

    @EventHandler(uei="uei.opennms.org/remote/locationMonitorStopped")
    public void locationMonitorStopped(Event event) {
        this.handleLocationEvent(event);
    }

    @EventHandler(uei="uei.opennms.org/remote/locationMonitorDisconnected")
    public void locationMonitorDisconnected(Event event) {
        this.handleLocationEvent(event);
    }

    @EventHandler(uei="uei.opennms.org/remote/locationMonitorReconnected")
    public void locationMonitorReconnected(Event event) {
        this.handleLocationEvent(event);
    }

    @EventHandler(uei="uei.opennms.org/remote/locationMonitorRegistered")
    public void locationMonitorRegistered(Event event) {
        this.handleLocationEvent(event);
    }

    @EventHandler(uei="uei.opennms.org/remote/locationMonitorPaused")
    public void locationMonitorPaused(Event event) {
        this.handleLocationEvent(event);
    }

    @EventHandler(uei="uei.opennms.org/remote/nodes/nodeLostService")
    public void nodeLostService(Event event) {
        this.handleLocationEvent(event);
    }

    @EventHandler(uei="uei.opennms.org/remote/nodes/nodeRegainedService")
    public void nodeRegainedService(Event event) {
        this.handleLocationEvent(event);
    }

    public void setEventHandler(LocationEventHandler handler) {
        this.m_eventHandler = handler;
    }

    private void handleLocationEvent(OnmsEvent event) {
        if (this.m_eventHandler == null) {
            LogUtils.warnf((Object)this, (String)"handleLocationEvent called, but no eventHandler is registered", (Object[])new Object[0]);
            return;
        }
        this.handleEventParms(Parameter.decode((String)event.getEventParms()));
    }

    private void handleLocationEvent(Event event) {
        if (this.m_eventHandler == null) {
            LogUtils.warnf((Object)this, (String)"handleLocationEvent called, but no eventHandler is registered", (Object[])new Object[0]);
            return;
        }
        this.handleEventParms(event.getParms());
    }

    private void handleEventParms(Parms parms) {
        for (Parm p : parms.getParmCollection()) {
            if (!p.getParmName().equals("locationMonitorId")) continue;
            LocationInfo info = this.m_locationDataService.getLocationInfoForMonitor(Integer.valueOf(p.getValue().getContent()));
            this.m_eventHandler.sendEvent(new LocationUpdatedRemoteEvent(info));
            for (ApplicationInfo applicationInfo : this.m_locationDataService.getApplicationsForLocation(info)) {
                this.m_eventHandler.sendEvent(new ApplicationUpdatedRemoteEvent(applicationInfo));
            }
        }
    }
}

