/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.poller.remote.gwt.server;

import de.novanic.eventservice.client.event.Event;
import de.novanic.eventservice.service.EventExecutorService;
import java.util.Date;
import org.opennms.core.utils.LogUtils;
import org.opennms.features.poller.remote.gwt.client.GWTLatLng;
import org.opennms.features.poller.remote.gwt.client.remoteevents.GeocodingFinishedRemoteEvent;
import org.opennms.features.poller.remote.gwt.client.remoteevents.GeocodingUpdatingRemoteEvent;
import org.opennms.features.poller.remote.gwt.server.LocationDataService;
import org.opennms.features.poller.remote.gwt.server.LocationDefHandler;
import org.opennms.netmgt.model.OnmsMonitoringLocationDefinition;

class GeocodingHandler
implements LocationDefHandler {
    private final LocationDataService m_locationDataService;
    private final EventExecutorService m_eventService;
    private int m_size;
    private Date m_date;
    private int m_count;

    public GeocodingHandler(LocationDataService locationDataService, EventExecutorService eventService) {
        this.m_locationDataService = locationDataService;
        this.m_eventService = eventService;
        this.m_date = new Date();
        this.m_count = 0;
    }

    public void start(int size) {
        this.m_size = size;
        this.m_eventService.addEventUserSpecific((Event)new GeocodingUpdatingRemoteEvent(0, size));
    }

    public void handle(OnmsMonitoringLocationDefinition def) {
        Date now;
        GWTLatLng latLng = this.m_locationDataService.getLatLng(def, false);
        if (latLng != null) {
            def.setCoordinates(latLng.getCoordinates());
        }
        if ((now = new Date()).getTime() - this.m_date.getTime() >= 500L) {
            this.m_eventService.addEventUserSpecific((Event)new GeocodingUpdatingRemoteEvent(this.m_count, this.m_size));
            LogUtils.debugf((Object)this, (String)("initializing locations (" + this.m_count + "/" + this.m_size + ")"), (Object[])new Object[0]);
            this.m_date = now;
        }
        ++this.m_count;
    }

    public void finish() {
        this.m_eventService.addEventUserSpecific((Event)new GeocodingFinishedRemoteEvent(this.m_size));
    }
}

