/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.poller.remote.gwt.server;

import de.novanic.eventservice.client.event.Event;
import de.novanic.eventservice.service.EventExecutorService;
import java.util.ArrayList;
import java.util.Collection;
import org.opennms.features.poller.remote.gwt.client.location.LocationInfo;
import org.opennms.features.poller.remote.gwt.client.remoteevents.LocationUpdatedRemoteEvent;
import org.opennms.features.poller.remote.gwt.client.remoteevents.LocationsUpdatedRemoteEvent;
import org.opennms.features.poller.remote.gwt.server.LocationDataService;
import org.opennms.features.poller.remote.gwt.server.LocationDefHandler;
import org.opennms.netmgt.model.OnmsMonitoringLocationDefinition;

class DefaultLocationDefHandler
implements LocationDefHandler {
    private LocationDataService m_locationDataService;
    private EventExecutorService m_eventService;
    private boolean m_includeStatus;
    private Collection<LocationInfo> m_locations = new ArrayList<LocationInfo>();
    static final int MAX_LOCATIONS_PER_EVENT = 50;

    public DefaultLocationDefHandler(LocationDataService locationDataService, EventExecutorService eventService, boolean includeStatus) {
        this.m_locationDataService = locationDataService;
        this.m_eventService = eventService;
        this.m_includeStatus = includeStatus;
    }

    public void start(int size) {
    }

    public void handle(OnmsMonitoringLocationDefinition def) {
        LocationUpdatedRemoteEvent event = new LocationUpdatedRemoteEvent(this.m_locationDataService.getLocationInfo(def, this.m_includeStatus));
        this.getEventService().addEventUserSpecific((Event)event);
    }

    public void finish() {
        this.sendLocations();
    }

    protected void sendEvent(Event event) {
        this.getEventService().addEventUserSpecific(event);
    }

    protected EventExecutorService getEventService() {
        return this.m_eventService;
    }

    protected void sendLocations() {
        if (this.m_locations.size() > 0) {
            LocationsUpdatedRemoteEvent event = new LocationsUpdatedRemoteEvent(this.m_locations);
            this.m_locations = new ArrayList<LocationInfo>();
            this.sendEvent(event);
            this.getEventService().addEventUserSpecific((Event)event);
        }
    }
}

