/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.poller.remote.gwt.server;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.CountDownLatch;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.opennms.core.utils.LogUtils;
import org.opennms.features.poller.remote.gwt.client.ApplicationDetails;
import org.opennms.features.poller.remote.gwt.client.ApplicationInfo;
import org.opennms.features.poller.remote.gwt.client.ApplicationState;
import org.opennms.features.poller.remote.gwt.client.GWTLatLng;
import org.opennms.features.poller.remote.gwt.client.GWTLocationMonitor;
import org.opennms.features.poller.remote.gwt.client.GWTLocationSpecificStatus;
import org.opennms.features.poller.remote.gwt.client.GWTMarkerState;
import org.opennms.features.poller.remote.gwt.client.GWTMonitoredService;
import org.opennms.features.poller.remote.gwt.client.GWTPollResult;
import org.opennms.features.poller.remote.gwt.client.LocationMonitorState;
import org.opennms.features.poller.remote.gwt.client.Status;
import org.opennms.features.poller.remote.gwt.client.StatusDetails;
import org.opennms.features.poller.remote.gwt.client.location.LocationDetails;
import org.opennms.features.poller.remote.gwt.client.location.LocationInfo;
import org.opennms.features.poller.remote.gwt.server.ApplicationHandler;
import org.opennms.features.poller.remote.gwt.server.LocationDataService;
import org.opennms.features.poller.remote.gwt.server.LocationDefHandler;
import org.opennms.features.poller.remote.gwt.server.geocoding.Geocoder;
import org.opennms.features.poller.remote.gwt.server.geocoding.GeocoderException;
import org.opennms.netmgt.dao.ApplicationDao;
import org.opennms.netmgt.dao.LocationMonitorDao;
import org.opennms.netmgt.dao.MonitoredServiceDao;
import org.opennms.netmgt.model.OnmsApplication;
import org.opennms.netmgt.model.OnmsCriteria;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsLocationMonitor;
import org.opennms.netmgt.model.OnmsLocationSpecificStatus;
import org.opennms.netmgt.model.OnmsMonitoredService;
import org.opennms.netmgt.model.OnmsMonitoringLocationDefinition;
import org.opennms.netmgt.model.OnmsSnmpInterface;
import org.opennms.netmgt.model.PollStatus;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultLocationDataService
implements LocationDataService,
InitializingBean {
    private static final int AVAILABILITY_MS = 86400000;
    @Autowired
    private LocationMonitorDao m_locationDao;
    @Autowired
    private ApplicationDao m_applicationDao;
    @Autowired
    private MonitoredServiceDao m_monitoredServiceDao;
    @Autowired
    private Geocoder m_geocoder;
    private CountDownLatch m_initializationLatch = new CountDownLatch(1);
    private volatile Map<String, OnmsLocationMonitor.MonitorStatus> m_monitorStatuses = new HashMap<String, OnmsLocationMonitor.MonitorStatus>();
    public boolean m_save = true;

    public void setLocationMonitorDao(LocationMonitorDao dao) {
        this.m_locationDao = dao;
    }

    public void setApplicationDao(ApplicationDao dao) {
        this.m_applicationDao = dao;
    }

    public void setMonitoredServiceDao(MonitoredServiceDao dao) {
        this.m_monitoredServiceDao = dao;
    }

    public void setGeocoder(Geocoder geocoder) {
        this.m_geocoder = geocoder;
    }

    public void setSave(boolean save) {
        this.m_save = save;
    }

    public void afterPropertiesSet() {
        Assert.notNull((Object)this.m_locationDao);
        Assert.notNull((Object)this.m_applicationDao);
        Assert.notNull((Object)this.m_monitoredServiceDao);
        Assert.notNull((Object)this.m_geocoder);
        this.initialize();
    }

    public void initialize() {
        new InitializationThread().start();
    }

    @Override
    @Transactional
    public LocationInfo getLocationInfo(String locationName) {
        this.waitForGeocoding("getLocationInfo");
        OnmsMonitoringLocationDefinition def = this.m_locationDao.findMonitoringLocationDefinition(locationName);
        if (def == null) {
            LogUtils.warnf((Object)this, (String)"no monitoring location found for name %s", (Object[])new Object[]{locationName});
            return null;
        }
        return this.getLocationInfo(def, null);
    }

    @Override
    @Transactional
    public LocationInfo getLocationInfo(OnmsMonitoringLocationDefinition def, boolean includeStatus) {
        return includeStatus ? this.getLocationInfo(def, null) : this.getLocationInfo(def, StatusDetails.uninitialized());
    }

    @Override
    @Transactional
    public LocationInfo getLocationInfoForMonitor(Integer monitorId) {
        this.waitForGeocoding("getLocationInfoForMonitor");
        OnmsCriteria criteria = new OnmsCriteria(OnmsLocationMonitor.class).add((Criterion)Restrictions.eq((String)"id", (Object)monitorId));
        List monitors = this.m_locationDao.findMatching(criteria);
        if (monitors == null) {
            LogUtils.warnf((Object)this, (String)"unable to get location monitor list for monitor ID '%d'", (Object[])new Object[]{monitorId});
            return null;
        }
        String definitionName = ((OnmsLocationMonitor)monitors.get(0)).getDefinitionName();
        OnmsMonitoringLocationDefinition def = this.m_locationDao.findMonitoringLocationDefinition(definitionName);
        if (def == null) {
            LogUtils.warnf((Object)this, (String)"unable to find monitoring location definition for '%s'", (Object[])new Object[]{definitionName});
            return null;
        }
        return this.getLocationInfo(def, null);
    }

    @Transactional
    private LocationInfo getLocationInfo(OnmsMonitoringLocationDefinition def, StatusDetails status) {
        this.waitForGeocoding("getLocationInfo");
        if (def == null) {
            LogUtils.warnf((Object)this, (String)"no location definition specified", (Object[])new Object[0]);
            return null;
        }
        GWTLatLng latLng = this.getLatLng(def, false);
        if (latLng == null) {
            LogUtils.debugf((Object)this, (String)"no geolocation or coordinates found, using OpenNMS World HQ", (Object[])new Object[0]);
            latLng = new GWTLatLng(35.715751, -79.16262);
        } else {
            def.setCoordinates(latLng.getCoordinates());
        }
        GWTMarkerState state = new GWTMarkerState(def.getName(), latLng, status == null ? Status.UNINITIALIZED : status.getStatus());
        LocationInfo locationInfo = new LocationInfo(def.getName(), def.getPollingPackageName(), def.getArea(), def.getGeolocation(), latLng.getCoordinates(), def.getPriority(), state, status, def.getTags());
        if (status == null) {
            LocationDetails ld = this.getLocationDetails(def);
            StatusDetails monitorStatus = ld.getLocationMonitorState().getStatusDetails();
            state.setStatus(monitorStatus.getStatus());
            locationInfo.setStatusDetails(monitorStatus);
        }
        LogUtils.debugf((Object)this, (String)"getLocationInfo(%s) returning %s", (Object[])new Object[]{def.getName(), locationInfo.toString()});
        return locationInfo;
    }

    @Override
    @Transactional
    public ApplicationInfo getApplicationInfo(String applicationName) {
        this.waitForGeocoding("getApplicationInfo");
        OnmsApplication app = this.m_applicationDao.findByName(applicationName);
        if (app == null) {
            LogUtils.warnf((Object)this, (String)"no application found with name '%s'", (Object[])new Object[]{applicationName});
        }
        return this.getApplicationInfo(app, null);
    }

    @Override
    @Transactional
    public ApplicationInfo getApplicationInfo(OnmsApplication app, boolean includeStatus) {
        return includeStatus ? this.getApplicationInfo(app, null) : this.getApplicationInfo(app, StatusDetails.uninitialized());
    }

    @Transactional
    private ApplicationInfo getApplicationInfo(OnmsApplication app, StatusDetails status) {
        this.waitForGeocoding("getApplicationInfo");
        if (app == null) {
            LogUtils.warnf((Object)this, (String)"no application specified", (Object[])new Object[0]);
            return null;
        }
        TreeSet<GWTMonitoredService> services = new TreeSet<GWTMonitoredService>();
        TreeSet<String> locationNames = new TreeSet<String>();
        for (OnmsMonitoredService service : this.m_monitoredServiceDao.findByApplication(app)) {
            services.add(DefaultLocationDataService.transformMonitoredService(service));
        }
        for (OnmsLocationMonitor mon : this.m_locationDao.findByApplication(app)) {
            locationNames.add(mon.getDefinitionName());
        }
        ApplicationInfo applicationInfo = new ApplicationInfo(app.getId(), app.getName(), services, locationNames, status);
        if (status == null) {
            ApplicationDetails details = this.getApplicationDetails(app);
            applicationInfo.setStatusDetails(details.getStatusDetails());
        }
        LogUtils.debugf((Object)this, (String)"getApplicationInfo(%s) returning %s", (Object[])new Object[]{app.getName(), applicationInfo.toString()});
        return applicationInfo;
    }

    @Override
    @Transactional
    public LocationDetails getLocationDetails(String locationName) {
        this.waitForGeocoding("getLocationDetails");
        OnmsMonitoringLocationDefinition def = this.m_locationDao.findMonitoringLocationDefinition(locationName);
        if (def == null) {
            LogUtils.warnf((Object)this, (String)"no monitoring location found for name %s", (Object[])new Object[]{locationName});
            return null;
        }
        return this.getLocationDetails(def);
    }

    @Override
    @Transactional
    public LocationDetails getLocationDetails(OnmsMonitoringLocationDefinition def) {
        this.waitForGeocoding("getLocationDetails");
        LocationDetails ld = new LocationDetails();
        MonitorStatusTracker mst = new MonitorStatusTracker(def.getName());
        ApplicationStatusTracker ast = new ApplicationStatusTracker(def.getName());
        ArrayList<GWTLocationMonitor> monitors = new ArrayList<GWTLocationMonitor>();
        for (OnmsLocationMonitor mon : this.m_locationDao.findByLocationDefinition(def)) {
            monitors.add(DefaultLocationDataService.transformLocationMonitor(mon));
        }
        HashSet<ApplicationInfo> applications = new HashSet<ApplicationInfo>();
        HashMap<String, HashSet<OnmsMonitoredService>> services = new HashMap<String, HashSet<OnmsMonitoredService>>();
        for (OnmsApplication application : this.m_applicationDao.findAll()) {
            applications.add(DefaultLocationDataService.transformApplication(this.m_monitoredServiceDao.findByApplication(application), application));
        }
        for (OnmsMonitoredService service : this.m_monitoredServiceDao.findAll()) {
            for (OnmsApplication app : service.getApplications()) {
                String appName = app.getName();
                HashSet<OnmsMonitoredService> serv = (HashSet<OnmsMonitoredService>)services.get(appName);
                if (serv == null) {
                    serv = new HashSet<OnmsMonitoredService>();
                    services.put(appName, serv);
                }
                serv.add(service);
            }
        }
        Date to = new Date();
        Date from = new Date(to.getTime() - 86400000L);
        for (OnmsLocationSpecificStatus status : this.m_locationDao.getStatusChangesBetween(from, to)) {
            mst.onStatus(status);
            ast.onStatus(status);
        }
        ld.setLocationMonitorState(new LocationMonitorState(monitors, mst.drain()));
        ld.setApplicationState(new ApplicationState(from, to, applications, monitors, ast.drainStatuses()));
        LogUtils.debugf((Object)this, (String)"getLocationDetails(%s) returning %s", (Object[])new Object[]{def.getName(), ld});
        return ld;
    }

    @Override
    @Transactional
    public ApplicationDetails getApplicationDetails(String applicationName) {
        this.waitForGeocoding("getApplicationDetails");
        OnmsApplication app = this.m_applicationDao.findByName(applicationName);
        return this.getApplicationDetails(app);
    }

    @Override
    @Transactional
    public ApplicationDetails getApplicationDetails(OnmsApplication app) {
        this.waitForGeocoding("getApplicationDetails");
        ApplicationInfo applicationInfo = this.getApplicationInfo(app, false);
        ArrayList<GWTLocationSpecificStatus> statuses = new ArrayList<GWTLocationSpecificStatus>();
        Date to = new Date();
        Date from = new Date(to.getTime() - 86400000L);
        Collection services = this.m_monitoredServiceDao.findByApplication(app);
        ArrayList<GWTLocationMonitor> monitors = new ArrayList<GWTLocationMonitor>();
        for (OnmsLocationMonitor monitor : this.m_locationDao.findByApplication(app)) {
            monitors.add(DefaultLocationDataService.transformLocationMonitor(monitor));
            for (OnmsLocationSpecificStatus locationSpecificStatus : this.m_locationDao.getStatusChangesForLocationBetween(from, to, monitor.getDefinitionName())) {
                if (!services.contains(locationSpecificStatus.getMonitoredService())) continue;
                statuses.add(DefaultLocationDataService.transformLocationSpecificStatus(locationSpecificStatus));
            }
        }
        ApplicationDetails details = new ApplicationDetails(applicationInfo, from, to, monitors, statuses);
        LogUtils.warnf((Object)this, (String)"getApplicationDetails(%s) returning %s", (Object[])new Object[]{app.getName(), details});
        return details;
    }

    @Override
    @Transactional
    public Collection<LocationInfo> getUpdatedLocationsBetween(Date startDate, Date endDate) {
        this.waitForGeocoding("getApplicationDetails");
        ArrayList<LocationInfo> locations = new ArrayList<LocationInfo>();
        HashMap<String, OnmsMonitoringLocationDefinition> definitions = new HashMap<String, OnmsMonitoringLocationDefinition>();
        for (OnmsMonitoringLocationDefinition def : this.m_locationDao.findAllMonitoringLocationDefinitions()) {
            for (OnmsLocationMonitor mon : this.m_locationDao.findByLocationDefinition(def)) {
                OnmsLocationMonitor.MonitorStatus status = this.m_monitorStatuses.get(mon.getDefinitionName());
                if (status != null && status.equals((Object)mon.getStatus())) continue;
                definitions.put(def.getName(), def);
                this.m_monitorStatuses.put(def.getName(), mon.getStatus());
            }
        }
        for (OnmsLocationSpecificStatus status : this.m_locationDao.getStatusChangesBetween(startDate, endDate)) {
            String definitionName = status.getLocationMonitor().getDefinitionName();
            if (definitions.containsKey(definitionName)) continue;
            definitions.put(definitionName, this.m_locationDao.findMonitoringLocationDefinition(definitionName));
        }
        for (OnmsMonitoringLocationDefinition def : definitions.values()) {
            LocationInfo location = this.getLocationInfo(def, null);
            locations.add(location);
        }
        return locations;
    }

    @Override
    @Transactional
    public GWTLatLng getLatLng(OnmsMonitoringLocationDefinition def, boolean geocode) {
        String[] coordinates;
        GWTLatLng latLng = null;
        String coordinateMatchString = "^\\s*[\\-\\d\\.]+\\s*,\\s*[\\-\\d\\.]+\\s*$";
        if (def.getCoordinates() != null && def.getCoordinates().matches("^\\s*[\\-\\d\\.]+\\s*,\\s*[\\-\\d\\.]+\\s*$")) {
            coordinates = def.getCoordinates().split(",");
            latLng = new GWTLatLng(Double.valueOf(coordinates[0]), Double.valueOf(coordinates[1]));
        }
        if (latLng == null) {
            LogUtils.debugf((Object)this, (String)"using geolocation: %s", (Object[])new Object[]{def.getGeolocation()});
            if (def.getGeolocation() != null && def.getGeolocation().matches("^\\s*[\\-\\d\\.]+\\s*,\\s*[\\-\\d\\.]+\\s*$")) {
                coordinates = def.getGeolocation().split(",");
                latLng = new GWTLatLng(Double.valueOf(coordinates[0]), Double.valueOf(coordinates[1]));
            }
        }
        if (latLng == null && def.getGeolocation() != null && !def.getGeolocation().equals("")) {
            try {
                latLng = this.m_geocoder.geocode(def.getGeolocation());
                LogUtils.debugf((Object)this, (String)"got coordinates %s for geolocation %s", (Object[])new Object[]{latLng.getCoordinates(), def.getGeolocation()});
            }
            catch (GeocoderException e) {
                LogUtils.warnf((Object)this, (Throwable)e, (String)"unable to geocode %s", (Object[])new Object[]{def.getGeolocation()});
            }
        }
        return latLng;
    }

    @Override
    @Transactional
    public void handleAllMonitoringLocationDefinitions(Collection<LocationDefHandler> handlers) {
        this.waitForGeocoding("handleAllMonitoringLocationDefinitions");
        List definitions = this.m_locationDao.findAllMonitoringLocationDefinitions();
        for (LocationDefHandler handler : handlers) {
            handler.start(definitions.size());
        }
        for (OnmsMonitoringLocationDefinition def : definitions) {
            for (LocationDefHandler handler : handlers) {
                handler.handle(def);
            }
        }
        for (LocationDefHandler handler : handlers) {
            handler.finish();
        }
        this.m_locationDao.saveMonitoringLocationDefinitions((Collection)definitions);
    }

    @Override
    @Transactional
    public void handleAllApplications(Collection<ApplicationHandler> handlers) {
        this.waitForGeocoding("handleAllApplications");
        List apps = this.m_applicationDao.findAll();
        for (ApplicationHandler handler : handlers) {
            handler.start(apps.size());
        }
        for (OnmsApplication app : this.m_applicationDao.findAll()) {
            for (ApplicationHandler handler : handlers) {
                handler.handle(app);
            }
        }
        for (ApplicationHandler handler : handlers) {
            handler.finish();
        }
    }

    @Override
    @Transactional
    public Collection<ApplicationInfo> getApplicationsForLocation(LocationInfo locationInfo) {
        this.waitForGeocoding("getApplicationsForLocation");
        HashMap<String, ApplicationInfo> apps = new HashMap<String, ApplicationInfo>();
        for (OnmsLocationSpecificStatus status : this.m_locationDao.getMostRecentStatusChangesForLocation(locationInfo.getName())) {
            for (OnmsApplication app : status.getMonitoredService().getApplications()) {
                if (apps.containsKey(app.getName())) continue;
                apps.put(app.getName(), this.getApplicationInfo(app, true));
            }
        }
        return apps.values();
    }

    private void waitForGeocoding(String method) {
        if (this.m_initializationLatch.getCount() > 0L) {
            LogUtils.warnf((Object)this, (String)"%s() waiting for geocoding to finish", (Object[])new Object[]{method});
            try {
                this.m_initializationLatch.await();
            }
            catch (InterruptedException e) {
                LogUtils.warnf((Object)this, (Throwable)e, (String)"%s() interrupted while waiting for geocoding completion", (Object[])new Object[]{method});
                Thread.currentThread().interrupt();
            }
        }
    }

    private static GWTPollResult transformPollResult(PollStatus pollStatus) {
        GWTPollResult gResult = new GWTPollResult();
        gResult.setReason(pollStatus.getReason());
        gResult.setResponseTime(pollStatus.getResponseTime());
        gResult.setStatus(pollStatus.getStatusName());
        gResult.setTimestamp(pollStatus.getTimestamp());
        return gResult;
    }

    private static GWTMonitoredService transformMonitoredService(OnmsMonitoredService monitoredService) {
        GWTMonitoredService service = new GWTMonitoredService();
        service.setId(monitoredService.getId());
        OnmsIpInterface ipi = monitoredService.getIpInterface();
        if (ipi != null) {
            service.setIpInterfaceId(ipi.getId());
            if (ipi.getNode() != null) {
                service.setNodeId(ipi.getNode().getId());
            }
            service.setIpAddress(ipi.getIpAddress());
            service.setHostname(ipi.getIpHostName());
            OnmsSnmpInterface snmpi = ipi.getSnmpInterface();
            if (snmpi != null) {
                service.setIfIndex(snmpi.getIfIndex());
            }
        }
        service.setServiceName(monitoredService.getServiceName());
        return service;
    }

    private static GWTLocationSpecificStatus transformLocationSpecificStatus(OnmsLocationSpecificStatus status) {
        GWTLocationSpecificStatus gStatus = new GWTLocationSpecificStatus();
        gStatus.setId(status.getId());
        gStatus.setLocationMonitor(DefaultLocationDataService.transformLocationMonitor(status.getLocationMonitor()));
        gStatus.setPollResult(DefaultLocationDataService.transformPollResult(status.getPollResult()));
        gStatus.setMonitoredService(DefaultLocationDataService.transformMonitoredService(status.getMonitoredService()));
        return gStatus;
    }

    private static GWTLocationMonitor transformLocationMonitor(OnmsLocationMonitor monitor) {
        GWTLocationMonitor gMonitor = new GWTLocationMonitor();
        gMonitor.setId(monitor.getId());
        gMonitor.setDefinitionName(monitor.getDefinitionName());
        gMonitor.setName(monitor.getName());
        gMonitor.setStatus(monitor.getStatus().toString());
        gMonitor.setLastCheckInTime(monitor.getLastCheckInTime());
        return gMonitor;
    }

    private static ApplicationInfo transformApplication(Collection<OnmsMonitoredService> services, OnmsApplication application) {
        ApplicationInfo app = new ApplicationInfo();
        app.setId(application.getId());
        app.setName(application.getName());
        TreeSet<GWTMonitoredService> s = new TreeSet<GWTMonitoredService>();
        TreeSet<String> locations = new TreeSet<String>();
        for (OnmsMonitoredService service : services) {
            for (OnmsApplication oa : service.getApplications()) {
                locations.add(oa.getName());
            }
            s.add(DefaultLocationDataService.transformMonitoredService(service));
        }
        app.setServices(s);
        app.setLocations(locations);
        return app;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ApplicationStatusTracker
    implements StatusTracker {
        private String m_name;
        private Map<String, Collection<OnmsLocationSpecificStatus>> m_statuses = new HashMap<String, Collection<OnmsLocationSpecificStatus>>();

        public ApplicationStatusTracker(String name) {
            this.m_name = name;
        }

        @Override
        public void onStatus(OnmsLocationSpecificStatus status) {
            if (status.getLocationMonitor().getDefinitionName().equals(this.m_name)) {
                LogUtils.tracef((Object)this, (String)"(added) status code for %s/%s is %d", (Object[])new Object[]{status.getLocationMonitor().getDefinitionName(), status.getMonitoredService().getServiceName(), status.getStatusCode()});
                for (OnmsApplication app : status.getMonitoredService().getApplications()) {
                    Collection<OnmsLocationSpecificStatus> statuses = this.m_statuses.get(app.getName());
                    if (statuses == null) {
                        statuses = new ArrayList<OnmsLocationSpecificStatus>();
                    }
                    statuses.add(status);
                    this.m_statuses.put(app.getName(), statuses);
                }
            } else {
                LogUtils.tracef((Object)this, (String)"(skipped) status code for %s/%s is %d", (Object[])new Object[]{status.getLocationMonitor().getDefinitionName(), status.getMonitoredService().getServiceName(), status.getStatusCode()});
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Map<String, List<GWTLocationSpecificStatus>> drainStatuses() {
            HashMap<String, List<GWTLocationSpecificStatus>> statuses = new HashMap<String, List<GWTLocationSpecificStatus>>();
            Map<String, Collection<OnmsLocationSpecificStatus>> map = this.m_statuses;
            synchronized (map) {
                for (String app : statuses.keySet()) {
                    ArrayList<GWTLocationSpecificStatus> s = new ArrayList<GWTLocationSpecificStatus>();
                    for (OnmsLocationSpecificStatus status : this.m_statuses.get(app)) {
                        s.add(DefaultLocationDataService.transformLocationSpecificStatus(status));
                    }
                    statuses.put(app, s);
                }
                this.m_statuses.clear();
            }
            return statuses;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MonitorStatusTracker
    implements StatusTracker {
        private final transient Map<Integer, OnmsLocationSpecificStatus> m_statuses = new HashMap<Integer, OnmsLocationSpecificStatus>();
        private final transient String m_locationName;

        public MonitorStatusTracker(String locationName) {
            this.m_locationName = locationName;
        }

        @Override
        public void onStatus(OnmsLocationSpecificStatus status) {
            if (status.getLocationMonitor().getDefinitionName().equals(this.m_locationName)) {
                LogUtils.tracef((Object)this, (String)"(added) status code for %s/%s is %d", (Object[])new Object[]{status.getLocationMonitor().getDefinitionName(), status.getMonitoredService().getServiceName(), status.getStatusCode()});
                this.m_statuses.put(status.getMonitoredService().getId(), status);
            } else {
                LogUtils.tracef((Object)this, (String)"(skipped) status code for %s/%s is %d", (Object[])new Object[]{status.getLocationMonitor().getDefinitionName(), status.getMonitoredService().getServiceName(), status.getStatusCode()});
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Collection<GWTLocationSpecificStatus> drain() {
            ArrayList<GWTLocationSpecificStatus> statuses = new ArrayList<GWTLocationSpecificStatus>();
            Map<Integer, OnmsLocationSpecificStatus> map = this.m_statuses;
            synchronized (map) {
                for (OnmsLocationSpecificStatus status : this.m_statuses.values()) {
                    statuses.add(DefaultLocationDataService.transformLocationSpecificStatus(status));
                }
                this.m_statuses.clear();
            }
            return statuses;
        }
    }

    private static interface StatusTracker {
        public void onStatus(OnmsLocationSpecificStatus var1);
    }

    private class InitializationThread
    extends Thread {
        public void run() {
            LogUtils.infof((Object)this, (String)"geolocating monitoring location definitions", (Object[])new Object[0]);
            List definitions = DefaultLocationDataService.this.m_locationDao.findAllMonitoringLocationDefinitions();
            for (OnmsMonitoringLocationDefinition def : definitions) {
                GWTLatLng latLng = DefaultLocationDataService.this.getLatLng(def, true);
                if (latLng == null) continue;
                def.setCoordinates(latLng.getCoordinates());
            }
            if (DefaultLocationDataService.this.m_save) {
                DefaultLocationDataService.this.m_locationDao.saveMonitoringLocationDefinitions((Collection)definitions);
            }
            LogUtils.infof((Object)this, (String)"finished geolocating monitoring location definitions", (Object[])new Object[0]);
            DefaultLocationDataService.this.m_initializationLatch.countDown();
        }
    }
}

