/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.poller.remote.gwt.server;

import de.novanic.eventservice.client.event.Event;
import de.novanic.eventservice.service.EventExecutorService;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.opennms.core.utils.LogUtils;
import org.opennms.features.poller.remote.gwt.client.ApplicationInfo;
import org.opennms.features.poller.remote.gwt.client.RemotePollerPresenter;
import org.opennms.features.poller.remote.gwt.client.remoteevents.ApplicationRemovedRemoteEvent;
import org.opennms.features.poller.remote.gwt.client.remoteevents.ApplicationUpdatedRemoteEvent;
import org.opennms.features.poller.remote.gwt.client.remoteevents.MapRemoteEvent;
import org.opennms.features.poller.remote.gwt.server.ApplicationHandler;
import org.opennms.features.poller.remote.gwt.server.LocationDataService;
import org.opennms.netmgt.model.OnmsApplication;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultApplicationHandler
implements ApplicationHandler {
    private LocationDataService m_locationDataService;
    private EventExecutorService m_eventService;
    private boolean m_includeStatus = false;
    private Set<String> m_oldApplicationNames = null;
    private Set<String> m_foundApplicationNames = new HashSet<String>();

    public DefaultApplicationHandler() {
    }

    public DefaultApplicationHandler(LocationDataService locationDataService, EventExecutorService eventService, boolean includeStatus) {
        this.m_locationDataService = locationDataService;
        this.m_eventService = eventService;
        this.m_includeStatus = includeStatus;
    }

    public DefaultApplicationHandler(LocationDataService locationDataService, EventExecutorService eventService, boolean includeStatus, Collection<String> currentApplications) {
        this(locationDataService, eventService, includeStatus);
        if (currentApplications != null) {
            this.m_oldApplicationNames = new HashSet<String>(currentApplications);
        }
    }

    @Override
    public void start(int size) {
    }

    @Override
    public void handle(OnmsApplication application) {
        ApplicationInfo applicationInfo = this.m_locationDataService.getApplicationInfo(application, this.m_includeStatus);
        ApplicationUpdatedRemoteEvent event = new ApplicationUpdatedRemoteEvent(applicationInfo);
        this.sendEvent(event);
        if (this.m_oldApplicationNames != null) {
            this.m_oldApplicationNames.remove(application.getName());
        }
        this.m_foundApplicationNames.add(application.getName());
    }

    @Override
    public void finish() {
        if (this.m_oldApplicationNames != null) {
            for (String appName : this.m_oldApplicationNames) {
                this.sendEvent(new ApplicationRemovedRemoteEvent(appName));
            }
        }
    }

    public Set<String> getApplicationNames() {
        return this.m_foundApplicationNames;
    }

    protected void sendEvent(MapRemoteEvent event) {
        LogUtils.debugf((Object)this, (String)"sending event: %s", (Object[])new Object[]{event});
        this.getEventService().addEvent(RemotePollerPresenter.LOCATION_EVENT_DOMAIN, (Event)event);
    }

    protected EventExecutorService getEventService() {
        return this.m_eventService;
    }
}

