/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.poller.remote.gwt.client.utils;

import java.util.Comparator;
import java.util.Date;
import java.util.Set;
import java.util.TreeSet;
import org.opennms.features.poller.remote.gwt.client.utils.CompareToBuilder;
import org.opennms.features.poller.remote.gwt.client.utils.Interval;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntervalUtils {
    public static Set<Interval> invert(Date beginning, Date end, Set<Interval> intervals) {
        Interval interval;
        if (intervals.size() == 0) {
            Set<Interval> newIntervals = IntervalUtils.getIntervalSet();
            newIntervals.add(new Interval(beginning.getTime(), end.getTime()));
            return newIntervals;
        }
        if (intervals.size() == 1 && (interval = intervals.iterator().next()).getStartMillis() == beginning.getTime() && interval.getEndMillis() == end.getTime()) {
            return IntervalUtils.getIntervalSet();
        }
        Set<Interval> preIntervals = IntervalUtils.getIntervalSet();
        preIntervals.addAll(intervals);
        Set<Interval> invertedIntervals = IntervalUtils.getIntervalSet();
        Interval lastInterval = null;
        for (Interval interval2 : preIntervals) {
            Interval i;
            if (lastInterval == null) {
                if (interval2.getStartMillis() > beginning.getTime()) {
                    i = new Interval(beginning.getTime(), interval2.getStartMillis());
                    invertedIntervals.add(i);
                }
                lastInterval = new Interval(interval2.getEndMillis(), interval2.getEndMillis());
                continue;
            }
            if (interval2.getStartMillis() <= lastInterval.getEndMillis()) continue;
            i = new Interval(lastInterval.getStartMillis(), interval2.getStartMillis());
            invertedIntervals.add(i);
            lastInterval = new Interval(interval2.getEndMillis(), interval2.getEndMillis());
        }
        if (lastInterval != null && lastInterval.getEndMillis() < end.getTime()) {
            Interval i = new Interval(lastInterval.getEndMillis(), end.getTime());
            invertedIntervals.add(i);
        } else if (lastInterval == null) {
            invertedIntervals.add(new Interval(beginning.getTime(), end.getTime()));
        }
        return invertedIntervals;
    }

    public static Set<Interval> normalize(Set<Interval> intervals) {
        Interval lastInterval = null;
        Set<Interval> preIntervals = IntervalUtils.getIntervalSet();
        preIntervals.addAll(intervals);
        Set<Interval> combinedIntervals = IntervalUtils.getIntervalSet();
        for (Interval interval : preIntervals) {
            if (lastInterval == null) {
                lastInterval = interval;
                continue;
            }
            if (interval.overlaps(lastInterval)) {
                lastInterval = new Interval(Math.min(lastInterval.getStartMillis(), interval.getStartMillis()), Math.max(lastInterval.getEndMillis(), interval.getEndMillis()));
                continue;
            }
            combinedIntervals.add(lastInterval);
            lastInterval = interval;
        }
        if (lastInterval != null) {
            combinedIntervals.add(lastInterval);
        }
        return combinedIntervals;
    }

    public static Set<Interval> getIntervalSet() {
        return new TreeSet<Interval>(new Comparator<Interval>(){

            @Override
            public int compare(Interval o1, Interval o2) {
                return new CompareToBuilder().append(o1.getStartMillis(), o2.getStartMillis()).append(o1.getEndMillis(), o2.getEndMillis()).toComparison();
            }
        });
    }
}

