/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.poller.remote.gwt.client.utils;

import org.opennms.features.poller.remote.gwt.client.GWTBounds;
import org.opennms.features.poller.remote.gwt.client.GWTLatLng;

public class BoundsBuilder {
    Double neLat;
    Double neLng;
    Double swLat;
    Double swLng;

    public GWTBounds getBounds() {
        return this.isEmpty() ? new GWTBounds(-90.0, -180.0, 90.0, 180.0) : new GWTBounds(this.swLat, this.swLng, this.neLat, this.neLng);
    }

    private boolean isEmpty() {
        return this.neLat == null;
    }

    public void extend(double lat, double lng) {
        if (this.isEmpty()) {
            this.swLat = this.neLat = Double.valueOf(lat);
            this.swLng = this.neLng = Double.valueOf(lng);
        } else {
            this.swLat = Math.min(this.swLat, lat);
            this.neLat = Math.max(this.neLat, lat);
            if (!this.containsLongitude(lng)) {
                if (this.distanceEast(lng) < this.distanceWest(lng)) {
                    this.neLng = lng;
                } else {
                    this.swLng = lng;
                }
            }
        }
    }

    public void extend(GWTLatLng coords) {
        this.extend(coords.getLatitude(), coords.getLongitude());
    }

    private boolean containsLongitude(double lng) {
        if (this.swLng <= this.neLng) {
            return this.swLng <= lng && lng <= this.neLng;
        }
        return !(this.neLng < lng) || !(lng < this.swLng);
    }

    public double distanceEast(double lng) {
        return lng > this.neLng ? lng - this.neLng : lng + 360.0 - this.neLng;
    }

    public double distanceWest(double lng) {
        return this.swLng > lng ? this.swLng - lng : this.swLng + 360.0 - lng;
    }
}

